/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.util.Check;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SingleInstanceJFrame
extends JFrame
implements Constants {
    public static final String OK = "OK";
    public static final String CANCEL = "CANCEL";
    public static final int DEFAULT_TIMEOUT = 1000;
    RunnableComponent rc;
    JLabel splashLabel;
    String project;
    Options options;
    boolean trace;
    String playerClass;
    SocketThread socketThread;
    boolean initializing = true;
    boolean armed;

    public SingleInstanceJFrame(String playerClass, String[] args, String windowTitle, String logoIcon, String frameIcon, int port) {
        this.setDefaultCloseOperation(0);
        this.playerClass = playerClass;
        this.options = new Options(this);
        this.project = SingleInstanceJFrame.loadArgs(args, this.options);
        if (!this.checkOtherInstance(port)) {
            this.build(playerClass, args, windowTitle, frameIcon, logoIcon);
            this.armed = true;
        }
    }

    public boolean isArmed() {
        return this.armed;
    }

    public static String loadArgs(String[] args, Options options) {
        String result = null;
        for (String arg : args) {
            if (arg == null || arg.length() <= 0) continue;
            if (arg.startsWith("-")) {
                String key;
                String value = null;
                int k = arg.indexOf(61);
                if (k > 0) {
                    key = arg.substring(1, k);
                    value = arg.substring(k + 1);
                } else {
                    key = arg.substring(1);
                }
                options.put(key, value);
                continue;
            }
            result = arg;
        }
        return result;
    }

    protected void build(String playerClass, String[] args, String windowTitle, String frameIcon, String logoIcon) {
        this.trace = this.options.getBoolean("trace");
        if (this.trace) {
            for (String arg : args) {
                System.out.println(arg);
            }
        }
        this.initComponents();
        this.setTitle(windowTitle);
        if (frameIcon != null) {
            this.setIconImage(ResourceManager.getImageIcon(frameIcon).getImage());
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int scrW = (int)screenSize.getWidth();
        int scrH = (int)screenSize.getHeight();
        this.splashLabel = new JLabel(" ", ResourceManager.getImageIcon(logoIcon), 0);
        this.splashLabel.setVerticalTextPosition(3);
        this.splashLabel.setHorizontalTextPosition(0);
        this.splashLabel.setBackground(BG_COLOR);
        this.splashLabel.setOpaque(true);
        this.getContentPane().add((Component)this.splashLabel, "Center");
        this.pack();
        this.setBounds((scrW - this.getWidth()) / 2, (scrH - this.getHeight()) / 3, scrW - 40, scrH - 80);
        this.setLocation((scrW - this.getWidth()) / 2, (scrH - this.getHeight()) / 3);
        if (Check.checkSignature(this.options, true)) {
            this.init();
        } else {
            System.exit(0);
        }
    }

    protected void init() {
        final SingleInstanceJFrame rpc = this;
        SwingWorker sw = new SwingWorker(){
            final StringBuilder sb = new StringBuilder();

            @Override
            public Object construct() {
                try {
                    Messages messages = PersistentSettings.getMessages(SingleInstanceJFrame.this.options, "messages.JClicMessages");
                    messages.addBundle("commonSettings");
                    if (SingleInstanceJFrame.this.splashLabel != null) {
                        SingleInstanceJFrame.this.splashLabel.setText(messages.get("LOADING"));
                    }
                    Class<?> c = Class.forName(SingleInstanceJFrame.this.playerClass);
                    Constructor<?> cons = c.getConstructor(Options.class);
                    SingleInstanceJFrame.this.rc = (RunnableComponent)cons.newInstance(SingleInstanceJFrame.this.options);
                }
                catch (Exception ex) {
                    this.sb.append("ERROR: Unable to start!\n").append(ex);
                    ex.printStackTrace(System.err);
                }
                return SingleInstanceJFrame.this.rc;
            }

            @Override
            public void finished() {
                if (this.getValue() == null) {
                    if (SingleInstanceJFrame.this.splashLabel != null) {
                        String s = this.sb.substring(0);
                        SingleInstanceJFrame.this.splashLabel.setText(s);
                        System.err.println(s);
                    }
                } else {
                    SingleInstanceJFrame.this.getContentPane().removeAll();
                    SingleInstanceJFrame.this.splashLabel = null;
                    SingleInstanceJFrame.this.rc.addTo(rpc, "Center");
                    SingleInstanceJFrame.this.getRootPane().revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleInstanceJFrame.this.rc.start(SingleInstanceJFrame.this.project, null);
                            SingleInstanceJFrame.this.initializing = false;
                        }
                    });
                }
            }
        };
        if (this.trace) {
            System.out.println(">>> initializing...");
        }
        sw.start();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (SingleInstanceJFrame.this.rc == null || SingleInstanceJFrame.this.rc.windowCloseRequested()) {
                    if (SingleInstanceJFrame.this.socketThread != null) {
                        SingleInstanceJFrame.this.socketThread.stopSocketThread();
                    }
                    if (SingleInstanceJFrame.this.rc != null) {
                        SingleInstanceJFrame.this.rc.end();
                        SingleInstanceJFrame.this.rc = null;
                    }
                    SingleInstanceJFrame.this.dispose();
                }
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                if (SingleInstanceJFrame.this.rc != null) {
                    SingleInstanceJFrame.this.rc.activate();
                }
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                SingleInstanceJFrame.this.exitForm(evt);
            }
        });
    }

    private void exitForm(WindowEvent evt) {
        if (this.socketThread != null) {
            this.socketThread.stopSocketThread();
        }
        if (this.rc != null) {
            this.rc.end();
            this.rc = null;
        }
        while (this.socketThread != null) {
            Thread.yield();
        }
        System.exit(0);
    }

    protected boolean checkOtherInstance(int port) {
        boolean result = false;
        try {
            this.socketThread = new SocketThread(port, 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.socketThread == null) {
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), port);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                pw.println(this.playerClass);
                pw.println(StrUtils.secureString(this.project));
                pw.println("");
                pw.flush();
                String response = in.readLine();
                result = OK.equals(response);
                socket.close();
            }
            catch (Exception ex) {
                System.err.println("Socket error: " + ex);
            }
        } else {
            result = false;
            this.socketThread.start();
        }
        return result;
    }

    protected class SocketThread
    extends Thread {
        boolean running;
        boolean inService;
        boolean forceSocketClose;
        ServerSocket ss;
        int socketTimeOut;

        SocketThread(int port, int timeOut) throws IOException {
            this.ss = new ServerSocket(port);
            this.socketTimeOut = timeOut;
            this.running = false;
        }

        @Override
        public void run() {
            block7: {
                try {
                    this.running = true;
                    this.ss.setSoTimeout(1000);
                    while (this.running) {
                        try {
                            this.inService = false;
                            Socket socket = this.ss.accept();
                            this.inService = true;
                            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                            String skPlayerClass = StrUtils.secureString(in.readLine());
                            String skArg1 = StrUtils.nullableString(in.readLine());
                            String skArg2 = StrUtils.nullableString(in.readLine());
                            boolean result = SingleInstanceJFrame.this.rc != null && !SingleInstanceJFrame.this.initializing && skPlayerClass.equals(SingleInstanceJFrame.this.playerClass) && skArg1 != null;
                            pw.println(result ? SingleInstanceJFrame.OK : SingleInstanceJFrame.CANCEL);
                            pw.flush();
                            socket.close();
                            if (!result) continue;
                            SingleInstanceJFrame.this.rc.newInstanceRequest(skArg1, skArg2);
                        }
                        catch (InterruptedIOException socket) {
                        }
                        catch (Exception ex) {
                            if (!this.forceSocketClose) {
                                System.err.println("Socket error: " + ex);
                            }
                            this.running = false;
                        }
                    }
                    this.forceSocketClose = true;
                    this.ss.close();
                }
                catch (IOException ex) {
                    if (this.forceSocketClose) break block7;
                    System.err.println("Server socket error: " + ex);
                }
            }
            this.running = false;
            this.inService = false;
            SingleInstanceJFrame.this.socketThread = null;
        }

        public void stopSocketThread() {
            if (this.inService) {
                this.running = false;
            } else {
                try {
                    this.forceSocketClose = true;
                    this.ss.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    SingleInstanceJFrame.this.socketThread = null;
                    this.running = false;
                }
            }
        }
    }
}

