/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.BasicEvaluator;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class ComplexEvaluator
extends BasicEvaluator {
    public static final String DETAIL = "detail";
    public static final String CHECK_STEPS = "checkSteps";
    public static final int DEFAULT_CHECK_STEPS = 3;
    public static final String CHECK_SCOPE = "checkScope";
    public static final int DEFAULT_CHECK_SCOPE = 6;
    protected boolean detail = true;
    protected int checkSteps = 3;
    protected int checkScope = 6;

    public ComplexEvaluator(JClicProject project) {
        super(project);
    }

    @Override
    public Element getJDomElement() {
        Element e = super.getJDomElement();
        if (!this.detail) {
            e.setAttribute(DETAIL, JDomUtility.boolString(this.detail));
        }
        if (this.checkSteps != 3) {
            e.setAttribute(CHECK_STEPS, Integer.toString(this.checkSteps));
        }
        if (this.checkScope != 6) {
            e.setAttribute(CHECK_SCOPE, Integer.toString(this.checkScope));
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        this.detail = JDomUtility.getBoolAttr(e, DETAIL, true);
        this.checkSteps = JDomUtility.getIntAttr(e, CHECK_STEPS, 3);
        this.checkScope = JDomUtility.getIntAttr(e, CHECK_SCOPE, 6);
    }

    @Override
    public void setProperties(Clic3Activity c3a) {
        super.setProperties(c3a);
        this.detail = c3a.avLletra;
        this.checkSteps = c3a.avScope;
        this.checkScope = c3a.avMaxScope;
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public byte[] evalText(String text, String[] match) {
        int i;
        if (!this.detail) {
            return super.evalText(text, match);
        }
        int[] numChecks = new int[match.length];
        int maxCheck = -1;
        int maxCheckIndex = -1;
        byte[][] flags = new byte[match.length][];
        boolean[] skipped = new boolean[text.length()];
        String sText = this.getClearedText(text, skipped);
        for (i = 0; i < match.length; ++i) {
            String sMatch = this.getClearedText(match[i]);
            flags[i] = new byte[sText.length()];
            boolean ok = this.compareSegment(sText, sText.length(), match[i], match[i].length(), flags[i], false);
            numChecks[i] = this.countFlagsOk(flags[i]);
            if (!ok) continue;
            maxCheckIndex = i;
            maxCheck = numChecks[i];
        }
        if (maxCheckIndex == -1) {
            for (i = 0; i < match.length; ++i) {
                if (numChecks[i] <= maxCheck) continue;
                maxCheck = numChecks[i];
                maxCheckIndex = i;
            }
        }
        byte[] returnFlags = new byte[text.length()];
        int k = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            returnFlags[i2] = skipped[i2] ? (byte)0 : flags[maxCheckIndex][k++];
        }
        return returnFlags;
    }

    private int countFlagsOk(byte[] flags) {
        int r = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != 0) continue;
            ++r;
        }
        return r;
    }

    private boolean compareSegment(String src, int ls, String ok, int lok, byte[] attr, boolean iterate) {
        boolean lastiok = true;
        boolean result = true;
        int coinci = 0;
        if (ls == 0 || lok == 0 || src == null || ok == null) {
            return false;
        }
        int lastIs = 0;
        int iok = 0;
        int is = 0;
        while (is < ls) {
            char chs = src.charAt(is);
            lastIs = is;
            char chok = iok >= 0 && iok < lok ? ok.charAt(iok) : (char)'\u0000';
            if (this.collator.equals(new String(new char[]{chs}), new String(new char[]{chok}))) {
                ++coinci;
                attr[is] = 0;
                lastiok = true;
            } else {
                result = false;
                attr[is] = 1;
                if (!iterate && lastiok && chok != '\u0000' && this.checkSteps > 0 && this.checkScope > 0) {
                    int j;
                    int lbloc = 2 * this.checkSteps + 1;
                    int[] itcoinc = new int[lbloc];
                    int i = 0;
                    for (j = 0; j < lbloc; ++j) {
                        int is2;
                        itcoinc[j] = 0;
                        i = iok + (j + 1) / 2 * ((j & 1) != 0 ? 1 : -1);
                        if (i >= lok) continue;
                        int n = is2 = i < 0 ? is - i : is;
                        if (is2 >= ls) continue;
                        int ls2 = ls - is2;
                        ls2 = ls2 > this.checkScope ? this.checkScope : ls2;
                        int iok2 = i < 0 ? 0 : i;
                        int lok2 = lok - iok2;
                        lok2 = lok2 > this.checkScope ? this.checkScope : lok2;
                        byte[] flags2 = new byte[src.length() - is2];
                        boolean result2 = this.compareSegment(src.substring(is2), ls2, ok.substring(iok2), lok2, flags2, true);
                        itcoinc[j] = this.countFlagsOk(flags2);
                        if (result2) break;
                    }
                    if (j == lbloc) {
                        int jmax = this.checkSteps;
                        for (j = 0; j < lbloc; ++j) {
                            if (itcoinc[j] <= itcoinc[jmax]) continue;
                            jmax = j;
                        }
                        i = iok + (jmax + 1) / 2 * ((jmax & 1) != 0 ? 1 : -1);
                    } else if (itcoinc[j] > 0) {
                        ++coinci;
                    }
                    iok = i;
                    lastiok = false;
                }
            }
            ++is;
            ++iok;
        }
        if (iok != lok) {
            result = false;
            attr[lastIs] = 1;
        }
        return result;
    }
}

