/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.util.FontCheck;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.jdom.Attribute;

public class TextActivityDocument
extends DefaultStyledDocument {
    public static final int NUM_TABS = 30;
    public static final int DEFAULT_TAB = 12;
    public static final Color DEFAULT_TARGET_COLOR = Color.blue;
    public static final Color DEFAULT_TARGET_ERROR_COLOR = Color.red;
    public static final String TARGET = "target";
    public static final String TARGET_ERROR = "targetError";
    public static final String FILL = "fill";
    public static final int TT_FREE = 0;
    public static final int TT_CHAR = 1;
    public static final int TT_WORD = 2;
    public static final int TT_PARAGRAPH = 3;
    protected int tabSpc = 12;
    protected int lastBoxId = 0;
    protected StyleContext styleContext;
    public TargetMarkerBag tmb;
    public ActiveBagContent boxesContent;
    public ActiveBagContent popupsContent;
    protected int targetType = 0;
    public static final String ELEMENT_NAME = "document";
    public static final String STYLE = "style";
    public static final String TABSPC = "tabWidth";
    public static final String TEXT = "text";
    public static final String P = "p";
    public static final String BASE = "base";
    public static final String NAME = "name";

    public TextActivityDocument(StyleContext sc) {
        super(sc);
        this.styleContext = sc;
        TextActivityDocument.checkStyleContext(this.styleContext);
        this.tmb = new TargetMarkerBag();
        this.boxesContent = new ActiveBagContent(1, 1);
        this.popupsContent = new ActiveBagContent(1, 1);
    }

    public static void checkStyleContext(StyleContext sc) {
        Style targetErrorStyle;
        Style targetStyle = sc.getStyle(TARGET);
        if (targetStyle == null) {
            targetStyle = sc.addStyle(TARGET, sc.getStyle("default"));
            StyleConstants.setForeground(targetStyle, DEFAULT_TARGET_COLOR);
            targetStyle.addAttribute(TARGET, Boolean.TRUE);
        }
        if ((targetErrorStyle = sc.getStyle(TARGET_ERROR)) == null) {
            targetErrorStyle = sc.addStyle(TARGET_ERROR, targetStyle);
            StyleConstants.setForeground(targetErrorStyle, DEFAULT_TARGET_ERROR_COLOR);
        }
    }

    public void readClic3Data(Clic3Activity c3a, TextActivityBase tab) throws Exception {
        BoxBase bb = c3a.getBoxBase(0);
        this.boxesContent.setBoxBase(c3a.getBoxBase(1));
        this.popupsContent.setBoxBase(c3a.getBoxBase(3));
        Style regular = TextActivityDocument.boxBaseToStyledDocument(bb, this);
        this.setTabSpc(c3a.tabSpc);
        Style targetStyle = this.getStyle(TARGET);
        StyleConstants.setBackground(targetStyle, c3a.colorUsuari[1]);
        StyleConstants.setForeground(targetStyle, c3a.colorUsuari[0]);
        Style targetError = this.getStyle(TARGET_ERROR);
        StyleConstants.setBackground(targetError, c3a.colorError[1]);
        StyleConstants.setForeground(targetError, c3a.colorError[0]);
        boolean multiTarget = c3a.puzMode == 0;
        StringBuilder sb = new StringBuilder();
        sb.append('\u008e').append('\u008f');
        StringTokenizer st = new StringTokenizer(c3a.txBase, sb.substring(0), true);
        boolean intoBlock = false;
        boolean intoTarget = false;
        TargetMarker tm = null;
        int targetElementCount = 0;
        boolean k = false;
        int w = 0;
        int h = 0;
        boolean leftAlign = false;
        boolean onlyPlay = false;
        block10: while (st.hasMoreTokens() || intoTarget) {
            String t;
            try {
                t = st.nextToken();
            }
            catch (NoSuchElementException ex) {
                t = new String(new char[]{'\u008f'});
                targetElementCount = 6;
            }
            if (t.charAt(0) == '\u008e') {
                intoBlock = !intoBlock;
                continue;
            }
            if (t.charAt(0) == '\u008f') {
                if (multiTarget) {
                    if (++targetElementCount == 1) {
                        tm = new TargetMarker(this);
                        tm.target = new TextTarget();
                        tm.begOffset = this.getLength();
                    }
                    if (targetElementCount > 6) {
                        targetElementCount = 0;
                        intoTarget = false;
                        if (tm == null) continue;
                        tm.endOffset = this.getLength();
                        this.tmb.add(tm);
                        continue;
                    }
                    intoTarget = true;
                    continue;
                }
                boolean bl = intoTarget = !intoTarget;
                if (intoTarget) {
                    tm = new TargetMarker(this);
                    tm.begOffset = this.getLength();
                    continue;
                }
                if (tm == null) continue;
                tm.endOffset = this.getLength();
                this.tmb.add(tm);
                continue;
            }
            if (intoBlock) {
                ActiveBoxContent ab = new ActiveBoxContent();
                StringTokenizer stb = new StringTokenizer(t, ",");
                w = Integer.parseInt(stb.nextToken());
                h = Integer.parseInt(stb.nextToken());
                ab.setDimension(new Dimension(w, h));
                ab.setBorder(Integer.parseInt(stb.nextToken()) != 0);
                boolean b = Integer.parseInt(stb.nextToken()) != 0;
                ab.txtAlign[0] = b ? 0 : 1;
                ab.imgAlign[0] = ab.txtAlign[0];
                c3a.setActiveBoxTextContent(ab, stb.nextToken("").substring(1));
                ab.setBoxBase(this.boxesContent.bb);
                ab.userData = this.getEndPosition();
                this.boxesContent.addActiveBoxContent(ab);
                JPanelActiveBox jpab = new JPanelActiveBox(null, null, tab.getProject().getBridge().getComponent());
                jpab.setAlignmentY(0.9f);
                jpab.setActiveBoxContent(ab);
                SimpleAttributeSet attr = new SimpleAttributeSet(regular);
                StyleConstants.setComponent(attr, jpab);
                this.insertString(this.getLength(), " ", attr);
                continue;
            }
            if (intoTarget) {
                if (targetElementCount == 0) {
                    this.insertString(this.getLength(), t, this.getStyle(TARGET));
                    continue;
                }
                switch (targetElementCount) {
                    case 1: {
                        StringTokenizer stx = new StringTokenizer(t, ",");
                        if (tm != null) {
                            tm.target.iniChar = stx.nextToken().charAt(0);
                            tm.target.isList = stx.nextToken().compareTo("1") == 0;
                            tm.target.numIniChars = Integer.parseInt(stx.nextToken());
                            tm.target.maxLenResp = Integer.parseInt(stx.nextToken());
                            tm.target.infoMode = Integer.parseInt(stx.nextToken());
                            int v = Integer.parseInt(stx.nextToken());
                            tm.target.popupDelay = v & 0xFF;
                            tm.target.popupMaxTime = (v & 0xFF00) >> 8;
                        }
                        w = Integer.parseInt(stx.nextToken());
                        h = Integer.parseInt(stx.nextToken());
                        int flags = Integer.parseInt(stx.nextToken());
                        leftAlign = (flags & 1) == 1;
                        onlyPlay = (flags & 2) == 2;
                        break;
                    }
                    case 2: {
                        if (tm == null || t.length() <= 0) break;
                        tm.target.setAnswer(t);
                        break;
                    }
                    case 3: {
                        StringTokenizer sty = new StringTokenizer(t, "\n\r");
                        ArrayList<String> al = new ArrayList<String>();
                        while (sty.hasMoreTokens()) {
                            String s = sty.nextToken();
                            if (s.length() <= 0) continue;
                            al.add(s);
                        }
                        if (tm == null || al.size() <= 0) break;
                        tm.target.options = new String[al.size()];
                        for (int i = 0; i < al.size(); ++i) {
                            tm.target.options[i] = (String)al.get(i);
                        }
                        continue block10;
                    }
                    case 4: {
                        if (tm == null || t.length() <= 0) break;
                        tm.target.iniText = t;
                        break;
                    }
                    case 5: {
                        if (tm == null || t.length() <= 0) break;
                        tm.target.popupContent = new ActiveBoxContent();
                        tm.target.popupContent.setDimension(new Dimension(w, h));
                        c3a.setActiveBoxTextContent(tm.target.popupContent, t);
                        tm.target.popupContent.setBoxBase(this.popupsContent.bb);
                        tm.target.popupContent.txtAlign[0] = leftAlign ? 0 : 1;
                        tm.target.popupContent.imgAlign[0] = tm.target.popupContent.txtAlign[0];
                        tm.target.onlyPlay = onlyPlay;
                        this.popupsContent.addActiveBoxContent(tm.target.popupContent);
                        break;
                    }
                    case 6: {
                        this.insertString(this.getLength(), t, this.getStyle(TARGET));
                    }
                }
                continue;
            }
            this.insertString(this.getLength(), t, this.getStyle("default"));
        }
        this.tmb.setPositions();
    }

    public static JPanelActiveBox insertBox(ActiveBoxContent ab, int atPos, TextActivityDocument doc, TextActivityBase tab, AttributeSet atr) throws Exception {
        if (atr == null) {
            atr = doc.getStyle("default");
        }
        if (atPos < 0) {
            atPos = doc.getLength();
        }
        doc.boxesContent.addActiveBoxContent(ab);
        JPanelActiveBox jpab = new JPanelActiveBox(null, ab.bb, tab.getProject().getBridge().getComponent());
        jpab.setAlignmentY(0.9f);
        jpab.setActiveBoxContent(ab);
        SimpleAttributeSet satr = new SimpleAttributeSet(atr);
        StyleConstants.setComponent(satr, jpab);
        doc.insertString(atPos, " ", satr);
        return jpab;
    }

    public static Style boxBaseToStyledDocument(BoxBase bb, StyledDocument sd) {
        Style style = sd.getStyle("default");
        TextActivityDocument.boxBaseToStyle(bb, style);
        return style;
    }

    public static void boxBaseToStyle(BoxBase bb, Style st) {
        StyleConstants.setFontFamily(st, bb.getFont().getFamily());
        StyleConstants.setFontSize(st, bb.getFont().getSize());
        StyleConstants.setBold(st, bb.getFont().isBold());
        StyleConstants.setItalic(st, bb.getFont().isItalic());
        StyleConstants.setBackground(st, bb.backColor);
        StyleConstants.setForeground(st, bb.textColor);
    }

    public void setTabSpc(int newTabSpc) {
        this.tabSpc = newTabSpc;
        TextActivityDocument.setStyledDocumentTabSpc(this.tabSpc, this, this.styleContext);
    }

    protected static AttributeSet getAttributes(TextActivityDocument doc, AttributeSet a, org.jdom.Element e) throws Exception {
        Style style;
        int nAttributes = e.getAttributes().size();
        if (nAttributes < 1) {
            return a;
        }
        String parentStyle = e.getAttributeValue(STYLE);
        Style style2 = style = parentStyle != null ? doc.getStyle(parentStyle) : null;
        if (style != null && nAttributes == 1) {
            return style;
        }
        SimpleAttributeSet atr = new SimpleAttributeSet();
        atr.setResolveParent(style != null ? style : a);
        TextActivityDocument.fillAttributes(atr, e);
        return atr;
    }

    protected static void fillAttributes(MutableAttributeSet a, org.jdom.Element e) throws Exception {
        List atrList = e.getAttributes();
        for (int i = 0; i < atrList.size(); ++i) {
            Attribute atr = (Attribute)atrList.get(i);
            String atrName = atr.getName();
            if (atrName.equals(StyleConstants.FontFamily.toString())) {
                StyleConstants.setFontFamily(a, FontCheck.getValidFontFamilyName(atr.getValue()));
                continue;
            }
            if (atrName.equals(StyleConstants.FontSize.toString())) {
                StyleConstants.setFontSize(a, atr.getIntValue());
                continue;
            }
            if (atrName.equals(StyleConstants.Bold.toString())) {
                StyleConstants.setBold(a, atr.getBooleanValue());
                continue;
            }
            if (atrName.equals(StyleConstants.Italic.toString())) {
                StyleConstants.setItalic(a, atr.getBooleanValue());
                continue;
            }
            if (atrName.equals(StyleConstants.Background.toString())) {
                StyleConstants.setBackground(a, JDomUtility.stringToColor(atr.getValue()));
                continue;
            }
            if (atrName.equals(StyleConstants.Foreground.toString())) {
                StyleConstants.setForeground(a, JDomUtility.stringToColor(atr.getValue()));
                continue;
            }
            if (atrName.equals(TARGET)) {
                a.addAttribute(atrName, atr.getBooleanValue());
                continue;
            }
            if (atrName.equals(StyleConstants.BidiLevel.toString())) {
                StyleConstants.setBidiLevel(a, atr.getIntValue());
                continue;
            }
            if (!atrName.equals(StyleConstants.Alignment.toString())) continue;
            StyleConstants.setAlignment(a, atr.getIntValue());
        }
    }

    protected static void addStyle(TextActivityDocument doc, org.jdom.Element e) throws Exception {
        JDomUtility.checkName(e, STYLE);
        String styleName = e.getAttributeValue(NAME);
        Style s = doc.getStyle(styleName);
        if (s == null) {
            String baseName = JDomUtility.getStringAttr(e, BASE, "default", false);
            Style base = doc.getStyle(baseName);
            s = doc.addStyle(styleName, base);
        }
        TextActivityDocument.fillAttributes(s, e);
    }

    public static void setStyledDocumentTabSpc(int tab, StyledDocument sd, StyleContext sc) {
        Style regular = sd.getStyle("default");
        FontMetrics fm = sc.getFontMetrics(sd.getFont(regular));
        float sep = fm.charWidth(' ') * tab;
        TabStop[] tabs = new TabStop[30];
        for (int i = 0; i < 30; ++i) {
            tabs[i] = new TabStop(sep * (float)(i + 1));
        }
        StyleConstants.setTabSet(regular, new TabSet(tabs));
        sd.setParagraphAttributes(0, sd.getLength(), regular, true);
        String tabStr = Integer.toString(tab);
        Object o = regular.getAttribute(TABSPC);
        if (o == null || !tabStr.equals(o)) {
            if (o != null) {
                regular.removeAttribute(TABSPC);
            }
            regular.addAttribute(TABSPC, tabStr);
        }
    }

    public int getTabSpc() {
        return this.tabSpc;
    }

    public static StyleContext copyStylesFrom(StyleContext src, StyleContext dest, boolean fontFace, boolean fontSize, boolean style, boolean colour, boolean targetColour, boolean errorColour) {
        Color color;
        int size;
        String font;
        StyleContext clon;
        boolean result = false;
        try {
            clon = (StyleContext)StreamIO.cloneObject(dest);
        }
        catch (Exception ex) {
            System.err.println("Error cloning StyleContext:\n" + ex);
            return src;
        }
        Style mainStyle = clon.getStyle("default");
        Style srcMainStyle = src.getStyle("default");
        if (fontFace && (font = StyleConstants.getFontFamily(srcMainStyle)) != null && font.length() > 0 && !font.equals(StyleConstants.getFontFamily(mainStyle))) {
            StyleConstants.setFontFamily(mainStyle, font);
            result = true;
        }
        if (fontSize && (size = StyleConstants.getFontSize(srcMainStyle)) > 0 && size != StyleConstants.getFontSize(mainStyle)) {
            StyleConstants.setFontSize(mainStyle, size);
            result = true;
        }
        if (colour) {
            Color color2 = StyleConstants.getForeground(srcMainStyle);
            if (color2 != null && !color2.equals(StyleConstants.getForeground(mainStyle))) {
                StyleConstants.setForeground(mainStyle, color2);
                result = true;
            }
            if ((color2 = StyleConstants.getBackground(srcMainStyle)) != null && !color2.equals(StyleConstants.getBackground(mainStyle))) {
                StyleConstants.setBackground(mainStyle, color2);
                result = true;
            }
        }
        if (style) {
            boolean b = StyleConstants.isBold(srcMainStyle);
            if (b != StyleConstants.isBold(mainStyle)) {
                StyleConstants.setBold(mainStyle, b);
                result = true;
            }
            if ((b = StyleConstants.isItalic(srcMainStyle)) != StyleConstants.isItalic(mainStyle)) {
                StyleConstants.setItalic(mainStyle, b);
                result = true;
            }
            if ((b = StyleConstants.isUnderline(srcMainStyle)) != StyleConstants.isUnderline(mainStyle)) {
                StyleConstants.setUnderline(mainStyle, b);
                result = true;
            }
        }
        if (targetColour) {
            Style targetStyle = clon.getStyle(TARGET);
            Style srcTargetStyle = src.getStyle(TARGET);
            if (targetStyle != null && srcTargetStyle != null) {
                color = StyleConstants.getForeground(srcTargetStyle);
                if (color != null && !color.equals(StyleConstants.getForeground(targetStyle))) {
                    StyleConstants.setForeground(targetStyle, color);
                    result = true;
                }
                if ((color = StyleConstants.getBackground(srcTargetStyle)) != null && !color.equals(StyleConstants.getBackground(targetStyle))) {
                    StyleConstants.setBackground(targetStyle, color);
                    result = true;
                }
            }
        }
        if (errorColour) {
            Style errorStyle = clon.getStyle(TARGET_ERROR);
            Style srcErrorStyle = src.getStyle(TARGET_ERROR);
            if (errorStyle != null && srcErrorStyle != null) {
                color = StyleConstants.getForeground(srcErrorStyle);
                if (color != null && !color.equals(StyleConstants.getForeground(errorStyle))) {
                    StyleConstants.setForeground(errorStyle, color);
                    result = true;
                }
                if ((color = StyleConstants.getBackground(srcErrorStyle)) != null && !color.equals(StyleConstants.getBackground(errorStyle))) {
                    StyleConstants.setBackground(errorStyle, color);
                    result = true;
                }
            }
        }
        return result ? clon : dest;
    }

    public org.jdom.Element getJDomElement() throws Exception {
        return this.getJDomElement(this.styleContext);
    }

    public org.jdom.Element getJDomElement(StyleContext sc) throws Exception {
        org.jdom.Element e = new org.jdom.Element(ELEMENT_NAME);
        this.tmb.setPositions();
        TextActivityDocument.addStylesToElement(e, sc, this.tabSpc);
        e.addContent(this.getJDomElement(this.getDefaultRootElement()));
        return e;
    }

    public static void addStylesToElement(org.jdom.Element e, StyleContext sc, int tabSpc) throws Exception {
        Enumeration<?> styleNamesEnum = sc.getStyleNames();
        Stack<String> styleNames = new Stack<String>();
        while (styleNamesEnum.hasMoreElements()) {
            styleNames.push((String)styleNamesEnum.nextElement());
        }
        while (!styleNames.empty()) {
            org.jdom.Element s = new org.jdom.Element(STYLE);
            String styleName = (String)styleNames.pop();
            s.setAttribute(NAME, styleName);
            Style style = sc.getStyle(styleName);
            Style parent = (Style)style.getAttribute(AttributeSet.ResolveAttribute);
            if (parent != null) {
                s.setAttribute(BASE, parent.getName());
            }
            TextActivityDocument.setJDomElementAttributes(s, style, true);
            if (styleName.equals("default") && s.getAttribute(TABSPC) == null) {
                s.setAttribute(TABSPC, Integer.toString(tabSpc));
            }
            e.addContent(s);
        }
    }

    public org.jdom.Element getJDomElement(Element element) throws Exception {
        String elementName = element.getName();
        AttributeSet atr = element.getAttributes();
        String style = (String)atr.getAttribute(AttributeSet.NameAttribute);
        if (elementName.equals("component")) {
            Object cmp = atr.getAttribute(StyleConstants.ComponentAttribute);
            if (cmp != null && cmp instanceof JPanelActiveBox) {
                JPanelActiveBox jpab = (JPanelActiveBox)cmp;
                return jpab.getActiveBox().getContent().getJDomElement();
            }
        } else if (TARGET.equals(style)) {
            TextTarget tt;
            elementName = TARGET;
            TargetMarker tm = this.tmb.getElementByOffset(element.getStartOffset(), true);
            if (tm != null && (tt = tm.target) != null) {
                org.jdom.Element e = tt.getJDomElement();
                e.addContent(new org.jdom.Element(TEXT).setText(TextActivityDocument.getElementText(element)));
                return e;
            }
        }
        if (elementName.equals("content")) {
            elementName = TEXT;
        } else if (elementName.equals("paragraph")) {
            elementName = P;
        }
        org.jdom.Element e = new org.jdom.Element(elementName);
        if (style == null || !atr.isEqual(this.getStyle(style))) {
            TextActivityDocument.setJDomElementAttributes(e, atr, elementName.equals(P));
        } else if (!"default".equals(style) && !TARGET.equals(style)) {
            e.setAttribute(STYLE, style);
        }
        int count = element.getElementCount();
        if (count == 0) {
            String s = TextActivityDocument.getElementText(element);
            if (s != null && s.length() > 0) {
                e.setText(TextActivityDocument.getElementText(element));
            } else if (elementName.equals(TEXT)) {
                return null;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                org.jdom.Element child = this.getJDomElement(element.getElement(i));
                if (child == null) continue;
                e.addContent(child);
            }
        }
        return e;
    }

    protected static String getElementText(Element element) throws Exception {
        String s = new String();
        int offset = element.getStartOffset();
        int length = element.getEndOffset() - offset;
        if (length > 0) {
            s = element.getDocument().getText(offset, length);
        }
        return StrUtils.replace(s, "\n", "");
    }

    protected static void setJDomElementAttributes(org.jdom.Element e, AttributeSet atr, boolean isParagraph) {
        Enumeration<?> atrNames = atr.getAttributeNames();
        if (atrNames != null) {
            while (atrNames.hasMoreElements()) {
                Object attribute = atrNames.nextElement();
                if (attribute == null || !atr.isDefined(attribute) || !isParagraph && attribute instanceof AttributeSet.ParagraphAttribute) continue;
                JDomUtility.addGenericAttribute(e, attribute.toString(), atr.getAttribute(attribute));
            }
        }
    }

    public static TextActivityDocument getTextActivityDocument(org.jdom.Element e, TextActivityBase tab) throws Exception {
        org.jdom.Element child;
        TextActivityDocument doc = new TextActivityDocument(tab.styleContext);
        JDomUtility.checkName(e, ELEMENT_NAME);
        List styleList = e.getChildren(STYLE);
        if (!styleList.isEmpty()) {
            for (int i = 0; i < styleList.size(); ++i) {
                child = (org.jdom.Element)styleList.get(i);
                String styleName = child.getAttributeValue(NAME);
                String styleParent = JDomUtility.getStringAttr(child, BASE, "default", false);
                boolean isDefault = styleName.equals("default");
                Style s = isDefault ? doc.getStyle(styleName) : doc.addStyle(styleName, doc.getStyle(styleParent));
                TextActivityDocument.fillAttributes(s, child);
                if (!isDefault) continue;
                doc.setTabSpc(JDomUtility.getIntAttr(child, TABSPC, 12));
            }
        }
        if ((child = e.getChild(doc.getDefaultRootElement().getName())) != null) {
            TextActivityDocument.processChilds(child.getChildren(), doc, tab, doc.getStyle("default"));
            doc.tmb.setPositions();
        }
        return doc;
    }

    private static void processChilds(List childs, TextActivityDocument doc, TextActivityBase tab, AttributeSet atr) throws Exception {
        AttributeSet atrBase = atr;
        for (int i = 0; i < childs.size(); ++i) {
            atr = atrBase;
            org.jdom.Element e = (org.jdom.Element)childs.get(i);
            String elementName = e.getName();
            if (elementName.equals(P)) {
                int p = doc.getLength();
                atr = TextActivityDocument.getAttributes(doc, atrBase, e);
                TextActivityDocument.processChilds(e.getChildren(), doc, tab, atr);
                if (i < childs.size() - 1) {
                    doc.insertString(doc.getLength(), "\n", atr);
                }
                doc.setParagraphAttributes(p, doc.getLength() - p, atr, true);
                continue;
            }
            if (elementName.equals(TEXT)) {
                doc.insertString(doc.getLength(), e.getText(), TextActivityDocument.getAttributes(doc, atrBase, e));
                continue;
            }
            if (elementName.equals(TARGET)) {
                atr = doc.getStyle(TARGET);
                TargetMarker tm = new TargetMarker(doc);
                tm.begOffset = doc.getLength();
                if (!e.getChildren().isEmpty()) {
                    tm.target = TextTarget.getTextTarget(e, tab.getProject().mediaBag);
                    TextActivityDocument.processChilds(e.getChildren(TEXT), doc, tab, atr);
                } else {
                    doc.insertString(doc.getLength(), e.getText(), atr);
                }
                tm.endOffset = doc.getLength();
                doc.tmb.add(tm);
                continue;
            }
            if (!elementName.equals("cell")) continue;
            ActiveBoxContent ab = ActiveBoxContent.getActiveBoxContent(e, tab.getProject().mediaBag);
            doc.boxesContent.addActiveBoxContent(ab);
            JPanelActiveBox jpab = new JPanelActiveBox(null, ab.bb, tab.getProject().getBridge().getComponent());
            jpab.setAlignmentY(0.9f);
            jpab.setActiveBoxContent(ab);
            SimpleAttributeSet satr = new SimpleAttributeSet(atr);
            StyleConstants.setComponent(satr, jpab);
            doc.insertString(doc.getLength(), " ", satr);
        }
    }

    public TextActivityDocument cloneDoc(TextActivityDocument dest, boolean hideTargets, boolean initTargets, boolean hideTargetStyle) throws Exception {
        this.tmb.updateOffsets();
        TextActivityDocument d = dest;
        if (d == null) {
            d = new TextActivityDocument(this.styleContext);
        }
        AttributeSet s = this.getStyle("default");
        AttributeSet s2 = null;
        d.setParagraphAttributes(0, d.getLength(), s, true);
        d.boxesContent = this.boxesContent;
        d.popupsContent = this.popupsContent;
        int ip = 0;
        int lp = this.getLength();
        char[] currentChars = this.getText(0, lp).toCharArray();
        while (ip < lp) {
            int l;
            int i;
            Element ep = this.getParagraphElement(ip);
            int dOffset = d.getLength();
            TargetMarker tm = null;
            TargetMarker tmx = null;
            AttributeSet attr = null;
            String si = null;
            int j = i = ip;
            for (l = ip; l < currentChars.length && currentChars[l] != '\n'; ++l) {
            }
            ++l;
            s = this.getCharacterElement(i).getAttributes();
            s2 = null;
            while (i < l) {
                for (j = i + 1; j < l; ++j) {
                    s2 = this.getCharacterElement(j).getAttributes();
                    if (s != null && !s.isEqual(s2)) break;
                }
                attr = null;
                si = null;
                tm = this.tmb.getElementByOffset(i, false);
                if (tm != null) {
                    tmx = new TargetMarker(d);
                    tmx.begOffset = d.getLength();
                    tmx.target = tm.target;
                    if (tm.target != null && initTargets) {
                        if (tm.target.isList) {
                            attr = new SimpleAttributeSet(s);
                            StyleConstants.setComponent((MutableAttributeSet)attr, tm.target.buildCombo(s, this.getStyle(TARGET_ERROR)));
                            si = " ";
                        } else if (tm.target.iniText != null) {
                            si = tm.target.iniText;
                        } else {
                            si = tm.target.getFillString();
                            attr = new SimpleAttributeSet(s);
                            attr.addAttribute(FILL, Boolean.TRUE);
                        }
                    } else if (hideTargets) {
                        si = new String();
                    } else if (hideTargetStyle) {
                        attr = this.styleContext.getStyle("default");
                    }
                }
                if (si == null) {
                    try {
                        si = this.getText(i, j - i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (si != null && si.length() > 0) {
                    d.insertString(d.getLength(), si, attr != null ? attr : s);
                }
                if (tmx != null && tm != null) {
                    tmx.endOffset = d.getLength();
                    d.tmb.add(tmx);
                }
                i = j;
                s = s2;
            }
            int lpd = d.getLength() - dOffset;
            if (lpd > 0) {
                d.setParagraphAttributes(dOffset, lpd, ep.getAttributes(), true);
            }
            ip = l;
        }
        d.tmb.setPositions();
        return d;
    }

    public static Font attributesToFont(AttributeSet s) {
        int style = (StyleConstants.isBold(s) ? 1 : 0) | (StyleConstants.isItalic(s) ? 2 : 0);
        return new Font(StyleConstants.getFontFamily(s), style, StyleConstants.getFontSize(s));
    }

    public JPanelActiveBox[] getPanelBoxes() {
        ArrayList<JPanelActiveBox> v = new ArrayList<JPanelActiveBox>();
        for (int i = 0; i < this.getLength(); ++i) {
            Component c = StyleConstants.getComponent(this.getCharacterElement(i).getAttributes());
            if (c == null || !(c instanceof JPanelActiveBox)) continue;
            v.add((JPanelActiveBox)c);
        }
        return v.toArray(new JPanelActiveBox[v.size()]);
    }

    public void attachTo(JTextComponent tc, Activity.Panel parent) {
        for (JPanelActiveBox jpab : this.getPanelBoxes()) {
            jpab.notifyMouseEventsTo(tc);
            jpab.setPanelParent(parent);
        }
    }

    public static boolean checkBooleanAttribute(AttributeSet atr, Object key) {
        Object o = atr.getAttribute(key);
        return o != null && o.equals(Boolean.TRUE);
    }

    public boolean checkBooleanAttribute(int offset, Object key) {
        Element e = this.getCharacterElement(offset);
        return e != null && TextActivityDocument.checkBooleanAttribute(e.getAttributes(), key);
    }

    public MutableAttributeSet getTargetAttributeSet() {
        return new SimpleAttributeSet(this.styleContext.getStyle(TARGET));
    }

    public MutableAttributeSet getFillAttributeSet() {
        MutableAttributeSet attr = this.getTargetAttributeSet();
        attr.addAttribute(FILL, Boolean.TRUE);
        return attr;
    }

    public void applyStyleToTarget(TargetMarker tm, String style, boolean invertColors, boolean replace) {
        if (style == null) {
            style = "default";
        }
        SimpleAttributeSet attr = new SimpleAttributeSet(this.styleContext.getStyle(style));
        if (invertColors) {
            Color bg = StyleConstants.getBackground(attr);
            Color fore = StyleConstants.getForeground(attr);
            StyleConstants.setBackground(attr, fore);
            StyleConstants.setForeground(attr, bg);
        }
        tm.updateOffsets();
        this.setCharacterAttributes(tm.begOffset, tm.getLength(), attr, replace);
    }

    public void clearAllTargets() {
        this.tmb.removeUnattachedElements();
        Iterator it = this.tmb.iterator();
        while (it.hasNext()) {
            TargetMarker tm = (TargetMarker)it.next();
            this.applyStyleToTarget(tm, null, false, true);
            it.remove();
        }
    }

    public org.jdom.Element getJDomElementWithoutStyles() throws Exception {
        org.jdom.Element mainElement = this.getJDomElement();
        this.clearElementStyles(mainElement);
        return mainElement;
    }

    protected void clearElementStyles(org.jdom.Element e) {
        String s = e.getName();
        if (P.equals(s) || TEXT.equals(s)) {
            HashSet<Attribute> set = new HashSet<Attribute>();
            for (Attribute at : e.getAttributes()) {
                if (TEXT.equals(at.getName())) continue;
                set.add(at);
            }
            for (Attribute atr : set) {
                e.removeAttribute(atr);
            }
        }
        Iterator it = e.getChildren().iterator();
        while (it.hasNext()) {
            this.clearElementStyles((org.jdom.Element)it.next());
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }
}

