/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.Map;
import org.jdom.Element;

public class ActivitySequenceElement
implements Editable,
Domable,
Cloneable {
    private String tag;
    private String description;
    private String activityName;
    public ActivitySequenceJump fwdJump;
    public ActivitySequenceJump backJump;
    public int navButtons;
    public int delay;
    public static final String ELEMENT_NAME = "item";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String DELAY = "delay";
    public static final String FORWARD = "forward";
    public static final String BACK = "back";
    public static final String NAV_BUTTONS = "navButtons";
    public static final int NAV_NONE = 0;
    public static final int NAV_FWD = 1;
    public static final int NAV_BACK = 2;
    public static final int NAV_BOTH = 3;
    public static final String[] NAV_BUTTONS_TAG = new String[]{"none", "fwd", "back", "both"};

    public ActivitySequenceElement(String activityName) {
        this(activityName, false);
    }

    public ActivitySequenceElement(String activityName, boolean singleActivity) {
        this(activityName, 0, 3);
        if (singleActivity) {
            this.setTag(this.getActivityName());
            this.fwdJump = new ActivitySequenceJump(1);
            this.backJump = new ActivitySequenceJump(2);
        }
    }

    public ActivitySequenceElement(String activityName, int delay, int navButtons) {
        this.setActivityName(activityName);
        this.delay = delay;
        this.tag = null;
        this.description = null;
        this.fwdJump = null;
        this.backJump = null;
        this.navButtons = navButtons;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.tag != null) {
            e.setAttribute(ID, this.tag);
            if (this.description != null) {
                JDomUtility.addParagraphs(e, DESCRIPTION, this.description);
            }
        }
        e.setAttribute(NAME, this.activityName);
        if (this.delay != 0) {
            e.setAttribute(DELAY, Integer.toString(this.delay));
        }
        if (this.fwdJump != null) {
            e.addContent(this.fwdJump.getJDomElement(FORWARD));
        }
        if (this.backJump != null) {
            e.addContent(this.backJump.getJDomElement(BACK));
        }
        if (this.navButtons != 3) {
            e.setAttribute(NAV_BUTTONS, NAV_BUTTONS_TAG[this.navButtons]);
        }
        return e;
    }

    public static ActivitySequenceElement getActivitySequenceElement(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        ActivitySequenceElement ase = new ActivitySequenceElement("", 0, 3);
        ase.setProperties(e, null);
        return ase;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.setActivityName(e.getAttributeValue(NAME));
        this.delay = JDomUtility.getIntAttr(e, DELAY, 0);
        this.setTag(JDomUtility.getStringAttr(e, ID, this.tag, false));
        this.description = JDomUtility.getParagraphs(e.getChild(DESCRIPTION));
        for (Element child : e.getChildren("jump")) {
            String id = child.getAttributeValue(ID);
            ActivitySequenceJump asj = ActivitySequenceJump.getActivitySequenceJump(child);
            if (FORWARD.equals(id)) {
                this.fwdJump = asj;
                continue;
            }
            if (!BACK.equals(id)) continue;
            this.backJump = asj;
        }
        this.navButtons = JDomUtility.getStrIndexAttr(e, NAV_BUTTONS, NAV_BUTTONS_TAG, 3);
    }

    public void setTag(String newTag) {
        this.tag = FileSystem.stdFn(newTag);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setActivityName(String sActivityName) {
        this.activityName = FileSystem.stdFn(sActivityName);
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void listReferences(String type, Map<String, String> map) {
        if (this.activityName != null && (type == null || type.equals("activity"))) {
            map.put(this.activityName, "activity");
        }
        if (this.tag != null && (type == null || type.equals("sequence"))) {
            map.put(this.tag, "sequence");
        }
        if (this.backJump != null) {
            this.backJump.listReferences(type, map);
        }
        if (this.fwdJump != null) {
            this.fwdJump.listReferences(type, map);
        }
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    public Object clone() throws CloneNotSupportedException {
        ActivitySequenceElement result = (ActivitySequenceElement)super.clone();
        if (this.fwdJump != null) {
            result.fwdJump = (ActivitySequenceJump)this.fwdJump.clone();
        }
        if (this.backJump != null) {
            result.backJump = (ActivitySequenceJump)this.backJump.clone();
        }
        return result;
    }
}

