/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.Map;
import org.jdom.Element;

public class JumpInfo
implements Domable,
Cloneable {
    public static final int JUMP = 0;
    public static final int STOP = 1;
    public static final int RETURN = 2;
    public static final int EXIT = 3;
    public int action;
    public String projectPath;
    public String sequence;
    public int actNum;
    public static final String[] actions = new String[]{"JUMP", "STOP", "RETURN", "EXIT"};
    public static final String ELEMENT_NAME = "jump";
    public static final String ACTION = "action";
    public static final String TAG = "tag";
    public static final String PROJECT = "project";

    public JumpInfo(int action) {
        this(action, null);
    }

    public JumpInfo(int action, String sequence) {
        this.action = action;
        this.sequence = sequence;
        this.projectPath = null;
        this.actNum = -1;
    }

    public JumpInfo(int action, int actNum) {
        this.action = action;
        this.actNum = actNum;
        this.projectPath = null;
        this.sequence = null;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (this.action != 0) {
            e.setAttribute(ACTION, actions[this.action]);
        } else {
            if (this.sequence != null) {
                e.setAttribute(TAG, this.sequence);
            }
            if (this.projectPath != null) {
                e.setAttribute(PROJECT, this.projectPath);
            }
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.action = JDomUtility.getStrIndexAttr(e, ACTION, actions, 0);
        if (this.action == 0) {
            this.sequence = JDomUtility.getStringAttr(e, TAG, this.sequence, false);
            this.projectPath = JDomUtility.getStringAttr(e, PROJECT, this.projectPath, false);
        }
    }

    public void listReferences(String type, Map<String, String> map) {
        if (this.action == 0) {
            if (this.projectPath != null) {
                if (type == null || type.equals("external")) {
                    map.put(this.projectPath, "external");
                }
            } else if (this.sequence != null && (type == null || type.equals("sequence"))) {
                map.put(this.sequence, "sequence");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

