/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedActiveBox
extends ActiveBox
implements ActionListener {
    protected ActiveBagContent abc = null;
    protected ActiveBagContent altAbc = null;
    protected Timer timer = null;
    protected int delay = 50;
    protected boolean running = false;
    protected int currentFrame = 0;
    private boolean waitingForFirstFrame = false;
    protected long startTime = 0L;
    protected int startDelay = 0;
    public static final int MIN_DELAY = 50;

    public AnimatedActiveBox(AbstractBox parent, JComponent container, BoxBase boxBase) {
        super(parent, container, boxBase);
    }

    public AnimatedActiveBox(AbstractBox parent, JComponent container, int setIdLoc, Rectangle2D r, BoxBase boxBase) {
        super(parent, container, setIdLoc, r, boxBase);
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void setContent(ActiveBagContent abc) {
        this.abc = abc;
        if (abc != null && !abc.isEmpty()) {
            this.setContent(abc.getActiveBoxContent(0));
        }
    }

    public void setAltContent(ActiveBagContent abc) {
        this.altAbc = abc;
    }

    private void buildTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.delay >= 50) {
            this.timer = new Timer(this.delay, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
        }
    }

    public void start() {
        this.stop(false);
        if (this.timer == null) {
            this.buildTimer();
        }
        if (this.timer != null) {
            this.startTime = System.currentTimeMillis();
            this.waitingForFirstFrame = false;
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void stop(boolean toFirstFrame) {
        if (this.timer != null && this.timer.isRunning()) {
            if (toFirstFrame) {
                this.waitingForFirstFrame = true;
            } else {
                this.waitingForFirstFrame = false;
                this.timer.stop();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActiveBagContent c;
        ActiveBagContent activeBagContent = c = this.isAlternative() ? this.altAbc : this.abc;
        if (c != null && c.getNumCells() > 0) {
            ++this.currentFrame;
            this.currentFrame %= c.getNumCells();
            if (this.currentFrame == 0 && this.waitingForFirstFrame) {
                this.waitingForFirstFrame = false;
                this.timer.stop();
            } else if (this.isAlternative()) {
                this.setAltContent(c, this.currentFrame);
            } else {
                this.setContent(c, this.currentFrame);
            }
            if (!this.isVisible() && this.startDelay > 0 && System.currentTimeMillis() - this.startTime >= (long)this.startDelay) {
                this.setVisible(true);
            }
        }
    }
}

