/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.misc.Gradient;
import edu.xtec.util.Domable;
import edu.xtec.util.FontCheck;
import edu.xtec.util.JDomUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.jdom.Element;

public class BoxBase
implements Cloneable,
Domable {
    private Font originalFont;
    public Color backColor;
    public Gradient bgGradient;
    public Color textColor;
    public Color shadowColor;
    public Color borderColor;
    public Color inactiveColor;
    public Color alternativeColor;
    public boolean shadow;
    public boolean transparent;
    public int textMargin;
    protected BasicStroke borderStroke;
    protected BasicStroke markerStroke;
    private Font font;
    private float dynFontSize;
    private static final float REDUCE_FONT_STEP = 1.0f;
    public static final float MIN_FONT_SIZE = 8.0f;
    private static int resetAllFontsCounter = 0;
    public static boolean flagFontReduced = false;
    private int resetFontCounter;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Color DEFAULT_BACK_COLOR = Color.lightGray;
    public static final Color DEFAULT_TEXT_COLOR = Color.black;
    public static final Color DEFAULT_SHADOW_COLOR = Color.gray;
    public static final Color DEFAULT_INACTIVE_COLOR = Color.gray;
    public static final Color DEFAULT_ALTERNATIVE_COLOR = Color.gray;
    public static final Color DEFAULT_BORDER_COLOR = Color.black;
    public static final float DEFAULT_BORDER_STROKE_WIDTH = 0.75f;
    public static final BasicStroke DEFAULT_BORDER_STROKE = new BasicStroke(0.75f);
    public static final float DEFAULT_MARKER_STROKE_WIDTH = 2.75f;
    public static final BasicStroke DEFAULT_MARKER_STROKE = new BasicStroke(2.75f);
    private static Font DEFAULT_FONT = null;
    public static BoxBase DEFAULT_BOX_BASE = new BoxBase();
    public static final String ELEMENT_NAME = "style";
    public static final String COLOR = "color";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String SHADOW = "shadow";
    public static final String INACTIVE = "inactive";
    public static final String ALTERNATIVE = "alternative";
    public static final String BORDER = "border";
    public static final String TRANSPARENT = "transparent";
    public static final String MARGIN = "margin";
    public static final String BORDER_STROKE = "borderStroke";
    public static final String MARKER_STROKE = "markerStroke";

    public BoxBase() {
        this.setFont(BoxBase.getDefaultFont());
        this.dynFontSize = this.font.getSize2D();
        this.backColor = DEFAULT_BACK_COLOR;
        this.bgGradient = null;
        this.textColor = DEFAULT_TEXT_COLOR;
        this.shadowColor = DEFAULT_SHADOW_COLOR;
        this.inactiveColor = DEFAULT_INACTIVE_COLOR;
        this.alternativeColor = DEFAULT_ALTERNATIVE_COLOR;
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.shadow = false;
        this.transparent = false;
        this.textMargin = 6;
        this.resetFontCounter = resetAllFontsCounter;
        this.borderStroke = DEFAULT_BORDER_STROKE;
        this.markerStroke = DEFAULT_MARKER_STROKE;
    }

    public Object clone() {
        BoxBase result = null;
        try {
            result = (BoxBase)super.clone();
            if (this.bgGradient != null) {
                result.bgGradient = (Gradient)this.bgGradient.clone();
            }
            result.setFont(this.originalFont);
        }
        catch (Exception ex) {
            System.err.println("Unexpected error cloning BoxBase!");
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == null) {
            return false;
        }
        boolean bl = result = o == this;
        if (!result && o instanceof BoxBase) {
            BoxBase bb = (BoxBase)o;
            result = this.originalFont.equals(bb.originalFont) && this.backColor.equals(bb.backColor) && (this.bgGradient == null && bb.bgGradient == null || this.bgGradient != null && this.bgGradient.equals(bb.bgGradient)) && this.textColor.equals(bb.textColor) && this.shadowColor.equals(bb.shadowColor) && this.borderColor.equals(bb.borderColor) && this.inactiveColor.equals(bb.inactiveColor) && this.alternativeColor.equals(bb.alternativeColor) && this.shadow == bb.shadow && this.transparent == bb.transparent && this.textMargin == bb.textMargin && this.borderStroke.equals(bb.borderStroke) && this.markerStroke.equals(bb.markerStroke);
        }
        return result;
    }

    public static Font getDefaultFont() {
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = FontCheck.getValidFont("Arial", 0, 17);
        }
        return DEFAULT_FONT;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        if (!BoxBase.getDefaultFont().equals(this.originalFont)) {
            e.addContent(JDomUtility.fontToElement(this.originalFont));
        }
        Element ce = new Element(COLOR);
        if (!this.textColor.equals(DEFAULT_TEXT_COLOR)) {
            ce.setAttribute(FOREGROUND, JDomUtility.colorToString(this.textColor));
        }
        if (!this.backColor.equals(DEFAULT_BACK_COLOR)) {
            ce.setAttribute(BACKGROUND, JDomUtility.colorToString(this.backColor));
        }
        if (!this.shadowColor.equals(DEFAULT_SHADOW_COLOR)) {
            ce.setAttribute(SHADOW, JDomUtility.colorToString(this.shadowColor));
        }
        if (!this.inactiveColor.equals(DEFAULT_INACTIVE_COLOR)) {
            ce.setAttribute(INACTIVE, JDomUtility.colorToString(this.inactiveColor));
        }
        if (!this.alternativeColor.equals(DEFAULT_ALTERNATIVE_COLOR)) {
            ce.setAttribute(ALTERNATIVE, JDomUtility.colorToString(this.alternativeColor));
        }
        if (!this.borderColor.equals(DEFAULT_BORDER_COLOR)) {
            ce.setAttribute(BORDER, JDomUtility.colorToString(this.borderColor));
        }
        if (!ce.getAttributes().isEmpty()) {
            e.addContent(ce);
        }
        if (this.bgGradient != null) {
            e.addContent(this.bgGradient.getJDomElement());
        }
        if (this.shadow) {
            e.setAttribute(SHADOW, JDomUtility.boolString(this.shadow));
        }
        if (this.transparent) {
            e.setAttribute(TRANSPARENT, JDomUtility.boolString(this.transparent));
        }
        if (this.textMargin != 6) {
            e.setAttribute(MARGIN, Integer.toString(this.textMargin));
        }
        if (this.borderStroke.getLineWidth() != 0.75f) {
            e.setAttribute(BORDER_STROKE, Float.toString(this.borderStroke.getLineWidth()));
        }
        if (this.markerStroke.getLineWidth() != 2.75f) {
            e.setAttribute(MARKER_STROKE, Float.toString(this.markerStroke.getLineWidth()));
        }
        return e;
    }

    public static BoxBase getBoxBase(Element e) throws Exception {
        BoxBase bb = new BoxBase();
        bb.setProperties(e, null);
        return bb;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        Element child = e.getChild("font");
        if (child != null) {
            this.setFont(JDomUtility.elementToFont(child));
        }
        if ((child = e.getChild(COLOR)) != null) {
            this.textColor = JDomUtility.getColorAttr(child, FOREGROUND, this.textColor);
            this.backColor = JDomUtility.getColorAttr(child, BACKGROUND, this.backColor);
            this.shadowColor = JDomUtility.getColorAttr(child, SHADOW, this.shadowColor);
            this.inactiveColor = JDomUtility.getColorAttr(child, INACTIVE, this.inactiveColor);
            this.alternativeColor = JDomUtility.getColorAttr(child, ALTERNATIVE, this.alternativeColor);
            this.borderColor = JDomUtility.getColorAttr(child, BORDER, this.borderColor);
        }
        this.shadow = JDomUtility.getBoolAttr(e, SHADOW, this.shadow);
        this.transparent = JDomUtility.getBoolAttr(e, TRANSPARENT, this.transparent);
        this.textMargin = JDomUtility.getIntAttr(e, MARGIN, this.textMargin);
        String s = e.getAttributeValue(BORDER_STROKE);
        if (s != null) {
            this.setBorderWidth(Float.parseFloat(s));
        }
        if ((s = e.getAttributeValue(MARKER_STROKE)) != null) {
            this.setMarkerWidth(Float.parseFloat(s));
        }
        if ((child = e.getChild("gradient")) != null) {
            this.bgGradient = Gradient.getGradient(child);
        }
    }

    public Stroke getBorder() {
        return this.borderStroke;
    }

    public float getBorderWidth() {
        return this.borderStroke.getLineWidth();
    }

    public void setBorderWidth(float w) {
        this.borderStroke = new BasicStroke(w);
    }

    public Stroke getMarker() {
        return this.markerStroke;
    }

    public float getMarkerWidth() {
        return this.markerStroke.getLineWidth();
    }

    public void setMarkerWidth(float w) {
        this.markerStroke = new BasicStroke(w);
    }

    public static void resetAllFonts() {
        ++resetAllFontsCounter;
    }

    public void setFont(Font newFont) {
        if (newFont != null) {
            this.font = newFont;
            this.dynFontSize = this.font.getSize();
            this.originalFont = this.font.deriveFont(new AffineTransform());
        }
    }

    public void resetFont() {
        this.resetFontCounter = resetAllFontsCounter - 1;
    }

    public Font getFont() {
        if (this.resetFontCounter < resetAllFontsCounter) {
            this.resetFontCounter = resetAllFontsCounter;
            this.font = this.originalFont.deriveFont(new AffineTransform());
            this.dynFontSize = this.font.getSize();
        }
        return this.font;
    }

    public Font getOriginalFont() {
        return this.originalFont;
    }

    public float getDynFontSize() {
        return this.dynFontSize;
    }

    public boolean reduceFont() {
        if (this.dynFontSize <= 8.0f) {
            return false;
        }
        flagFontReduced = true;
        this.dynFontSize -= 1.0f;
        this.font = this.font.deriveFont(this.dynFontSize);
        return true;
    }
}

