/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;

public class Counter
extends AbstractBox {
    int value = 0;
    int countDown;
    boolean enabled = false;
    Image img = null;
    Dimension dSize;
    Point origin;

    public Counter(AbstractBox parent, JComponent container, Rectangle2D r, BoxBase boxBase) {
        super(parent, container, boxBase);
        this.setBounds(r);
        this.countDown = 0;
    }

    public void setEnabled(boolean bEnabled) {
        this.enabled = bEnabled;
        this.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCountDown(int maxValue) {
        this.countDown = maxValue;
        this.repaint();
    }

    public void setSource(Image setImg, Point setOrigin, Dimension setDigitSize) {
        this.img = setImg;
        this.origin = setOrigin;
        this.dSize = setDigitSize;
        this.repaint();
    }

    public void incValue() {
        ++this.value;
        if (this.enabled) {
            this.repaint();
        }
    }

    public void setValue(int newValue) {
        this.value = newValue;
        if (this.enabled) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public boolean updateContent(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        double marginW = (this.width - (double)(3 * this.dSize.width)) / 2.0;
        double marginH = (this.height - (double)this.dSize.height) / 2.0;
        if (this.img == null) {
            return false;
        }
        int valr = this.value;
        if (this.countDown > 0) {
            valr = Math.max(0, this.countDown - this.value);
        }
        valr = Math.min(999, valr);
        boolean k = false;
        int i = 0;
        int j = 100;
        while (i < 3) {
            int d;
            if (!this.enabled) {
                d = 1;
            } else {
                int w = valr / j % 10;
                if (w != 0) {
                    k = true;
                    d = 11 - w;
                } else {
                    d = k || i == 2 ? 11 : 1;
                }
            }
            g2.drawImage(this.img, (int)(this.x + marginW + (double)(this.dSize.width * i)), (int)(this.y + marginH), (int)(this.x + marginW + (double)(this.dSize.width * (i + 1))), (int)(this.y + marginH + (double)this.dSize.height), this.origin.x, this.origin.y + this.dSize.height * d, this.origin.x + this.dSize.width, this.origin.y + this.dSize.height * (d + 1), io);
            ++i;
            j /= 10;
        }
        return true;
    }
}

