/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.misc.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JPanelActiveBox
extends JPanel {
    Activity.Panel parentActivityPanel = null;
    PlayStation ps;
    public ActiveBox ab;
    public boolean catchMouseEvents;
    Component mouseListener = null;
    ImageObserver io;

    public JPanelActiveBox(AbstractBox parent, BoxBase boxBase, ImageObserver io) {
        this.io = io;
        if (io instanceof Activity.Panel) {
            this.parentActivityPanel = (Activity.Panel)io;
            this.ps = this.parentActivityPanel.getPs();
        } else if (io instanceof PlayStation) {
            this.ps = (PlayStation)((Object)io);
        }
        this.enableEvents(16L);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.ab = new ActiveBox(parent, this, boxBase);
        this.catchMouseEvents = true;
    }

    public void notifyMouseEventsTo(Component cmp) {
        this.mouseListener = cmp;
    }

    public void setPanelParent(Activity.Panel parent) {
        this.parentActivityPanel = parent;
        this.ps = parent == null ? null : parent.getPs();
        this.repaint();
    }

    public void setPlayStation(PlayStation ps) {
        this.ps = ps;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (this.catchMouseEvents && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (e.getID() == 501 && this.ab != null && this.ps != null && (this.parentActivityPanel == null || this.parentActivityPanel.isPlaying())) {
                this.ps.stopMedia(1);
                this.ab.playMedia(this.ps);
            }
            if (!(this.mouseListener == null || this.ab != null && this.ab.getContent().mediaContent != null && this.ab.getContent().mediaContent.catchMouseEvents)) {
                Point bkPt = me.getPoint();
                Point pt = Utils.mapPointTo(this, bkPt, this.mouseListener);
                me.translatePoint(pt.x - bkPt.x, pt.y - bkPt.y);
                this.mouseListener.dispatchEvent(e);
            }
            me.consume();
            return;
        }
        super.processEvent(e);
    }

    public JPanel setActiveBoxContent(ActiveBoxContent abc) {
        if (abc == null) {
            abc = new ActiveBoxContent();
        }
        if (abc.dimension != null) {
            this.ab.setBounds(0.0, 0.0, abc.dimension.width, abc.dimension.height);
        }
        this.ab.setContent(abc);
        if (abc.mediaContent != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(null);
        }
        this.adjustSize();
        return this;
    }

    public ActiveBoxContent getActiveBoxContent() {
        return this.ab.getContent();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.ab.setBounds(0.0, 0.0, width, height);
    }

    public ActiveBox getActiveBox() {
        return this.ab;
    }

    public void adjustSize() {
        if (this.ab != null) {
            Dimension size = this.ab.getBorderBounds().getSize();
            this.setPreferredSize(size);
            this.setMaximumSize(size);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = g2.getRenderingHints();
        g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        if (this.ab == null) {
            super.paintComponent(g2);
        } else {
            do {
                BoxBase.flagFontReduced = false;
                this.ab.update(g2, g2.getClipBounds(), this.io);
            } while (BoxBase.flagFontReduced);
        }
        g2.setRenderingHints(rh);
    }
}

