/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.util.Iterator;
import org.jdom.Element;

public class TextGridContent
implements Domable {
    public static final char DEFAULT_WILD = '*';
    public static final String DEFAULT_RANDOM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public int ncw = 1;
    public int nch = 1;
    public double w = 20.0;
    public double h = 20.0;
    public boolean border = false;
    public BoxBase bb = null;
    public String[] text = new String[1];
    public char wild = (char)42;
    public String randomChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ELEMENT_NAME = "textGrid";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String ROW = "row";
    public static final String TEXT = "text";
    public static final String WILD = "wild";
    public static final String RANDOM_CHARS = "randomChars";

    public static TextGridContent initNew(int ncw, int nch, char firstChar) {
        TextGridContent result = new TextGridContent();
        result.ncw = ncw;
        result.nch = nch;
        result.text = new String[nch];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nch; ++i) {
            sb.setLength(0);
            for (int j = 0; j < ncw; ++j) {
                char c = firstChar;
                firstChar = (char)(firstChar + '\u0001');
                sb.append(c);
            }
            result.text[i] = sb.toString();
        }
        result.bb = new BoxBase();
        result.bb.backColor = Color.white;
        result.border = true;
        return result;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(ROWS, Integer.toString(this.ncw));
        e.setAttribute(COLUMNS, Integer.toString(this.nch));
        e.setAttribute(CELL_WIDTH, Double.toString(this.w));
        e.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        e.setAttribute(BORDER, JDomUtility.boolString(this.border));
        if (this.wild != '*') {
            e.setAttribute(WILD, String.copyValueOf(new char[]{this.wild}));
        }
        if (!DEFAULT_RANDOM_CHARS.equals(this.randomChars)) {
            e.setAttribute(RANDOM_CHARS, this.randomChars);
        }
        if (this.bb != null) {
            e.addContent(this.bb.getJDomElement());
        }
        Element child = new Element(TEXT);
        for (int i = 0; i < this.nch; ++i) {
            if (i >= this.text.length) continue;
            child.addContent(new Element(ROW).setText(this.text[i]));
        }
        e.addContent(child);
        return e;
    }

    public static TextGridContent getTextGridContent(Element e) throws Exception {
        TextGridContent tgc = new TextGridContent();
        tgc.setProperties(e, null);
        return tgc;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.ncw = JDomUtility.getIntAttr(e, ROWS, this.ncw);
        this.nch = JDomUtility.getIntAttr(e, COLUMNS, this.nch);
        this.w = JDomUtility.getDoubleAttr(e, CELL_WIDTH, this.w);
        this.h = JDomUtility.getDoubleAttr(e, CELL_HEIGHT, this.h);
        if (this.ncw < 1 || this.nch < 1 || this.w < 1.0 || this.h < 1.0) {
            throw new IllegalArgumentException("Invalid TextGridContent attributes!");
        }
        String s = e.getAttributeValue(WILD);
        if (s != null && s.length() > 0) {
            this.wild = s.charAt(0);
        }
        this.randomChars = JDomUtility.getStringAttr(e, RANDOM_CHARS, this.randomChars, false);
        this.border = JDomUtility.getBoolAttr(e, BORDER, this.border);
        Element child = e.getChild("style");
        if (child != null) {
            this.bb = BoxBase.getBoxBase(child);
        }
        if ((child = e.getChild(TEXT)) != null) {
            this.text = new String[this.nch];
            Iterator itr = child.getChildren(ROW).iterator();
            int i = 0;
            while (itr.hasNext()) {
                Element child2 = (Element)itr.next();
                this.text[i++] = child2.getText();
            }
            while (i < this.nch) {
                this.text[i] = "";
                ++i;
            }
        }
    }

    public void completeText() {
        char[] emptyLineChars = new char[this.ncw];
        for (int i = 0; i < this.ncw; ++i) {
            emptyLineChars[i] = this.wild;
        }
        String[] result = new String[this.nch];
        for (int i = 0; i < this.nch; ++i) {
            StringBuilder sb = new StringBuilder();
            if (i < this.text.length) {
                char[] txch = this.text[i].toCharArray();
                sb.append(txch, 0, Math.min(txch.length, this.ncw));
                int l = sb.length();
                if (l < this.ncw) {
                    sb.append(emptyLineChars, 0, this.ncw - l);
                }
                result[i] = sb.substring(0);
                continue;
            }
            result[i] = String.copyValueOf(emptyLineChars);
        }
        this.text = result;
    }

    public int countWildChars() {
        int result = 0;
        this.completeText();
        if (this.text != null) {
            for (int y = 0; y < this.nch; ++y) {
                for (int x = 0; x < this.ncw; ++x) {
                    if (this.text[y].charAt(x) != this.wild) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public int getNumChars() {
        return this.ncw * this.nch;
    }

    public void setCharAt(int x, int y, char ch) {
        if (x >= 0 && x < this.ncw && y >= 0 && y < this.nch) {
            StringBuilder sb = new StringBuilder(this.text[y]);
            sb.setCharAt(x, ch);
            this.text[y] = sb.substring(0);
        }
    }

    public void copyStyleTo(TextGridContent tgc) {
        if (tgc != null) {
            tgc.w = this.w;
            tgc.h = this.h;
            tgc.border = this.border;
            tgc.bb = this.bb;
        }
    }
}

