/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.util.ResourceBridge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UrlZip
extends ZipFileSystem {
    public UrlZip(String rootPath, String fName, ResourceBridge rb) throws Exception {
        super(rootPath, fName, rb);
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(super.getInputStream(fName));
        ArrayList<UrlZipEntry> v = new ArrayList<UrlZipEntry>();
        while ((entry = zis.getNextEntry()) != null) {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = zis.read(buffer, 0, 1024)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            v.add(new UrlZipEntry(entry, baos.toByteArray()));
            zis.closeEntry();
        }
        zis.close();
        this.entries = v.toArray(new UrlZipEntry[v.size()]);
    }

    protected class UrlZipEntry
    extends ZipFileSystem.ExtendedZipEntry {
        byte[] data;

        UrlZipEntry(ZipEntry entry) {
            super(UrlZip.this, entry);
            this.data = null;
        }

        UrlZipEntry(ZipEntry entry, byte[] setData) {
            super(UrlZip.this, entry);
            this.data = setData;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.data;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }
    }
}

