/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.GlobalMouseAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ActiveMediaPlayer {
    public static final int AUDIO_BUFFERS = 10;
    protected static final AudioBuffer[] audioBuffer = new AudioBuffer[10];
    MediaContent mc;
    PlayStation ps;
    ActiveBox bx;
    Component visualComponent;
    GlobalMouseAdapter mouseAdapter;
    boolean useAudioBuffer;

    public static ActiveMediaPlayer createActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        ActiveMediaPlayer result = null;
        String playerClassName = null;
        String ms = ps.getOptions().getString("mediaSystem");
        switch (mc.mediaType) {
            case 5: 
            case 6: {
                if (ps.getOptions().getBoolean("Mac") && "QuickTime 6.1".equals(ms)) {
                    playerClassName = "edu.xtec.jclic.media.QT61ActiveMediaPlayer";
                    break;
                }
            }
            case 1: 
            case 3: {
                playerClassName = "edu.xtec.jclic.media.JavaSoundActiveMediaPlayer";
                break;
            }
            default: {
                if ("QuickTime 6.1".equals(ms)) {
                    playerClassName = "edu.xtec.jclic.media.QT61ActiveMediaPlayer";
                    break;
                }
                if ("Java Media Framework".equals(ms)) {
                    playerClassName = "edu.xtec.jclic.media.JMFActiveMediaPlayer";
                    break;
                }
                CheckMediaSystem.warn(ps.getOptions());
            }
        }
        if (playerClassName != null) {
            try {
                Class<?> c = Class.forName(playerClassName);
                Constructor<?> cons = c.getConstructor(MediaContent.class, MediaBag.class, PlayStation.class);
                result = (ActiveMediaPlayer)cons.newInstance(mc, mb, ps);
            }
            catch (Exception ex) {
                System.err.println("Error building media player:\n" + ex);
            }
        }
        return result;
    }

    protected ActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        this.mc = mc;
        this.ps = ps;
        this.bx = null;
        this.visualComponent = null;
        this.mouseAdapter = null;
        this.useAudioBuffer = false;
        try {
            switch (mc.mediaType) {
                case 5: {
                    ActiveMediaPlayer.clearAudioBuffer(mc.recBuffer);
                    ActiveMediaPlayer.audioBuffer[mc.recBuffer] = this.createAudioBuffer(mc.length);
                }
                case 6: {
                    this.useAudioBuffer = true;
                    break;
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error:\n" + ex);
        }
    }

    public abstract AudioBuffer createAudioBuffer(int var1) throws Exception;

    public abstract void realize();

    public void play(final ActiveBox setBx) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveMediaPlayer.stopAllAudioBuffers();
                ActiveMediaPlayer.this.playNow(setBx);
            }
        });
    }

    protected void playNow(ActiveBox setBx) {
        try {
            switch (this.mc.mediaType) {
                case 5: {
                    if (audioBuffer[this.mc.recBuffer] == null) break;
                    audioBuffer[this.mc.recBuffer].record(this.ps, setBx);
                    break;
                }
                case 6: {
                    if (audioBuffer[this.mc.recBuffer] == null) break;
                    audioBuffer[this.mc.recBuffer].play();
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error playing media \"" + this.mc.mediaFileName + "\":\n" + e);
        }
    }

    public void stop() {
        if (this.useAudioBuffer) {
            ActiveMediaPlayer.stopAudioBuffer(this.mc.recBuffer);
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public void clear() {
        this.stop();
        if (this.useAudioBuffer) {
            ActiveMediaPlayer.clearAudioBuffer(this.mc.recBuffer);
        }
    }

    protected abstract void setTimeRanges();

    public static void clearAudioBuffer(int buffer) {
        if (buffer >= 0 && buffer < 10 && audioBuffer[buffer] != null) {
            audioBuffer[buffer].clear();
            ActiveMediaPlayer.audioBuffer[buffer] = null;
        }
    }

    public static void clearAllAudioBuffers() {
        for (int i = 0; i < 10; ++i) {
            ActiveMediaPlayer.clearAudioBuffer(i);
        }
    }

    public static int countActiveBuffers() {
        int c = 0;
        for (AudioBuffer ab : audioBuffer) {
            if (ab == null) continue;
            ++c;
        }
        return c;
    }

    public static void stopAllAudioBuffers() {
        for (AudioBuffer ab : audioBuffer) {
            if (ab == null) continue;
            ab.stop();
        }
    }

    public static void stopAudioBuffer(int buffer) {
        if (buffer >= 0 && buffer < 10 && audioBuffer[buffer] != null) {
            audioBuffer[buffer].stop();
        }
    }

    public void checkVisualComponentBounds(ActiveBox bxi) {
        if (this.visualComponent == null) {
            return;
        }
        Rectangle enclosingRect = new Rectangle();
        if (!this.mc.free) {
            enclosingRect.setBounds(bxi.getBounds());
        } else {
            enclosingRect.setBounds(this.ps.getComponent().getBounds());
        }
        Point offset = new Point();
        Dimension dim = new Dimension(this.visualComponent.getPreferredSize());
        if (this.mc.absLocation != null) {
            offset.setLocation(this.mc.absLocation);
            if (offset.x + dim.width > enclosingRect.width) {
                offset.x = enclosingRect.width - dim.width;
            }
            if (offset.y + dim.height > enclosingRect.height) {
                offset.y = enclosingRect.height - dim.height;
            }
        }
        if (this.mc.stretch) {
            int extraH;
            int extraW = enclosingRect.width - offset.x - dim.width;
            if (extraW < 0) {
                dim.width = enclosingRect.width - offset.x;
                extraW = 0;
            }
            if ((extraH = enclosingRect.height - offset.y - dim.height) < 0) {
                dim.height = enclosingRect.height - offset.y;
                extraH = 0;
            }
            if (this.mc.absLocation == null) {
                offset.x += extraW / 2;
                offset.y += extraH / 2;
            }
        }
        Rectangle vRect = new Rectangle(enclosingRect.x + offset.x, enclosingRect.y + offset.y, dim.width, dim.height);
        this.visualComponent.setSize(dim);
        this.visualComponent.setLocation(vRect.getLocation());
        this.visualComponent.setBounds(vRect);
    }

    public void setVisualComponentVisible(boolean state) {
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(state);
        }
    }

    protected abstract Component getVisualComponent();

    public void attachVisualComponent() {
        if (this.mc.mediaType != 2 || this.bx == null) {
            return;
        }
        this.visualComponent = this.getVisualComponent();
        if (this.visualComponent == null) {
            return;
        }
        this.visualComponent.setVisible(false);
        JComponent cnt = this.bx.getContainerResolve();
        if (this.mc.free) {
            cnt = this.ps.getComponent();
        }
        if (cnt != this.visualComponent.getParent()) {
            cnt.add(this.visualComponent);
        }
        if (this.mouseAdapter == null && !this.mc.catchMouseEvents) {
            this.mouseAdapter = new GlobalMouseAdapter(cnt);
            this.mouseAdapter.attachTo(this.visualComponent, true);
        }
        this.checkVisualComponentBounds(this.bx);
        this.visualComponent.setVisible(true);
    }

    protected void destroyVisualComponent() {
        if (this.mouseAdapter != null) {
            this.mouseAdapter.detach(this.visualComponent);
            this.mouseAdapter = null;
        }
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(false);
            this.stop();
            this.visualComponent = null;
        }
    }

    public void linkTo(ActiveBox setBx) {
        if (this.bx != null && this.bx != setBx) {
            this.bx.setHostedMediaPlayer(null);
            this.destroyVisualComponent();
        }
        this.bx = setBx;
        if (this.bx != null) {
            this.bx.setHostedMediaPlayer(this);
        } else {
            this.destroyVisualComponent();
        }
    }

    public MediaContent getMediaContent() {
        return this.mc;
    }
}

