/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.EventSoundsElement;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jdom.Element;

public class EventSounds
implements Domable,
Cloneable {
    public static boolean globalEnabled = true;
    public static final String ELEMENT_NAME = "eventSounds";
    public static final String ENABLED = "enabled";
    public static final int START = 0;
    public static final int CLICK = 1;
    public static final int ACTION_ERROR = 2;
    public static final int ACTION_OK = 3;
    public static final int FINISHED_ERROR = 4;
    public static final int FINISHED_OK = 5;
    public static final int NUM_EVENTS = 6;
    public static final String[] EVENT_NAMES = new String[]{"start", "click", "actionError", "actionOk", "finishedError", "finishedOk"};
    protected EventSounds parent;
    protected EventSoundsElement[] elements = new EventSoundsElement[6];
    protected int enabled = 2;

    public EventSounds(EventSounds setParent) {
        this.parent = setParent;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        boolean empty = true;
        if (this.enabled != 2) {
            e.setAttribute(ENABLED, JDomUtility.triStateString(this.enabled));
            empty = false;
        }
        for (EventSoundsElement element : this.elements) {
            Element child;
            if (element == null || (child = element.getJDomElement()) == null) continue;
            e.addContent(child);
            empty = false;
        }
        return empty ? null : e;
    }

    public static EventSounds getEventSounds(Element e) throws Exception {
        EventSounds ev = new EventSounds(null);
        ev.setProperties(e, null);
        return ev;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.enabled = JDomUtility.getTriStateAttr(e, ENABLED, this.enabled);
        Iterator it = e.getChildren().iterator();
        while (it.hasNext()) {
            int index;
            EventSoundsElement ese = EventSoundsElement.getEventSoundsElement((Element)it.next());
            if (ese == null || (index = JDomUtility.getStrIndexAttr(ese.getId(), EVENT_NAMES, -1)) < 0 || index >= 6) continue;
            this.elements[index] = ese;
        }
    }

    public static void listReferences(Element e, Map<String, String> map) {
        for (Element child : e.getChildren("sound")) {
            String s;
            if (child == null || (s = child.getAttributeValue("file")) == null) continue;
            map.put(s, "media");
        }
    }

    public HashMap getReferences() {
        HashMap<String, String> result = new HashMap<String, String>();
        Element e = this.getJDomElement();
        if (e != null) {
            EventSounds.listReferences(e, result);
        }
        return result;
    }

    public void setParent(EventSounds p) {
        this.parent = p;
    }

    public boolean realize(Options options, MediaBag mediaBag) {
        Exception ext = null;
        try {
            for (EventSoundsElement element : this.elements) {
                if (element == null) continue;
                element.realize(options, mediaBag);
            }
        }
        catch (Exception ex) {
            System.err.println("Error realizing event sound:\n" + ex);
            ex.printStackTrace(System.out);
            ext = ex;
        }
        return ext == null;
    }

    public void setDataSource(int event, Object source, Options options) throws Exception {
        if (event < 0 || event >= 6) {
            return;
        }
        if (this.elements[event] == null) {
            this.elements[event] = new EventSoundsElement(EVENT_NAMES[event]);
        }
        this.elements[event].setDataSource(source, options);
    }

    public EventSoundsElement getElement(int event) {
        if (event < 0 || event >= 6) {
            return null;
        }
        return this.elements[event];
    }

    public EventSoundsElement createElement(int event) {
        if (event < 0 || event >= 6) {
            return null;
        }
        if (this.elements[event] == null) {
            this.elements[event] = new EventSoundsElement(EVENT_NAMES[event]);
        }
        return this.elements[event];
    }

    public int getEnabledChain(int event) {
        int st = this.enabled;
        if (st == 2 && event >= 0 && event < 6) {
            if (this.elements[event] == null) {
                st = this.parent == null ? st : this.parent.getEnabledChain(event);
            } else {
                st = this.elements[event].getEnabled();
                if (st == 2 && this.parent != null) {
                    st = this.parent.getEnabledChain(event);
                }
            }
        }
        return st;
    }

    public EventSoundsElement getElementChain(int event) {
        if (event < 0 || event >= 6) {
            return null;
        }
        EventSoundsElement ese = this.elements[event];
        if (ese == null && this.parent != null) {
            return this.parent.getElementChain(event);
        }
        return ese;
    }

    public void playNow(int event) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement ese = null;
        if (this.getEnabledChain(event) != 0 && (ese = this.getElementChain(event)) != null) {
            ese.play();
        }
    }

    public void play(int event) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement ese = null;
        if (this.getEnabledChain(event) != 0 && (ese = this.getElementChain(event)) != null) {
            final EventSoundsElement evs = ese;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    evs.play();
                }
            });
        }
    }

    public void close() {
        for (int i = 0; i < 6; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].close();
            this.elements[i] = null;
        }
        this.parent = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        EventSounds ev = new EventSounds(this.parent);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            ev.elements[i] = (EventSoundsElement)this.elements[i].clone();
        }
        ev.enabled = this.enabled;
        return ev;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }
}

