/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.ByteDataSource;
import edu.xtec.util.ExtendedByteArrayInputStream;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.media.protocol.DataSource;

public class JMFAudioPlayer
implements AudioPlayer {
    protected Player player = null;
    public static final Time zeroTime = new Time(0L);

    @Override
    public boolean setDataSource(Object source) throws Exception {
        this.close();
        if (source instanceof ExtendedByteArrayInputStream) {
            this.player = Manager.createPlayer((DataSource)new ByteDataSource((ExtendedByteArrayInputStream)source));
        } else if (source instanceof String) {
            MediaLocator ml = new MediaLocator((String)source);
            DataSource dataSource = Manager.createDataSource((MediaLocator)ml);
            this.player = Manager.createPlayer((DataSource)dataSource);
        }
        return this.player != null;
    }

    @Override
    public void realize(String fileName, MediaBag mediaBag) throws Exception {
        if (fileName != null) {
            this.setDataSource(mediaBag.getMediaDataSource(fileName));
        }
        if (this.player != null) {
            this.player.realize();
        }
    }

    @Override
    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    @Override
    public void play() {
        try {
            this.stop();
            this.player.setMediaTime(zeroTime);
            this.player.start();
        }
        catch (Exception ex) {
            System.err.println("Error playing system sound:\n" + ex);
        }
    }

    @Override
    public void stop() {
        if (this.player != null && this.player.getState() >= 600) {
            this.player.stop();
        }
    }
}

