/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.media.QT61AudioBuffer;
import edu.xtec.jclic.media.QT61Tools;
import java.awt.Component;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.std.movies.Movie;
import quicktime.std.movies.TimeInfo;

public class QT61ActiveMediaPlayer
extends ActiveMediaPlayer {
    MoviePlayer player = null;
    QTComponent canvas;
    boolean realized = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QT61ActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        super(mc, mb, ps);
        if (this.useAudioBuffer) return;
        try {
            this.player = QT61Tools.getPlayer(mb.getMediaDataSource(mc.mediaFileName));
            if (this.player == null) return;
        }
        catch (Exception ex) {
            System.err.println("Error reading media \"" + mc.mediaFileName + "\":\n" + ex);
        }
    }

    @Override
    public AudioBuffer createAudioBuffer(int seconds) throws Exception {
        return new QT61AudioBuffer(this.mc.length);
    }

    @Override
    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.attachVisualComponent();
                    this.player.getMovie().setTimeScale(1000);
                    this.setTimeRanges();
                    this.realized = true;
                }
            }
            catch (Exception ex) {
                System.err.println("QuickTime exception:\n" + ex);
            }
        }
    }

    @Override
    protected void playNow(ActiveBox setBx) {
        if (this.useAudioBuffer) {
            super.playNow(setBx);
        } else if (this.player != null) {
            try {
                this.stop();
                if (!this.realized) {
                    this.realize();
                }
                if (this.mc.mediaType == 2) {
                    this.linkTo(setBx);
                }
                this.attachVisualComponent();
                this.player.setTime(Math.max(this.mc.from, 0));
                TaskAllMovies.addMovieAndStart();
                this.player.getMovie().setActive(true);
                this.player.setRate(1.0f);
            }
            catch (Exception ex) {
                System.err.println("QuickTime Exception:\n" + ex);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.player.setRate(0.0f);
                    this.player.getMovie().setActive(false);
                    TaskAllMovies.removeMovie();
                }
            }
            catch (Exception ex) {
                System.err.println("QuickTime Error:\n" + ex);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.destroyVisualComponent();
                    this.realized = false;
                }
            }
            catch (Exception ex) {
                System.err.println("QuickTime Error:\n" + ex);
            }
        }
    }

    @Override
    protected void setTimeRanges() {
        if (this.useAudioBuffer || this.player == null) {
            return;
        }
        try {
            if (this.mc.from >= 0 || this.mc.to >= 0) {
                int from = Math.max(0, this.mc.from);
                int to = this.mc.to;
                if (to < 0) {
                    to = this.player.getDuration();
                }
                this.player.setTime(Math.max(this.mc.from, 0));
                this.player.getMovie().setActiveSegment(new TimeInfo(from, to - from));
            }
        }
        catch (Exception ex) {
            System.err.println("QuickTime Error:\n" + ex);
        }
    }

    @Override
    protected Component getVisualComponent() {
        if (this.player == null || this.mc.mediaType != 2) {
            return null;
        }
        if (this.canvas == null) {
            try {
                this.canvas = QTFactory.makeQTComponent((Movie)this.player.getMovie());
            }
            catch (Exception ex) {
                System.err.println("Error building QTCanvas!\n" + ex);
            }
        }
        return (Component)this.canvas;
    }
}

