/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jdom.Element;

public class Gradient
implements Cloneable,
Domable {
    protected Color c1;
    protected Color c2;
    protected int angle = 0;
    protected GradientPaint gp = null;
    protected Rectangle2D lastRect = null;
    protected boolean transparency = false;
    protected int cycles = 1;
    public static final String ELEMENT_NAME = "gradient";
    public static final String C1 = "source";
    public static final String C2 = "dest";
    public static final String ANGLE = "angle";
    public static final String CYCLES = "cycles";

    public Gradient(Color c1, Color c2, int angle, int cycles) {
        this.setColors(c1, c2);
        this.setAngle(angle);
        this.setCycles(cycles);
    }

    public Gradient() {
        this(Color.black, Color.white, 0, 1);
    }

    public Object clone() {
        return new Gradient(this.c1, this.c2, this.angle, this.cycles);
    }

    public boolean hasTransparency() {
        return this.transparency;
    }

    public void setCycles(int cycles) {
        this.cycles = Math.max(1, cycles);
        this.clear();
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setAngle(int angle) {
        this.angle = angle % 360;
        this.clear();
    }

    public int getAngle() {
        return this.angle;
    }

    public Color[] getColors() {
        return new Color[]{this.c1, this.c2};
    }

    public void setColors(Color c1, Color c2) {
        this.c1 = c1;
        this.c2 = c2;
        this.transparency = c1.getAlpha() != 255 || c2.getAlpha() != 255;
        this.clear();
    }

    public void clear() {
        this.gp = null;
        this.lastRect = null;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(C1, JDomUtility.colorToString(this.c1));
        e.setAttribute(C2, JDomUtility.colorToString(this.c2));
        e.setAttribute(ANGLE, Integer.toString(this.angle));
        if (this.cycles > 1) {
            e.setAttribute(CYCLES, Integer.toString(this.cycles));
        }
        return e;
    }

    public static Gradient getGradient(Element e) throws Exception {
        Gradient g = new Gradient();
        g.setProperties(e, null);
        return g;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.c1 = JDomUtility.getColorAttr(e, C1, this.c1);
        this.c2 = JDomUtility.getColorAttr(e, C2, this.c2);
        this.setAngle(JDomUtility.getIntAttr(e, ANGLE, this.angle));
        this.setCycles(JDomUtility.getIntAttr(e, CYCLES, this.cycles));
    }

    public void paint(Graphics2D g2, Shape shape) {
        Paint p = g2.getPaint();
        g2.setPaint(this.getGradient(shape));
        g2.fill(shape);
        g2.setPaint(p);
    }

    public GradientPaint getGradient(Shape shape) {
        Rectangle2D r = shape.getBounds2D();
        if (this.gp == null || this.lastRect == null || !this.lastRect.equals(r)) {
            this.lastRect = r;
            double rw = r.getWidth();
            double rh = r.getHeight();
            double radius = rw / 2.0;
            double alpha = Math.PI * (double)this.angle / 180.0;
            switch (this.angle) {
                case 0: 
                case 180: {
                    break;
                }
                case 90: 
                case 270: {
                    radius = rh / 2.0;
                    break;
                }
                default: {
                    radius = Math.sqrt(rw * rw + rh * rh) / 2.0;
                    double gamma = this.toFirstQuadrant(Math.atan2(rh, rw));
                    double beta = Math.abs(this.toFirstQuadrant(alpha) - gamma);
                    radius *= Math.cos(beta);
                }
            }
            float cx = (float)(r.getX() + rw / 2.0);
            float cy = (float)(r.getY() + rh / 2.0);
            float px = (float)(radius * Math.cos(alpha));
            float py = (float)(radius * Math.sin(alpha));
            this.gp = new GradientPaint(cx + px, cy - py, this.c1, cx + px - 2.0f * px / (float)this.cycles, cy - py + 2.0f * py / (float)this.cycles, this.c2, this.cycles > 1);
        }
        return this.gp;
    }

    protected double toFirstQuadrant(double a) {
        if (a > Math.PI) {
            a = Math.PI * 2 - a;
        }
        if (a > 1.5707963267948966) {
            a = Math.PI - a;
        }
        return a;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof Gradient) {
            Gradient g = (Gradient)obj;
            result = this.c1.equals(g.c1) && this.c2.equals(g.c2) && this.cycles == g.cycles && this.angle == g.angle;
        }
        return result;
    }
}

