/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import org.jdom.Element;

public class Author
implements Domable {
    public String name = new String();
    public String mail = null;
    public String url = null;
    public String organization = null;
    public String comments = null;
    public String rol = null;
    public static final String ELEMENT_NAME = "author";
    public static final String NAME = "name";
    public static final String MAIL = "mail";
    public static final String URL = "url";
    public static final String ORGANIZATION = "organization";
    public static final String COMMENTS = "comments";
    public static final String ROL = "rol";

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(NAME, this.name);
        if (this.mail != null) {
            e.setAttribute(MAIL, this.mail);
        }
        if (this.url != null) {
            e.setAttribute(URL, this.url);
        }
        if (this.rol != null) {
            e.setAttribute(ROL, this.rol);
        }
        if (this.organization != null) {
            e.setAttribute(ORGANIZATION, this.organization);
        }
        if (this.comments != null) {
            JDomUtility.addParagraphs(e, COMMENTS, this.comments);
        }
        return e;
    }

    public static Author getAuthor(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        Author a = new Author();
        a.name = JDomUtility.getStringAttr(e, NAME, a.name, true);
        a.mail = JDomUtility.getStringAttr(e, MAIL, a.mail, false);
        a.url = JDomUtility.getStringAttr(e, URL, a.url, false);
        a.rol = JDomUtility.getStringAttr(e, ROL, a.rol, false);
        a.organization = JDomUtility.getStringAttr(e, ORGANIZATION, a.organization, false);
        a.comments = JDomUtility.getParagraphs(e.getChild(COMMENTS));
        return a;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(e, NAME, this.name, true);
        this.mail = JDomUtility.getStringAttr(e, MAIL, this.mail, false);
        this.url = JDomUtility.getStringAttr(e, URL, this.url, false);
        this.rol = JDomUtility.getStringAttr(e, ROL, this.rol, false);
        this.organization = JDomUtility.getStringAttr(e, ORGANIZATION, this.organization, false);
        this.comments = JDomUtility.getParagraphs(e.getChild(COMMENTS));
    }

    public String toHtmlString(Messages msg) {
        Html html = new Html(500);
        if (this.rol != null) {
            html.append(this.rol).append(": ");
        }
        html.append(this.name);
        if (this.mail != null && this.mail.length() > 0) {
            html.sp().mailTo(this.mail, true);
        }
        if (this.url != null && this.url.length() > 0) {
            html.br().linkTo(this.url, null);
        }
        if (this.organization != null && this.organization.length() > 0) {
            html.br().appendParagraphs(this.organization);
        }
        if (this.comments != null && this.comments.length() > 0) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.rol != null && this.rol.length() > 0) {
            sb.append(" (").append(this.rol).append(")");
        }
        return sb.substring(0);
    }
}

