/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.ActionReg;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.BasicJDBCBridge;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.Messages;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;

public class JDBCReporter
extends Reporter {
    protected String currentSessionId = null;
    protected int actCount = 0;
    protected ActivityReg lastActivity = null;
    protected BasicJDBCBridge bridge = null;
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String SYSTEM_USER = "system_user";
    public static final String SYSTEM_PWD = "system_pwd";

    @Override
    public void end() {
        super.end();
        this.reportActivity();
        if (this.bridge != null) {
            this.bridge.end();
            this.bridge = null;
        }
    }

    @Override
    public void init(HashMap properties, Component parent, Messages msg) throws Exception {
        super.init(properties, parent, msg);
        boolean success = false;
        try {
            this.bridge = null;
            String driver = (String)properties.get(DRIVER);
            String url = (String)properties.get(URL);
            this.description = "JDBC " + url;
            String system_user = (String)properties.get(SYSTEM_USER);
            String system_pwd = (String)properties.get(SYSTEM_PWD);
            String tablePrefix = (String)properties.get("tablePrefix");
            boolean createTables = !"false".equalsIgnoreCase((String)properties.get("createTables"));
            ConnectionBeanProvider cbp = ConnectionBeanProvider.getConnectionBeanProvider(false, driver, url, system_user, system_pwd, true);
            this.bridge = new BasicJDBCBridge(cbp, createTables, tablePrefix);
            if (this.userId == null) {
                this.userId = this.promptUserId(parent, msg);
            }
            if (this.userId == null) {
                success = true;
            }
        }
        catch (Exception ex) {
            msg.showErrorWarning(parent, "report_err_init", this.description, ex, null);
        }
        if (!success) {
            if (this.bridge != null) {
                this.bridge.end();
                this.bridge = null;
            }
            this.description = this.description + " (" + msg.get("report_not_connected") + ")";
            this.initiated = false;
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) throws Exception {
        this.checkBridge();
        return this.bridge.getProperty(key, defaultValue);
    }

    @Override
    public List<GroupData> getGroups() throws Exception {
        this.checkBridge();
        return this.bridge.getGroups();
    }

    @Override
    public List<UserData> getUsers(String groupId) throws Exception {
        this.checkBridge();
        return this.bridge.getUsers(groupId);
    }

    @Override
    public String newGroup(GroupData gd) throws Exception {
        this.checkBridge();
        return this.bridge.newGroup(gd);
    }

    @Override
    public String newUser(UserData ud) throws Exception {
        this.checkBridge();
        return this.bridge.newUser(ud);
    }

    @Override
    public UserData getUserData(String userId) throws Exception {
        this.checkBridge();
        return this.bridge.getUserData(userId);
    }

    @Override
    public GroupData getGroupData(String groupId) throws Exception {
        this.checkBridge();
        return this.bridge.getGroupData(groupId);
    }

    protected void checkBridge() throws Exception {
        if (this.bridge == null) {
            throw new Exception("Not connected!");
        }
    }

    @Override
    public void newSession(JClicProject jcp, Component parent, Messages msg) {
        super.newSession(jcp, parent, msg);
        if (this.bridge == null || this.userId == null) {
            return;
        }
        this.reportActivity();
        this.currentSessionId = null;
    }

    public void createDBSession() {
        if (this.bridge == null || this.userId == null) {
            return;
        }
        try {
            this.actCount = 0;
            this.currentSessionId = this.bridge.addSession(this.userId, this.currentSession.timeMillis, this.currentSession.projectName, this.currentSession.code, this.sessionKey, this.sessionContext);
        }
        catch (Exception ex) {
            this.currentSessionId = null;
            this.bridge.end();
            this.bridge = null;
            this.initiated = false;
            System.err.println("Error creating report of session:\n" + ex);
        }
    }

    protected void reportActivity() {
        if (this.lastActivity != null && this.bridge != null) {
            if (!this.lastActivity.closed) {
                this.lastActivity.closeActivity();
            }
            if (this.currentSessionId == null) {
                this.createDBSession();
            }
            if (this.currentSessionId != null) {
                try {
                    ActionReg ar;
                    int actId = this.bridge.addActivity(this.actCount++, this.currentSessionId, this.lastActivity.name, this.lastActivity.numActions, this.lastActivity.score, this.lastActivity.solved, this.lastActivity.getPrecision(), (int)(this.lastActivity.totalTime / 1000L), this.lastActivity.code);
                    int arc = 0;
                    while ((ar = this.lastActivity.getActionReg(arc)) != null) {
                        this.bridge.addAction(actId, this.currentSessionId, arc, ar.type, ar.source, ar.dest, ar.isOk);
                        ++arc;
                    }
                }
                catch (Exception ex) {
                    this.bridge.end();
                    this.bridge = null;
                    this.initiated = false;
                    System.err.println("Error reporting activity:\n" + ex);
                }
            }
        }
        this.lastActivity = this.currentSession != null && this.currentSession.currentSequence != null && this.currentSession.currentSequence.currentActivity != this.lastActivity ? this.currentSession.currentSequence.currentActivity : null;
    }

    @Override
    public void newActivity(Activity act) {
        super.newActivity(act);
        this.reportActivity();
    }
}

