/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public abstract class Actions {
    public static Map<String, Object[]> getActionKeys(JComponent jc) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        ActionMap am = jc.getActionMap();
        for (Object amk : am.allKeys()) {
            String name;
            Object[] keys;
            Action act = am.get(amk);
            Object o = act.getValue("Name");
            if (o == null) {
                o = "";
            }
            if ((keys = (Object[])result.get(name = o.toString())) == null) {
                keys = new Object[]{amk};
            } else {
                Object[] k2 = new Object[keys.length + 1];
                for (int j = 0; j < keys.length; ++j) {
                    k2[j] = keys[j];
                }
                k2[j] = amk;
                keys = k2;
            }
            result.put(name, keys);
        }
        return result;
    }

    public static void dumpActionKeys(Map<String, Object[]> actionKeys, ActionMap am) {
        for (String key : actionKeys.keySet()) {
            System.out.println(key + ":");
            for (Object val : actionKeys.get(key)) {
                System.out.println(" - " + val + " >> " + am.get(val));
            }
        }
    }

    public static void mapAction(JComponent jc, Map<String, Object[]> actionKeys, Action act) {
        if (actionKeys == null) {
            actionKeys = Actions.getActionKeys(jc);
        }
        if (jc != null && act != null && actionKeys != null) {
            ActionMap am = jc.getActionMap();
            String name = (String)act.getValue("Name");
            Object[] keys = actionKeys.get(name);
            boolean replaced = false;
            if (keys != null) {
                for (Object key : keys) {
                    am.put(key, act);
                    if (!key.equals(name)) continue;
                    replaced = true;
                }
            }
            if (!replaced) {
                am.put(name, act);
            }
        }
    }

    public static void mapAction(JComponent jc, Map<String, Object[]> actionKeys, Action act, String key) {
        if (actionKeys == null) {
            actionKeys = Actions.getActionKeys(jc);
        }
        if (jc != null && actionKeys != null) {
            ActionMap am = jc.getActionMap();
            Object[] keys = actionKeys.get(key);
            boolean replaced = false;
            if (keys != null) {
                for (Object k : keys) {
                    am.put(k, act);
                    if (!k.equals(key)) continue;
                    replaced = true;
                }
            }
            if (!replaced) {
                am.put(key, act);
            }
        }
    }

    public static void mapNullAction(JComponent jc, Map<String, Object[]> actionKeys, String s) {
        Actions.mapAction(jc, actionKeys, new NullAction(s));
    }

    public static void mapTraceAction(JComponent jc, Map<String, Object[]> actionKeys, String s) {
        Actions.mapAction(jc, actionKeys, new TraceAction(jc.getActionMap().get(s), s));
    }

    public static void traceHierarchy(Component cmp, int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append(" ");
        }
        sb.append(cmp);
        System.out.println(sb.substring(0));
        if (cmp instanceof Container) {
            for (Component cmp2 : ((Container)cmp).getComponents()) {
                Actions.traceHierarchy(cmp2, level + 1);
            }
        }
    }

    public static class TraceAction
    extends AbstractAction {
        Action bkAction = null;
        Object bkKey = null;

        public TraceAction(Action act, Object key) {
            super((String)(key instanceof String ? key : ""));
            this.bkAction = act;
            this.bkKey = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("TRACE: " + (this.bkAction != null ? this.bkAction.getValue("Name") : "") + " " + this.bkKey);
            if (this.bkAction != null) {
                this.bkAction.actionPerformed(e);
            }
        }
    }

    public static class NullAction
    extends AbstractAction {
        public NullAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

