/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class LFUtil {
    public static final String LOOK_AND_FEEL = "lookAndFeel";
    public static final String DEFAULT = "default";
    public static final String SYSTEM = "system";
    public static final String METAL = "metal";
    public static final String MOTIF = "motif";
    public static final String WINDOWS = "windows";
    public static final String[] VALUES = new String[]{"default", "system", "metal", "motif"};

    public static void setLookAndFeel(String friendlyName, Component rootComponent) {
        if (friendlyName != null) {
            try {
                if (friendlyName.equals(DEFAULT)) {
                    LFUtil.setLookAndFeel(null, UIManager.getCrossPlatformLookAndFeelClassName(), rootComponent);
                } else if (friendlyName.equals(SYSTEM)) {
                    LFUtil.setLookAndFeel(null, UIManager.getSystemLookAndFeelClassName(), rootComponent);
                } else if (friendlyName.equals(METAL)) {
                    LFUtil.setLookAndFeel("javax.swing.plaf", "metal.MetalLookAndFeel", rootComponent);
                } else if (friendlyName.equals(MOTIF)) {
                    LFUtil.setLookAndFeel("com.sun.java.swing.plaf", "motif.MotifLookAndFeel", rootComponent);
                } else if (friendlyName.equals(WINDOWS)) {
                    LFUtil.setLookAndFeel("com.sun.java.swing.plaf", "windows.WindowsLookAndFeel", rootComponent);
                }
            }
            catch (Exception ex) {
                System.err.println("unable to set lookAndFeel to: \"" + friendlyName + "\"\n" + ex);
            }
        }
    }

    private static void setLookAndFeel(String prefix, String className, Component rootComponent) throws Exception {
        String cl = prefix != null && prefix.length() > 0 ? prefix + "." + className : className;
        UIManager.setLookAndFeel(cl);
        if (rootComponent != null) {
            SwingUtilities.updateComponentTreeUI(rootComponent);
        }
    }

    public static Color getSysColor(String key, Color defaultValue) {
        Color result = UIManager.getColor(key);
        return result == null ? defaultValue : result;
    }

    public static Color getColor(String key, Color defaultValue) {
        Color result = defaultValue;
        Object o = UIManager.get(key);
        if (o != null && o instanceof Color) {
            result = (Color)o;
        }
        return result;
    }

    public static Font getFont(String key, Font defaultValue) {
        Font result = defaultValue;
        Object o = UIManager.get(key);
        if (o != null && o instanceof Font) {
            result = (Font)o;
        }
        return result;
    }
}

