/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Window;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Options
extends HashMap<String, Object> {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final Boolean BTRUE = true;
    public static final Boolean BFALSE = false;
    public static final String MAC = "Mac";
    public static final String WIN = "Windows";
    public static final String JAVA131 = "java131";
    public static final String JAVA14 = "java14";
    public static final String JAVA141 = "java141";
    public static final String ARCH64BIT = "arch64bit";
    public static final String MAIN_PARENT_COMPONENT = "mainParentComponent";
    public static final String APPLET = "applet";
    public static final String LANGUAGE_BY_PARAM = "languageByParam";
    protected static final String[] TRANSIENT_KEYS = new String[]{"mainParentComponent", "applet", "languageByParam", "Mac", "Windows", "java14", "java131", "java141", "arch64bit", "messages"};

    public Options() {
        this.init();
    }

    public Options(Map<String, Object> t) {
        super(t);
        this.init();
    }

    public Options(Component cmp) {
        this.init();
        if (cmp != null) {
            this.setMainComponent(cmp);
        }
    }

    protected void init() {
        String s;
        String ver = System.getProperty("java.version");
        if (ver != null && ver.compareTo("1.3.1") >= 0) {
            this.put(JAVA131, true);
        }
        if (ver != null && ver.compareTo("1.4.0") >= 0) {
            this.put(JAVA14, true);
        }
        if (ver != null && ver.compareTo("1.4.1") >= 0) {
            this.put(JAVA141, true);
        }
        if ((s = System.getProperty("os.name").toLowerCase()) != null) {
            if (s.indexOf("mac") >= 0) {
                this.put(MAC, true);
                this.put("lookAndFeel", "system");
            } else if (s.toLowerCase().indexOf("win") >= 0) {
                this.put(WIN, true);
            }
        }
        if ("64".equals(s = System.getProperty("sun.arch.data.model"))) {
            this.put(ARCH64BIT, true);
        }
    }

    public Properties toProperties() {
        Properties prop = new Properties();
        for (Object k : this.keySet()) {
            Object v;
            int i;
            if (k == null || !(k instanceof String)) continue;
            for (i = 0; i < TRANSIENT_KEYS.length && !k.equals(TRANSIENT_KEYS[i]); ++i) {
            }
            if (i != TRANSIENT_KEYS.length || (v = this.get((String)k)) == null) continue;
            prop.setProperty((String)k, v.toString());
        }
        return prop;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean result = defaultValue;
        Object r = this.get(key);
        if (r != null) {
            if (r instanceof Boolean) {
                result = (Boolean)r;
            } else if (r instanceof String) {
                result = ((String)r).equalsIgnoreCase(TRUE);
            } else if (r instanceof Integer) {
                result = (Integer)r != 0;
            }
        }
        return result;
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, value ? BTRUE : BFALSE);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        return StrUtils.secureString(this.get(key), defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        int result = defaultValue;
        Object r = this.get(key);
        if (r != null) {
            if (r instanceof Integer) {
                result = (Integer)r;
            } else if (r instanceof String) {
                try {
                    result = Integer.parseInt((String)r);
                }
                catch (NumberFormatException ex) {
                    result = defaultValue;
                }
            }
        }
        return result;
    }

    public Messages getMessages() {
        return this.getMessages(null);
    }

    public Messages getMessages(String bundle) {
        return Messages.getMessages(this, bundle);
    }

    public String getMsg(String key) {
        return this.getMessages(null).get(key);
    }

    public Component getMainComponent() {
        return (Component)this.get(MAIN_PARENT_COMPONENT);
    }

    public Applet getApplet() {
        return (Applet)this.get(APPLET);
    }

    public void setMainComponent(Component cmp) {
        this.put(MAIN_PARENT_COMPONENT, cmp);
        if (cmp instanceof Applet) {
            this.put(APPLET, cmp);
        }
    }

    public void setLookAndFeel() {
        String s = this.getString("lookAndFeel");
        if (s != null) {
            LFUtil.setLookAndFeel(s, this.getMainComponent());
        }
    }

    public void syncProperties(Map src, boolean preserveExistingValues) {
        for (Map.Entry entry : src.entrySet()) {
            if (preserveExistingValues && this.containsKey(entry.getKey().toString())) continue;
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public static Map<String, Object> strToMap(String values, Map<String, Object> map, String delim, char equals, boolean nullsAllowed) {
        if (values != null && values.length() >= 0) {
            StringTokenizer st = new StringTokenizer(values, delim);
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int i = e.indexOf(equals);
                if (i <= 0) continue;
                String key = e.substring(0, i);
                String value = e.substring(i + 1);
                if (key == null || key.length() <= 0 || !nullsAllowed && values.length() <= 0) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    public static String getString(Map map, String key, String defaultValue) {
        String result = (String)map.get(key);
        return result == null ? defaultValue : result;
    }

    public static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Window) {
            return (Window)parentComponent;
        }
        return Options.getWindowForComponent(parentComponent.getParent());
    }

    public static Map<String, String> toStringMap(Properties prop) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> keys = prop.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = prop.getProperty(key);
            map.put(key, value);
        }
        return map;
    }
}

