/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class TripleString
implements Comparable<TripleString> {
    public static final int ELEMENTS = 3;
    public static final int NAME = 0;
    public static final int CLASS = 1;
    public static final int DESCRIPTION = 2;
    public static final char SEP = '|';
    String[] str = new String[3];

    public TripleString(String name, String className, String description) {
        this.str[0] = name;
        this.str[1] = className;
        this.str[2] = description;
    }

    public TripleString(String className, String nameAndDescription) {
        this.str[1] = className;
        if (nameAndDescription != null) {
            int p = (nameAndDescription = nameAndDescription.trim()).indexOf(124);
            if (p >= 0) {
                this.str[0] = nameAndDescription.substring(0, p);
                this.str[2] = nameAndDescription.substring(p + 1);
            } else {
                this.str[0] = nameAndDescription;
            }
        }
    }

    public String getStr(int index) {
        return index >= 0 && index < 3 ? this.str[index] : null;
    }

    public void setStr(int index, String s) {
        if (index >= 0 && index < 3) {
            this.str[index] = s;
        }
    }

    public String toString() {
        return this.str[0];
    }

    public String getDescription() {
        return this.str[2];
    }

    public String getClassName() {
        return this.str[1];
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null) {
            result = obj.equals(this.str[0]);
        }
        return result;
    }

    public static int getFirstItemWithClass(List<TripleString> tripleListObjects, String className) {
        int result = -1;
        if (className != null && tripleListObjects != null && !tripleListObjects.isEmpty()) {
            for (int i = 0; i < tripleListObjects.size(); ++i) {
                TripleString ts = tripleListObjects.get(i);
                if (!className.equals(ts.getClassName())) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public static List<TripleString> getTripleList(String bundlePath, Options options, boolean includeEmpty, boolean sorted, boolean lookInUserDir) throws Exception {
        ResourceBundle bundle = ResourceManager.getBundle(bundlePath, options.getMessages().getLocale());
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<TripleString> result = new ArrayList<TripleString>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().trim();
            String str = bundle.getString(key);
            if (str == null) continue;
            result.add(new TripleString(key, str));
        }
        if (lookInUserDir) {
            File file;
            String bundleName = bundlePath;
            int k = bundleName.lastIndexOf(46);
            if (k > 0) {
                bundleName = bundleName.substring(k + 1);
            }
            if ((file = new File(System.getProperty("user.home"), bundleName + ".properties")).exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(file));
                for (String string : prop.keySet()) {
                    String str = prop.getProperty(string);
                    if (str == null) continue;
                    result.add(new TripleString(string, str));
                }
            }
        }
        if (sorted) {
            Collections.sort(result);
        }
        if (includeEmpty) {
            result.add(0, new TripleString(options.getMsg("NONE"), null, null));
        }
        return result;
    }

    @Override
    public int compareTo(TripleString obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }
}

