/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.JNDIConnectionBeanProvider;
import edu.xtec.util.db.PooledConnectionBeanProvider;
import edu.xtec.util.db.SingleConnectionBeanProvider;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public abstract class ConnectionBeanProvider {
    public static final String DB_DRIVER = "dbDriver";
    public static final String DB_SERVER = "dbServer";
    public static final String DB_LOGIN = "dbLogin";
    public static final String DB_PASSWORD = "dbPassword";
    public static final String MAP_STATEMENTS = "dbMapStatements";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected String dbDriver;
    protected String dbServer;
    protected String dbLogin;
    protected String dbPassword;
    protected boolean mapStatements;
    private int useCount;
    private static Map<String, ConnectionBeanProvider> cbProviders;
    public static final String SETTINGS_TABLE_KEY = "SETTINGS_TABLE";
    public static final String DEFAULT_SETTINGS_TABLE = "SETTINGS";
    public static final String READ_FROM_DATABASE = "READ_FROM_DATABASE";

    protected void setUp(Map<String, String> map) throws Exception {
        this.dbDriver = this.getValue(map, DB_DRIVER, null);
        this.dbServer = this.getValue(map, DB_SERVER, null);
        this.dbLogin = this.getValue(map, DB_LOGIN, null);
        this.dbPassword = this.getValue(map, DB_PASSWORD, null);
        this.mapStatements = !FALSE.equals(this.getValue(map, MAP_STATEMENTS, TRUE));
        this.useCount = 0;
    }

    public abstract ConnectionBean getConnectionBean();

    public abstract String freeConnectionBean(ConnectionBean var1);

    protected abstract void destroy();

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(DB_DRIVER).append(": ").append(this.dbDriver).append("<br>\n");
        sb.append(DB_SERVER).append(": ").append(this.dbServer).append("<br>\n");
        sb.append(DB_LOGIN).append(": ").append(this.dbLogin).append("<br>\n");
        sb.append(MAP_STATEMENTS).append(": ").append(this.mapStatements).append("<br>\n");
        sb.append("Use count:").append(this.useCount).append("<br>\n");
        return sb.substring(0);
    }

    public static String getGlobalInfo() {
        StringBuilder sb = new StringBuilder();
        if (cbProviders == null) {
            cbProviders = new HashMap<String, ConnectionBeanProvider>(2);
        }
        sb.append("<b>").append(cbProviders.size()).append(" ConnectionBeanProviders created</b><br>\n");
        for (String key : cbProviders.keySet()) {
            ConnectionBeanProvider cbp = cbProviders.get(key);
            sb.append("<hr>\n");
            sb.append(cbp.getInfo());
        }
        return sb.substring(0);
    }

    public static ConnectionBeanProvider getConnectionBeanProvider(boolean pooled, String dbDriver, String dbServer, String dbLogin, String dbPassword, boolean mapStatements) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DB_DRIVER, dbDriver);
        map.put(DB_SERVER, dbServer);
        map.put(DB_LOGIN, dbLogin);
        map.put(DB_PASSWORD, dbPassword);
        map.put(MAP_STATEMENTS, mapStatements ? TRUE : FALSE);
        return ConnectionBeanProvider.getConnectionBeanProvider(pooled, map);
    }

    public static ConnectionBeanProvider getConnectionBeanProvider(boolean pooled, Map<String, String> map) throws Exception {
        ConnectionBeanProvider result = null;
        String staticDbDriver = map.get(DB_DRIVER);
        String staticDbServer = map.get(DB_SERVER);
        String staticDbLogin = map.get(DB_LOGIN);
        StringBuilder kb = new StringBuilder();
        kb.append(staticDbDriver).append("@");
        kb.append(staticDbServer).append("@");
        kb.append(staticDbLogin).append("@");
        kb.append(pooled ? "POOLED" : "DIRECT");
        String ks = kb.substring(0);
        if (cbProviders == null) {
            cbProviders = new HashMap<String, ConnectionBeanProvider>(2);
        } else {
            result = cbProviders.get(ks);
        }
        if (result == null) {
            result = "JNDI".equals(staticDbDriver) ? new JNDIConnectionBeanProvider() : (pooled ? new PooledConnectionBeanProvider() : new SingleConnectionBeanProvider());
            result.setUp(map);
            cbProviders.put(ks, result);
        }
        ++result.useCount;
        result.readDBSettings(map);
        return result;
    }

    public static void freeConnectionBeanProvider(ConnectionBeanProvider cbp) {
        if (cbp != null && cbProviders != null) {
            for (String s : cbProviders.keySet()) {
                ConnectionBeanProvider o = cbProviders.get(s);
                if (o == null || !o.equals(cbp) || --cbp.useCount > 0) continue;
                cbp.destroy();
                cbProviders.remove(s);
                break;
            }
        }
    }

    protected String getValue(Map<String, String> map, String key, String defaultValue) {
        String result = map.get(key);
        if (result == null || result.trim().length() == 0) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDBSettings(Map<String, String> map) throws Exception {
        Exception exception;
        block14: {
            exception = null;
            String settingsTable = this.getValue(map, SETTINGS_TABLE_KEY, DEFAULT_SETTINGS_TABLE);
            if (settingsTable != null && map.containsValue(READ_FROM_DATABASE)) {
                PreparedStatement stmt;
                ConnectionBean con;
                block13: {
                    con = null;
                    stmt = null;
                    ResultSet rs = null;
                    try {
                        con = this.getConnectionBean();
                        String sql = "SELECT SETTING_VALUE FROM " + settingsTable + " WHERE SETTING_KEY=?";
                        stmt = con.getPreparedStatement(sql);
                        for (String key : map.keySet()) {
                            String value = map.get(key);
                            if (!READ_FROM_DATABASE.equals(value)) continue;
                            stmt.setString(1, key);
                            rs = stmt.executeQuery();
                            if (!rs.next()) continue;
                            value = rs.getString(1);
                            map.put(key, value);
                        }
                        if (rs == null) break block13;
                    }
                    catch (Exception ex) {
                        exception = ex;
                        break block14;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null && con != null) {
                            con.closeStatement(stmt);
                        }
                        if (con != null) {
                            this.freeConnectionBean(con);
                        }
                    }
                    rs.close();
                }
                if (stmt != null && con != null) {
                    con.closeStatement(stmt);
                }
                if (con != null) {
                    this.freeConnectionBean(con);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

