/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.HTTPRequest;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.rp.ActReport;
import edu.xtec.jclic.report.rp.DbAdmin;
import edu.xtec.jclic.report.rp.GroupAdmin;
import edu.xtec.jclic.report.rp.GroupReport;
import edu.xtec.jclic.report.rp.Img;
import edu.xtec.jclic.report.rp.JClicReportService;
import edu.xtec.jclic.report.rp.Login;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.jclic.report.rp.UserAdmin;
import edu.xtec.jclic.report.rp.UserReport;
import edu.xtec.servlet.RequestProcessor;
import edu.xtec.servlet.ResourceRP;
import edu.xtec.util.Messages;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;

public class HTTPReportServer
extends ReportServerEventMaker {
    public static final int DEFAULT_PORT = 9000;
    public static final int DEFAULT_TIMEOUT = 1200;
    protected static final String[] URI = new String[]{"/login", "/main", "/dbAdmin", "/userReport", "/actReport", "/img", "/groupReport", "/groupAdmin", "/userAdmin", "/resource", "/JClicReportService"};
    protected static final Class[] CLS = new Class[]{Login.class, Main.class, DbAdmin.class, UserReport.class, ActReport.class, Img.class, GroupReport.class, GroupAdmin.class, UserAdmin.class, ResourceRP.class, JClicReportService.class};
    HttpThread httpThread;
    Messages messages;

    public HTTPReportServer(Messages messages) {
        this.messages = messages;
        this.httpThread = null;
        RequestProcessor.setDirectResources(true);
    }

    public boolean startServer(int port, int timeOut) {
        if (this.serverRunning()) {
            this.fireReportServerSystemEvent(this.messages.get("manage_server_already_started"), 5);
            return false;
        }
        try {
            this.httpThread = new HttpThread(port, timeOut);
            this.httpThread.start();
        }
        catch (Exception e) {
            this.fireReportServerSystemEvent(e.toString(), 5);
            return false;
        }
        return true;
    }

    public boolean stopServer() {
        if (!this.serverRunning()) {
            this.fireReportServerSystemEvent("Server is not started!", 5);
            return false;
        }
        this.httpThread.stopServer();
        while (this.serverRunning()) {
            Thread.yield();
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.serverRunning()) {
                this.stopServer();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean serverRunning() {
        return this.httpThread != null;
    }

    protected class HttpThread
    extends Thread {
        boolean running = false;
        ServerSocket ss = null;
        int socketTimeOut = 0;

        HttpThread(int port, int timeOut) throws Exception {
            this.ss = new ServerSocket(port);
            HTTPReportServer.this.fireReportServerSystemEvent(Integer.toString(port), 2);
            this.socketTimeOut = timeOut;
            this.running = false;
        }

        @Override
        public void run() {
            try {
                this.running = true;
                this.ss.setSoTimeout(1000);
                while (this.running) {
                    try {
                        Socket socket = this.ss.accept();
                        ClientConnection cc = new ClientConnection(socket);
                        cc.start();
                    }
                    catch (InterruptedIOException socket) {
                    }
                    catch (Exception ex) {
                        HTTPReportServer.this.fireReportServerSystemEvent(ex.toString(), 5);
                        this.running = false;
                    }
                }
                this.ss.close();
                HTTPReportServer.this.fireReportServerSystemEvent(null, 3);
            }
            catch (IOException e) {
                HTTPReportServer.this.fireReportServerSystemEvent(e.toString(), 5);
            }
            this.running = false;
            HTTPReportServer.this.httpThread = null;
        }

        public void stopServer() {
            this.running = false;
        }

        protected class ClientConnection
        extends Thread {
            Socket socket = null;
            int id = 0;

            ClientConnection(Socket socket) {
                this.socket = socket;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RequestProcessor rp = null;
                HTTPRequest re = null;
                try {
                    re = new HTTPRequest(this.socket);
                    HTTPReportServer.this.fireReportServerSocketEvent(this.socket, re.firstLine, 6);
                    String url = re.urlBase;
                    if (url == null || url.length() == 0 || url.equals("/")) {
                        url = URI[0];
                    }
                    Class<ResourceRP> cl = null;
                    for (int i = 0; i < URI.length; ++i) {
                        if (!URI[i].equals(url)) continue;
                        cl = CLS[i];
                        break;
                    }
                    int p = 0;
                    if (cl == null && re.urlBase != null && (p = re.urlBase.lastIndexOf(47)) >= 0 && p < re.urlBase.length() - 1) {
                        String s = re.urlBase.substring(p + 1);
                        re.params.put("id", new String[]{s});
                        cl = ResourceRP.class;
                    }
                    if (cl == null) {
                        re.error(404, null);
                    } else {
                        rp = (RequestProcessor)cl.newInstance();
                        rp.setParams(re.params);
                        if (rp.wantsInputStream()) {
                            rp.setInputStream(re.inputStream);
                        }
                        for (String key : re.cookies.keySet()) {
                            rp.setCookie(key, (String)re.cookies.get(key));
                        }
                        rp.init();
                        re.head.cache = !rp.noCache();
                        ArrayList<String[]> v = new ArrayList<String[]>();
                        rp.header(v);
                        if (!v.isEmpty()) {
                            Iterator it = v.iterator();
                            while (it.hasNext() && !re.head.commited) {
                                String[] h = (String[])it.next();
                                if (h[0].equals("ERROR")) {
                                    re.error(Integer.parseInt(h[1]), h[2]);
                                    continue;
                                }
                                if (h[0].equals("REDIRECT")) {
                                    re.redirect(h[1]);
                                    break;
                                }
                                if (h[0].equals("CONTENT_TYPE")) {
                                    re.head.contentType = h[1];
                                    continue;
                                }
                                if (h[0].equals("CONTENT_LENGTH")) {
                                    re.head.contentLength = Integer.parseInt(h[1]);
                                    continue;
                                }
                                if (h[0].equals("EXTRA")) {
                                    StringBuilder sb = new StringBuilder(100);
                                    if (re.head.extra != null) {
                                        sb.append(re.head.extra).append("\r\n");
                                    }
                                    sb.append(h[1]).append(": ").append(h[2]);
                                    re.head.extra = sb.substring(0);
                                    continue;
                                }
                                if (!h[0].equals("COOKIE")) continue;
                                re.cookies.put(h[1], h[2]);
                            }
                        }
                        if (!re.head.commited) {
                            re.head.write();
                            if (rp.usesWriter()) {
                                rp.process(re.pw);
                                re.pw.flush();
                                re.pw.close();
                            } else {
                                rp.process(re.os);
                                re.os.flush();
                                re.os.close();
                            }
                            re.commited = true;
                        }
                        rp.end();
                        rp = null;
                    }
                }
                catch (Exception ex) {
                    String errMsg;
                    int errCode = rp != null && rp.errCode >= 0 ? rp.errCode : 500;
                    String string = errMsg = rp != null && rp.errMsg != null ? rp.errMsg : ex.getMessage();
                    if (re != null && !re.head.commited) {
                        try {
                            re.error(errCode, errMsg);
                        }
                        catch (Exception ex2) {
                            System.err.println("Unable to report error due to\n" + ex2);
                        }
                    }
                    HTTPReportServer.this.fireReportServerSocketEvent(this.socket, ex.toString(), 5);
                    System.err.println("ERROR " + errCode + ": " + errMsg);
                    ex.printStackTrace(System.err);
                }
                finally {
                    if (rp != null) {
                        rp.end();
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to close socket due to:\n" + ex);
                    }
                }
            }
        }
    }
}

