/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import java.net.Socket;

public class ReportServerEvent {
    public static final int SYSTEM = 0;
    public static final int SOCKET = 1;
    public static final int DB = 2;
    public static final int CONNECT = 0;
    public static final int DISCONNECT = 1;
    public static final int START = 2;
    public static final int STOP = 3;
    public static final int MSG = 4;
    public static final int ERROR = 5;
    public static final int CONNECTION = 6;
    public int type;
    public int action;
    public String msg;
    public Socket socket;

    public ReportServerEvent(int type, String msg, Socket socket, int action) {
        this.type = type;
        this.msg = msg;
        this.socket = socket;
        this.action = action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.type == 0 ? "SYSTEM " : (this.type == 1 ? "" : "DB "));
        String sAct = "";
        switch (this.action) {
            case 0: {
                sAct = "CONNECT";
                break;
            }
            case 1: {
                sAct = "DISCONNECT";
                break;
            }
            case 2: {
                sAct = "START";
                break;
            }
            case 3: {
                sAct = "STOP";
                break;
            }
            case 5: {
                sAct = "ERROR";
                break;
            }
            case 6: {
                sAct = this.msg == null ? "CONNECTION" : "";
            }
        }
        sb.append(sAct).append(" ");
        if (this.socket != null) {
            sb.append(this.socket.getInetAddress().getHostAddress()).append(":").append(this.socket.getPort()).append(" ");
        }
        if (this.msg != null) {
            sb.append(this.msg);
        }
        return sb.substring(0);
    }
}

