/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public abstract class ReportUtils {
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
    public static final String ALPHANUM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String VALID_URL_CHARS = "-_.!~*'()";

    public static Date strToDate(String s) throws Exception {
        return ReportUtils.strToDate(s, false);
    }

    public static Date strToDate(String s, boolean atMidnight) throws Exception {
        GregorianCalendar gc = null;
        if (s.indexOf(47) > 0 || s.indexOf(45) > 0) {
            StringTokenizer st = new StringTokenizer(s, "/- ");
            gc = new GregorianCalendar(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()) - 1, Integer.parseInt(st.nextToken()), atMidnight ? 23 : 0, atMidnight ? 59 : 0, atMidnight ? 59 : 0);
        } else if (s.length() >= 8) {
            gc = new GregorianCalendar(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4, 6)) - 1, Integer.parseInt(s.substring(6, 8)), atMidnight ? 23 : 0, atMidnight ? 59 : 0, atMidnight ? 59 : 0);
        } else {
            throw new Exception("Bad date: " + s);
        }
        return gc.getTime();
    }

    public static String dateToStr(Date d) throws Exception {
        return SDF.format(d);
    }

    public static String urlEncode(String src, boolean strict, boolean spaces) {
        if (src == null || src.length() < 1) {
            return src;
        }
        int len = src.length();
        StringBuilder sb = new StringBuilder(src.length() * 2);
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ALPHANUM_CHARS.indexOf(ch) >= 0 || !strict && VALID_URL_CHARS.indexOf(ch) >= 0 || spaces && ch == ' ') {
                sb.append(ch);
                continue;
            }
            String s = Integer.toHexString(ch);
            if (ch < '\u0010') {
                sb.append("%0").append(s);
                continue;
            }
            if (ch > '\u00ff') {
                sb.append("%26%23").append(s).append("%3B");
                continue;
            }
            sb.append("%").append(s);
        }
        return sb.substring(0);
    }
}

