/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.util.Encryption;
import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.ResourceBundle;

public class DbAdmin
extends Basic {
    public static String TITLE = "db_admin_title";
    public static String URL = "dbAdmin";
    public static final int MENU = 0;
    public static final int EDIT_SETTINGS = 1;
    public static final int UPDATE_SETTINGS = 2;
    public static final int EDIT_PWD = 3;
    public static final int UPDATE_PWD = 4;
    public static final String[] ACTIONS = new String[]{"", "edit", "update", "editPwd", "updatePwd"};
    public static final String ALLOW_GROUP_CREATE = "agc";
    public static final String ALLOW_USER_CREATE = "auc";
    public static final String SHOW_GROUP_LIST = "shgl";
    public static final String SHOW_USER_LIST = "shul";
    public static final String USER_TABLES = "ut";
    public static final String TIME_LAP = "lap";
    public static final String[] DB_BOOL_KEYS = new String[]{"ALLOW_CREATE_GROUPS", "ALLOW_CREATE_USERS", "SHOW_GROUP_LIST", "SHOW_USER_LIST", "USER_TABLES"};
    public static final String[] DB_BOOL_PARAMS = new String[]{"agc", "auc", "shgl", "shul", "ut"};
    public static final String[] DB_LITERAL_KEYS = new String[]{"TIME_LAP"};
    public static final String[] DB_LITERAL_PARAMS = new String[]{"lap"};
    public static final int[] DB_LITERAL_PARAMS_LENGTH = new int[]{4};
    public static final String PW_FIELD = "pw";
    protected int page;

    @Override
    public String getTitle(ResourceBundle bundle) {
        return bundle.getString(TITLE);
    }

    @Override
    public String getUrl() {
        return DbAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int action) {
        return DbAdmin.urlParam(this.getUrl(), "action", ACTIONS[action]);
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.page = this.getAction(ACTIONS, 0);
        switch (this.page) {
            case 2: {
                this.updateSettings();
                break;
            }
            case 4: {
                this.updatePwd();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettings() throws Exception {
        block10: {
            Exception ex = null;
            boolean[] bValues = new boolean[DB_BOOL_PARAMS.length];
            for (int i = 0; i < DB_BOOL_PARAMS.length; ++i) {
                bValues[i] = this.getBoolParam(DB_BOOL_PARAMS[i], "on");
            }
            String[] sValues = new String[DB_LITERAL_PARAMS.length];
            for (int i = 0; i < DB_LITERAL_PARAMS.length; ++i) {
                sValues[i] = this.getParam(DB_LITERAL_PARAMS[i]);
            }
            ConnectionBeanProvider cbp = bridge.getConnectionBeanProvider();
            ConnectionBean cb = cbp.getConnectionBean();
            PreparedStatement updateStmt = null;
            PreparedStatement insertStmt = null;
            try {
                int i;
                updateStmt = cb.getPreparedStatement("UPDATE " + bridge.getTableName("SETTINGS") + " SET SETTING_VALUE=? WHERE SETTING_KEY=?");
                insertStmt = cb.getPreparedStatement("INSERT INTO " + bridge.getTableName("SETTINGS") + "(SETTING_KEY,SETTING_VALUE) VALUES(?,?)");
                for (i = 0; i < DB_BOOL_PARAMS.length; ++i) {
                    this.updateItem(DB_BOOL_KEYS[i], bValues[i] ? "true" : "false", updateStmt, insertStmt);
                }
                for (i = 0; i < DB_LITERAL_PARAMS.length; ++i) {
                    this.updateItem(DB_LITERAL_KEYS[i], sValues[i], updateStmt, insertStmt);
                }
                cb.closeStatement(updateStmt);
                cb.closeStatement(insertStmt);
                cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(updateStmt);
                cb.closeStatement(insertStmt);
                cbp.freeConnectionBean(cb);
                if (ex == null) break block10;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    private void updateItem(String sk, String sv, PreparedStatement updateStmt, PreparedStatement insertStmt) throws Exception {
        updateStmt.setString(1, sv);
        updateStmt.setString(2, sk);
        int iRecords = updateStmt.executeUpdate();
        if (iRecords != 1) {
            if (iRecords == 0) {
                insertStmt.setString(1, sk);
                insertStmt.setString(2, sv);
                iRecords = insertStmt.executeUpdate();
            }
            if (iRecords != 1) {
                throw new Exception(this.bundle.getString("db_admin_settings_error"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePwd() throws Exception {
        block9: {
            Exception ex = null;
            String newPwd = this.getParam(PW_FIELD);
            Object s = null;
            ConnectionBeanProvider cbp = bridge.getConnectionBeanProvider();
            ConnectionBean cb = cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                stmt = cb.getPreparedStatement("SELECT count(*) FROM " + bridge.getTableName("SETTINGS") + " WHERE SETTING_KEY=?");
                stmt.setString(1, "PASSWORD");
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    PreparedStatement stmt2;
                    newPwd = newPwd != null ? Encryption.Encrypt(newPwd) : null;
                    int iCount = rs.getInt(1);
                    if (iCount == 0) {
                        stmt2 = cb.getPreparedStatement("INSERT INTO " + bridge.getTableName("SETTINGS") + " (SETTING_KEY,SETTING_VALUE) VALUES(?,?)");
                        stmt2.setString(1, "PASSWORD");
                        stmt2.setString(2, newPwd);
                    } else {
                        stmt2 = cb.getPreparedStatement("UPDATE " + bridge.getTableName("SETTINGS") + " SET SETTING_VALUE=? WHERE SETTING_KEY=?");
                        stmt2.setString(1, newPwd);
                        stmt2.setString(2, "PASSWORD");
                    }
                    stmt2.executeUpdate();
                    cb.closeStatement(stmt2);
                }
                rs.close();
                cb.closeStatement(stmt);
                cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                cbp.freeConnectionBean(cb);
                if (ex == null) break block9;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        if (this.page == 3) {
            StringBuilder sb = new StringBuilder(500);
            this.writeEditPwdScript(sb);
            out.println(sb.substring(0));
        }
    }

    @Override
    public void body(PrintWriter out) throws Exception {
        super.body(out);
        String titleKey = this.page == 1 ? "db_admin_edit_title" : (this.page == 3 ? "db_admin_pw_edit_title" : "db_admin_title");
        StringBuilder sb = new StringBuilder(3000);
        sb.append(DbAdmin.linkTo(DbAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        if (this.page != 0) {
            sb.append(" | ").append(DbAdmin.linkTo(this.getUrl(), this.getTitle(this.bundle), null));
        }
        this.standardHeader(out, DbAdmin.filter(this.getMsg(titleKey)), sb.substring(0));
        sb.setLength(0);
        switch (this.page) {
            case 1: {
                sb.append("<form action=\"").append(this.getUrl(2)).append("\" method=\"post\">\n");
                sb.append("<div class=\"inputForm\">\n");
                this.writeAdminFields(sb, true);
                sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"></p>\n");
                sb.append("</div>\n");
                sb.append("</form>\n");
                break;
            }
            case 3: {
                this.writeEditPwd(sb);
                break;
            }
            default: {
                sb.append("<form>\n");
                sb.append("<div class=\"inputForm\">\n");
                this.writeAdminFields(sb, false);
                sb.append("<p>").append(DbAdmin.buttonTo(this.getUrl(1), this.bundle.getString("db_admin_edit_btn"), null));
                sb.append("&nbsp;");
                sb.append(DbAdmin.buttonTo(this.getUrl(3), this.bundle.getString("db_admin_pw_edit_btn"), null)).append("</p>");
                sb.append("</div>\n");
                sb.append("</form>\n");
            }
        }
        out.println(sb.substring(0));
    }

    private void writeEditPwdScript(StringBuilder sb) throws Exception {
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("<!--\n");
        sb.append(" function verifyPasswords(){\n");
        sb.append("  if (document.forms[0].").append(PW_FIELD).append("2.value==document.forms[0].").append(PW_FIELD).append(".value) document.forms[0].submit();\n");
        sb.append("  else{\n");
        sb.append("    alert(\"").append(this.getMsg("db_admin_pw_noFit")).append("\");\n");
        sb.append("    event.returnValue=false;\n");
        sb.append("  }\n");
        sb.append(" }\n");
        sb.append("//-->\n");
        sb.append("</script>\n");
    }

    private void writeEditPwd(StringBuilder sb) throws Exception {
        sb.append("<form action=\"").append(DbAdmin.urlParam(this.getUrl(), "action", ACTIONS[4])).append("\" method=\"post\" onSubmit=\"verifyPasswords();\">\n");
        sb.append("<div class=\"inputForm\">\n");
        sb.append("<p>").append(this.getMsg("db_admin_pw_newPwd")).append(": ");
        sb.append("<input type=\"password\" length=\"40\" name=\"").append(PW_FIELD).append("\"></p>\n");
        sb.append("<p>").append(this.getMsg("db_admin_pw_verifyPwd")).append(": ");
        sb.append("<input type=\"password\" length=\"40\" name=\"").append(PW_FIELD).append("2\"></p>\n");
        sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\">\n");
        sb.append("</div>\n");
        sb.append("</form>\n");
    }

    private void writeAdminFields(StringBuilder sb, boolean edit) throws Exception {
        String s;
        int i;
        Map<String, String> settings = bridge.getProperties();
        for (i = 0; i < DB_BOOL_PARAMS.length; ++i) {
            sb.append("<p>").append(DbAdmin.filter(this.getMsg("db_admin_param_" + DB_BOOL_PARAMS[i])));
            sb.append(" <input type=\"checkbox\" name=\"").append(DB_BOOL_PARAMS[i]).append("\" value=\"").append("on").append("\"");
            if (!edit) {
                sb.append(" disabled");
            }
            if ((s = settings.get(DB_BOOL_KEYS[i])) != null && s.trim().toLowerCase().equals("true")) {
                sb.append(" checked");
            }
            sb.append("></p>\n");
        }
        for (i = 0; i < DB_LITERAL_PARAMS.length; ++i) {
            sb.append("<p>");
            sb.append(DbAdmin.filter(this.getMsg("db_admin_param_" + DB_LITERAL_PARAMS[i])));
            sb.append(" <input name=\"").append(DB_LITERAL_PARAMS[i]).append("\"");
            s = settings.get(DB_LITERAL_KEYS[i]);
            if (s != null) {
                sb.append(" value=\"").append(s).append("\"");
            }
            if (!edit) {
                sb.append(" disabled");
            }
            sb.append(" size=\"").append(DB_LITERAL_PARAMS_LENGTH[i]).append("\">");
            sb.append("</p>\n");
        }
    }
}

