/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import edu.xtec.jclic.report.rp.GroupAdmin;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.util.Encryption;
import edu.xtec.util.StrUtils;
import java.io.PrintWriter;
import java.util.ResourceBundle;

public class UserAdmin
extends Basic {
    public static String TITLE = "user_admin_title";
    public static String URL = "userAdmin";
    public static final String GROUP = "group";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String USER = "user";
    public static final String PASS = "pass";
    public static final String PASSC = "passc";
    public static final int USER_MENU = 0;
    public static final int EDIT = 1;
    public static final int EDIT_UPDATE = 2;
    public static final int CREATE = 3;
    public static final int CREATE_UPDATE = 4;
    public static final int DELETE = 5;
    public static final int DELETE_UPDATE = 6;
    public static final int CLEAR = 7;
    public static final int CLEAR_UPDATE = 8;
    public static final int ERR = 9;
    public static final String[] ACTIONS = new String[]{"", "edit", "editUpd", "create", "createUpd", "del", "delUpd", "clear", "clearUpd"};
    protected int page;
    protected DateManager dm;
    protected GroupData gd;
    protected UserData ud;
    protected boolean err = true;
    protected String returnUrl;

    @Override
    public String getTitle(ResourceBundle bundle) {
        return bundle.getString(TITLE);
    }

    @Override
    public String getUrl() {
        return UserAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int action) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(URL);
        UserAdmin.urlParamSb(sb, "lang", this.lang, true);
        UserAdmin.urlParamSb(sb, "action", ACTIONS[action], false);
        if (this.ud != null) {
            UserAdmin.urlParamSb(sb, USER, this.ud.getId(), false);
        } else if (this.gd != null) {
            UserAdmin.urlParamSb(sb, GROUP, this.gd.getId(), false);
        }
        return sb.substring(0);
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        String uId = this.getParamNotNull(USER);
        if (uId.length() > 0) {
            this.ud = bridge.getUserData(uId);
        }
        String gId = this.getParamNotNull(GROUP);
        if (this.ud != null) {
            gId = this.ud.groupId;
        }
        if (gId.length() > 0) {
            this.gd = bridge.getGroupData(gId);
        }
        this.page = this.getAction(ACTIONS, 0);
        if (this.page == 7 || this.page == 8) {
            this.dm = new DateManager(this);
            if (!this.dm.init()) {
                return false;
            }
        }
        switch (this.page) {
            case 2: {
                this.edit();
                break;
            }
            case 4: {
                this.create();
                break;
            }
            case 6: {
                this.delete();
                break;
            }
            case 8: {
                this.clear();
            }
        }
        return true;
    }

    protected void edit() throws Exception {
        this.returnUrl = this.getUrl(0);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String name = this.getParamNotNull(NAME).trim();
        String pass = StrUtils.nullableString(this.getParam(PASS));
        String passc = StrUtils.nullableString(this.getParam(PASSC));
        if (name.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_name");
        } else if (!StrUtils.compareObjects(pass, passc)) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_err_bad_pw");
        } else {
            this.ud.setText(name);
            this.ud.pwd = pass == null ? null : Encryption.Encrypt(pass);
            this.ud.setIconUrl(this.getParamNotNull(ICON).trim());
            try {
                bridge.updateUser(this.ud, false);
                this.page = 0;
            }
            catch (Exception ex) {
                this.errMsg = this.errMsg + ex.getLocalizedMessage();
            }
        }
    }

    protected String getGroupUrl() {
        StringBuilder sb = new StringBuilder(300);
        sb.append(GroupAdmin.URL);
        UserAdmin.urlParamSb(sb, "lang", this.lang, true);
        UserAdmin.urlParamSb(sb, "action", GroupAdmin.ACTIONS[1], false);
        UserAdmin.urlParamSb(sb, GROUP, this.gd.getId(), false);
        return sb.substring(0);
    }

    protected void create() throws Exception {
        this.returnUrl = this.getGroupUrl();
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String name = this.getParamNotNull(NAME).trim();
        String id = this.getParamNotNull(ID).trim();
        String icon = this.getParamNotNull(ICON).trim();
        String pass = StrUtils.nullableString(this.getParam(PASS));
        String passc = StrUtils.nullableString(this.getParam(PASSC));
        if (name.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_name");
        } else if (id.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_invalid_id");
        } else if (!StrUtils.compareObjects(pass, passc)) {
            this.errMsg = this.errMsg + this.getMsg("user_admin_err_bad_pw");
        } else {
            this.ud = bridge.getUserData(id);
            if (this.ud != null) {
                this.returnUrl = UserAdmin.urlParam(UserAdmin.urlParam(this.getUrl(3), NAME, name), ICON, icon);
                this.errMsg = this.errMsg + this.getMsg("user_admin_id_already_exists");
            } else {
                try {
                    this.ud = new UserData(id, name, icon, null, this.gd.getId());
                    this.ud.pwd = pass == null ? null : Encryption.Encrypt(pass);
                    bridge.updateUser(this.ud, true);
                    this.page = 0;
                }
                catch (Exception ex) {
                    this.ud = null;
                    this.errMsg = this.errMsg + ex.getLocalizedMessage();
                }
            }
        }
    }

    protected void delete() throws Exception {
        this.returnUrl = this.getUrl(0);
        try {
            bridge.deleteUser(this.ud.getId());
            this.ud = null;
            this.errMsg = this.getMsg("user_admin_user_deleted");
            this.err = false;
            this.returnUrl = this.getGroupUrl();
        }
        catch (Exception ex) {
            this.returnUrl = this.getUrl(0);
            this.errMsg = this.getMsg("db_error") + "<BR>" + ex.getLocalizedMessage();
        }
    }

    protected void clear() throws Exception {
        this.returnUrl = this.getUrl(0);
        try {
            bridge.clearUserReportData(this.ud.getId(), this.dm.dFrom, this.dm.dTo);
            this.page = 0;
        }
        catch (Exception ex) {
            this.errMsg = this.getMsg("db_error") + "<BR>" + ex.getLocalizedMessage();
        }
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        if (this.page == 7) {
            StringBuilder sb = new StringBuilder(300);
            this.dm.writeDateScript(sb);
            out.println(sb.substring(0));
        }
    }

    @Override
    public void body(PrintWriter out) throws Exception {
        super.body(out);
        StringBuilder sb = new StringBuilder(3000);
        StringBuilder sb2 = new StringBuilder(500);
        boolean flag = false;
        sb.append(UserAdmin.linkTo(UserAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        sb.append(" | ");
        sb.append(UserAdmin.linkTo(UserAdmin.urlParam(GroupAdmin.URL, "lang", this.lang), this.bundle.getString(GroupAdmin.TITLE), null));
        if (this.gd != null) {
            sb.append(" | ");
            sb.append(UserAdmin.linkTo(this.getGroupUrl(), this.gd.getText(), null));
        }
        if (this.page != 0 && this.ud != null) {
            sb.append(" | ").append(UserAdmin.linkTo(this.getUrl(0), this.ud.getText(), null));
        }
        this.standardHeader(out, UserAdmin.filter(this.getTitle(this.bundle)), sb.substring(0));
        sb.setLength(0);
        if (this.ud == null && this.page != 3 && this.page != 6) {
            this.page = 9;
            if (this.errMsg == null) {
                this.errMsg = this.getMsg("bad_data");
            }
            this.err = true;
        }
        switch (this.page) {
            case 0: {
                sb.append("<form class=\"info\">\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_id")).append("</strong> ").append(UserAdmin.filter(this.ud.getId())).append("</p>\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_name")).append("</strong> ").append(UserAdmin.filter(this.ud.getText())).append("</p>\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_pw_prompt")).append("</strong> ").append(this.ud.pwd == null ? "" : "***").append("</p>\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_icon")).append("</strong> ");
                if (this.ud.getIconUrl() != null && this.ud.getIconUrl().length() > 0) {
                    sb.append("<img src=\"").append(UserAdmin.filter(this.ud.getIconUrl())).append("\"");
                    sb.append(" title=\"").append(UserAdmin.filter(this.ud.getIconUrl())).append("\">");
                } else {
                    sb.append("---\n");
                }
                sb.append("</p>\n");
                sb.append("<p>");
                sb.append(UserAdmin.buttonTo(this.getUrl(1), this.getMsg("user_admin_edit_button"), null));
                sb.append(UserAdmin.buttonTo(this.getUrl(5), this.getMsg("user_admin_delete_button"), null));
                sb.append(UserAdmin.buttonTo(this.getUrl(7), this.getMsg("user_admin_clear_button"), null));
                sb.append("</p>\n");
                sb.append("</form>\n");
                sb.append("<br clear=\"all\">\n");
                break;
            }
            case 1: {
                flag = true;
            }
            case 3: {
                String id = this.ud != null ? this.ud.getId() : this.getParamNotNull(ID).trim();
                String name = this.ud != null ? this.ud.getText() : this.getParamNotNull(NAME).trim();
                String icon = this.ud != null ? this.ud.getIconUrl() : this.getParamNotNull(ICON).trim();
                String pass = this.ud != null ? Encryption.Decrypt(this.ud.pwd) : this.getParam(PASS);
                sb.append("<form class=\"inputForm\" method=\"post\" action=\"").append(this.getUrl(flag ? 2 : 4)).append("\">\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_id")).append("</strong> ");
                sb.append("<input name=\"").append(ID).append("\" value=\"").append(UserAdmin.filter(id)).append("\" size=40 ");
                if (flag) {
                    sb.append("readonly");
                }
                sb.append(">\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_name")).append("</strong> ");
                sb.append("<input name=\"").append(NAME).append("\" value=\"").append(UserAdmin.filter(name)).append("\" size=40></p>\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_pw_prompt")).append("</strong> ");
                sb.append("<input name=\"").append(PASS).append("\" type=\"password\" value=\"").append(pass == null ? "" : UserAdmin.filter(pass)).append("\" size=20><br>\n");
                sb.append("<strong>").append(this.getMsg("user_admin_pw_prompt_confirm")).append("</strong> ");
                sb.append("<input name=\"").append(PASSC).append("\" type=\"password\" value=\"").append(pass == null ? "" : UserAdmin.filter(pass)).append("\" size=20></p>\n");
                sb.append("<p><strong>").append(this.getMsg("user_admin_icon")).append("</strong> ");
                sb.append("<input name=\"").append(ICON).append("\" value=\"").append(UserAdmin.filter(icon)).append("\" size=40></p>\n");
                sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"> ");
                sb.append(UserAdmin.buttonTo(flag ? this.getUrl(0) : this.getGroupUrl(), this.getMsg("cancel"), null)).append("</p>\n");
                sb.append("</form>\n");
                sb.append("<br clear=\"all\">\n");
                break;
            }
            case 5: {
                sb.append("<p><strong>").append(this.getMsg("user_admin_delete_user")).append(" \"").append(UserAdmin.filter(this.ud.getText())).append("\"</strong></p>\n");
                sb.append("<p>").append(this.getMsg("user_admin_delete_user_explain")).append("</p>\n");
                sb.append("<p>").append(this.getMsg("report_areyousure")).append("</p>\n");
                sb.append("<form method=\"post\" action=\"").append(this.getUrl(6)).append("\">\n");
                sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("YES")).append("\" width=50> ");
                sb.append(UserAdmin.buttonTo(this.getUrl(0), this.getMsg("NOT"), "width=50"));
                sb.append("</p>\n");
                sb.append("</form>\n");
                break;
            }
            case 7: {
                sb.append("<p><strong>").append(this.getMsg("user_admin_clear_user")).append(" \"").append(UserAdmin.filter(this.ud.getText())).append("\"</strong></p>\n");
                sb.append("<p>").append(this.getMsg("user_admin_clear_user_explain")).append("</p>\n");
                sb.append("<form class=\"inputForm\" action=\"").append(this.getUrl(8)).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
                this.dm.writeHiddenFields(sb);
                sb2.setLength(0);
                sb2.append("document.").append("mainForm").append(".submit()");
                this.dm.zonaData(sb, UserAdmin.buttonAction(sb2.substring(0), this.getMsg("db_clear_reports_date"), null));
                sb.append("</form>\n");
                sb.append("<br clear=\"all\">\n");
                break;
            }
            default: {
                sb.append("<p><strong>").append(this.getMsg(this.err ? "error" : "success")).append("</strong></p>\n");
                if (this.errMsg != null) {
                    sb.append("<p>").append(this.errMsg).append("</p>\n");
                }
                if (this.returnUrl == null) break;
                sb.append("<p><a href=\"").append(this.returnUrl).append("\">").append(this.getMsg("return")).append("</a></p>\n");
            }
        }
        out.println(sb.substring(0));
    }
}

