/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.servlet.RequestProcessor;
import edu.xtec.util.ResourceManager;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceRP
extends RequestProcessor {
    protected String objectName;
    protected byte[] objectData;
    public static final String ID = "id";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String RESOURCE_BASE = "html/";
    protected static Map<String, Object> objects = new HashMap<String, Object>();
    protected static String dateStr = ResourceRP.httpDate(new Date());

    @Override
    public boolean noCache() {
        return false;
    }

    @Override
    public boolean init() throws Exception {
        this.objectName = this.getParam(ID);
        if (this.objectName != null) {
            this.objectData = (byte[])objects.get(this.objectName);
            if (this.objectData == null) {
                try {
                    StringBuilder sb = new StringBuilder(RESOURCE_BASE);
                    sb.append(this.objectName);
                    this.objectData = ResourceManager.getResourceBytes(sb.substring(0));
                    objects.put(this.objectName, this.objectData);
                }
                catch (Exception ex) {
                    this.errCode = 404;
                    this.errMsg = this.objectName + " not found!";
                }
            }
        } else {
            this.errCode = 400;
            this.errMsg = "Unespecified object id!";
        }
        return true;
    }

    @Override
    public void header(List<String[]> v) {
        super.header(v);
        if (this.objectData != null) {
            String ct = null;
            if (this.objectName.endsWith(".gif")) {
                ct = "image/gif";
            } else if (this.objectName.endsWith(".jpg")) {
                ct = "text/jpg";
            } else if (this.objectName.endsWith(".css")) {
                ct = "text/css";
            }
            if (ct != null) {
                v.add(new String[]{"CONTENT_TYPE", ct});
            }
            v.add(new String[]{"CONTENT_LENGTH", Integer.toString(this.objectData.length)});
            v.add(new String[]{"EXTRA", LAST_MODIFIED, dateStr});
        }
    }

    @Override
    public boolean usesWriter() {
        return false;
    }

    @Override
    public void process(OutputStream out) throws Exception {
        if (this.objectData != null) {
            out.write(this.objectData, 0, this.objectData.length);
        }
    }
}

