/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.AuthorSingleFrame;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.util.Check;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JClicAuthorApplet
extends JApplet
implements Constants {
    private Options options = new Options(this);
    private RunnableComponent rc = null;
    private String activityPack = null;
    private String sequence = null;
    private boolean initiated = false;
    private boolean trace = false;
    private JLabel splashLabel = new JLabel(" ", ResourceManager.getImageIcon("icons/logo_author.png"), 0);
    private boolean isInstaller;
    private static final String HTTP = "http:";
    private static final String FILE = "file:";
    private static final String STRING = "string";
    private static final String BOOL = "boolean";
    private static final String URL = "url";
    private static final String ACTIVITY_PACK = "activityPack";
    private static final String SEQUENCE = "sequence";
    private static final int NUM_PRIVATE_PARAMS = 2;
    private static final String[][] pInfo = new String[][]{{"activityPack", "string", "absolute or relative URL of the JClic project to load"}, {"sequence", "string", "optional project's starting sequence name"}, {"language", "string", "two-char language code"}, {"country", "string", "two-char country code"}, {"variant", "string", "locale variant code"}, {"skin", "string", "skin to be used"}, {"cookie", "string", "optional session cookie value. currently not used"}, {"reporter", "string", "reporter class name"}, {"reporterParams", "string", "reporter parameters"}, {"exitUrl", "url", "URL where to redirect navigation at end"}, {"infoUrlFrame", "string", "optional frame where to display info documents. If unespecified, _BLANK will be used"}, {"systemSounds", "boolean", "to play or not system sounds"}, {"compressImages", "boolean", "to compress or not images in cells"}, {"lookAndFeel", "string", "look & feel to use"}, {"audioEnabled", "boolean", "to have audio enabled or not"}, {"mediaSystem", "string", "preferred multimedia system: 'JMF' for Java Media Framework or 'QT' for QuickTime"}, {"trace", "boolean", "show debug messages in console"}};

    public JClicAuthorApplet() {
        this.splashLabel.setVerticalTextPosition(3);
        this.splashLabel.setHorizontalTextPosition(0);
        this.splashLabel.setBackground(BG_COLOR);
        this.splashLabel.setOpaque(true);
        this.getContentPane().add((Component)this.splashLabel, "Center");
    }

    @Override
    public void init() {
        if (this.initiated) {
            return;
        }
        this.initiated = true;
        this.trace = "true".equals(this.getParameter("trace"));
        final StringBuilder sb = new StringBuilder();
        final JClicAuthorApplet rpc = this;
        SwingWorker sw = new SwingWorker(){

            @Override
            public Object construct() {
                Messages messages;
                for (int i = 2; i < pInfo.length; ++i) {
                    JClicAuthorApplet.this.options.put(pInfo[i][0], JClicAuthorApplet.this.getParameter(pInfo[i][0]));
                    if (!JClicAuthorApplet.this.trace) continue;
                    System.out.println(">>> param " + pInfo[i][0] + " is " + JClicAuthorApplet.this.getParameter(pInfo[i][0]));
                }
                try {
                    messages = PersistentSettings.getMessages(JClicAuthorApplet.this.options, "messages.JClicMessages");
                }
                catch (Exception ex) {
                    System.err.println("Unable to get default user messages language!\n" + ex);
                    messages = Messages.getMessages(JClicAuthorApplet.this.options, "messages.JClicMessages");
                }
                messages.addBundle("commonSettings");
                if (JClicAuthorApplet.this.splashLabel != null) {
                    JClicAuthorApplet.this.splashLabel.setText(messages.get("LOADING"));
                }
                if (!Check.checkSignature(JClicAuthorApplet.this.options, true)) {
                    return null;
                }
                CheckMediaSystem.check(JClicAuthorApplet.this.options, false);
                try {
                    JClicAuthorApplet.this.rc = new AuthorSingleFrame(JClicAuthorApplet.this.options);
                }
                catch (Exception ex) {
                    sb.append("ERROR: ").append(ex);
                }
                return JClicAuthorApplet.this.rc;
            }

            @Override
            public void finished() {
                if (this.getValue() == null) {
                    if (JClicAuthorApplet.this.isInstaller && JClicAuthorApplet.this.options.getString("exitUrl") != null) {
                        try {
                            String url = JClicAuthorApplet.this.options.getString("exitUrl");
                            if (url.indexOf(58) < 0) {
                                url = "file://" + url;
                            }
                            JClicAuthorApplet.this.getAppletContext().showDocument(new URL(url));
                        }
                        catch (Exception ex) {
                            sb.append("ERROR: ").append(ex);
                        }
                    }
                    if (JClicAuthorApplet.this.splashLabel != null) {
                        String s = sb.substring(0);
                        JClicAuthorApplet.this.splashLabel.setText(s);
                        System.err.println(s);
                    }
                } else {
                    JClicAuthorApplet.this.getContentPane().removeAll();
                    JClicAuthorApplet.this.splashLabel = null;
                    JClicAuthorApplet.this.rc.addTo(rpc, "Center");
                    JClicAuthorApplet.this.getRootPane().revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JClicAuthorApplet.this.rc.start(JClicAuthorApplet.this.activityPack, JClicAuthorApplet.this.sequence);
                        }
                    });
                }
            }
        };
        if (this.trace) {
            System.out.println(">>> initializing...");
        }
        sw.start();
    }

    @Override
    public void start() {
        if (this.trace) {
            System.out.println(">>> applet started");
        }
    }

    @Override
    public void stop() {
        if (this.rc != null) {
            this.rc.stop();
        }
        if (this.trace) {
            System.out.println(">>> applet stopped");
        }
    }

    @Override
    public void destroy() {
        if (this.rc != null) {
            if (this.trace) {
                System.out.println(">>> destroying applet...");
            }
            this.getContentPane().removeAll();
            this.rc.end();
            this.rc = null;
            this.initiated = false;
        }
        if (this.trace) {
            System.out.println(">>> applet destroyed");
        }
    }

    @Override
    public String getAppletInfo() {
        return "JClic Author applet";
    }

    @Override
    public String[][] getParameterInfo() {
        return pInfo;
    }
}

