/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.GradientButton;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ActivityEditorFramePanel
extends ActivityEditorInternalPanel {
    MediaBagEditor mediaBagEditor;
    private JRadioButton absoluteBtn;
    private ColorButton actBgColorBtn;
    private GradientButton actGradientButton;
    private ColorButton bgColorBtn;
    private JCheckBox borderChk;
    private JRadioButton centeredBtn;
    private GradientButton gradientButton;
    private ImgButton imgButton;
    private ButtonGroup locationGroup;
    private JLabel locationLb;
    private SmallIntEditor marginInt;
    private JPanel previewPanel;
    private JCheckBox tiledBgImgChk;
    private JCheckBox transpChk;
    private SmallIntEditor xInt;
    private SmallIntEditor yInt;

    public ActivityEditorFramePanel(ActivityEditorPanel parent) {
        super(parent);
        this.initComponents();
        this.setEnabled(false);
    }

    private void initComponents() {
        this.locationGroup = new ButtonGroup();
        JPanel previewPanel0 = new JPanel();
        this.previewPanel = new PreviewPanel();
        JPanel mainWindowPanel = new JPanel();
        JLabel bgColorLb = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel gradientLb = new JLabel();
        this.gradientButton = new GradientButton();
        this.gradientButton.setOptions(this.options);
        JLabel imgLb = new JLabel();
        this.imgButton = new ImgButton();
        this.imgButton.setOptions(this.options);
        this.tiledBgImgChk = new JCheckBox();
        JPanel gameWindowPanel = new JPanel();
        JLabel actBgColorLb = new JLabel();
        this.actBgColorBtn = new ColorButton();
        this.actBgColorBtn.setOptions(this.options);
        JLabel actGradientLb = new JLabel();
        this.actGradientButton = new GradientButton();
        this.actGradientButton.setOptions(this.options);
        this.transpChk = new JCheckBox();
        this.borderChk = new JCheckBox();
        JLabel marginLb = new JLabel();
        this.marginInt = new SmallIntEditor();
        JLabel spacer1 = new JLabel();
        this.locationLb = new JLabel();
        this.centeredBtn = new JRadioButton();
        this.absoluteBtn = new JRadioButton();
        JLabel xLb = new JLabel();
        this.xInt = new SmallIntEditor();
        JLabel yLb = new JLabel();
        this.yInt = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        previewPanel0.setLayout(new BorderLayout());
        previewPanel0.setBorder(new TitledBorder(this.options.getMsg("edit_act_preview")));
        this.previewPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        previewPanel0.add((Component)this.previewPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)previewPanel0, gridBagConstraints);
        mainWindowPanel.setLayout(new GridBagLayout());
        mainWindowPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_mainWindow")));
        bgColorLb.setLabelFor(this.bgColorBtn);
        bgColorLb.setText(this.options.getMsg("edit_act_bgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        mainWindowPanel.add((Component)bgColorLb, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        mainWindowPanel.add((Component)this.bgColorBtn, gridBagConstraints);
        gradientLb.setLabelFor(this.gradientButton);
        gradientLb.setText(this.options.getMsg("edit_act_gradient"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        mainWindowPanel.add((Component)gradientLb, gridBagConstraints);
        this.gradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.gradientButton.addPropertyChangeListener("gradient", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        mainWindowPanel.add((Component)this.gradientButton, gridBagConstraints);
        imgLb.setLabelFor(this.imgButton);
        imgLb.setText(this.options.getMsg("edit_act_image"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        mainWindowPanel.add((Component)imgLb, gridBagConstraints);
        this.imgButton.setToolTipText(this.options.getMsg("edit_act_image_tooltip"));
        this.imgButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        mainWindowPanel.add((Component)this.imgButton, gridBagConstraints);
        this.tiledBgImgChk.setToolTipText(this.options.getMsg("edit_act_tiledBgImg_tooltip"));
        this.tiledBgImgChk.setText(this.options.getMsg("edit_act_tiledBgImg"));
        this.tiledBgImgChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mainWindowPanel.add((Component)this.tiledBgImgChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)mainWindowPanel, gridBagConstraints);
        gameWindowPanel.setLayout(new GridBagLayout());
        gameWindowPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_gameWindow")));
        actBgColorLb.setLabelFor(this.actBgColorBtn);
        actBgColorLb.setText(this.options.getMsg("edit_act_bgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)actBgColorLb, gridBagConstraints);
        this.actBgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.actBgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.actBgColorBtn, gridBagConstraints);
        actGradientLb.setLabelFor(this.actGradientButton);
        actGradientLb.setText(this.options.getMsg("edit_act_gradient"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)actGradientLb, gridBagConstraints);
        this.actGradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.actGradientButton.addPropertyChangeListener("gradient", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.actGradientButton, gridBagConstraints);
        this.transpChk.setToolTipText(this.options.getMsg("edit_act_transparent_tooltip"));
        this.transpChk.setText(this.options.getMsg("edit_act_transparent"));
        this.transpChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gameWindowPanel.add((Component)this.transpChk, gridBagConstraints);
        this.borderChk.setToolTipText(this.options.getMsg("edit_act_border_tooltip"));
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.borderChk, gridBagConstraints);
        marginLb.setLabelFor(this.marginInt);
        marginLb.setText(this.options.getMsg("edit_act_margin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)marginLb, gridBagConstraints);
        this.marginInt.setToolTipText(this.options.getMsg("edit_act_margin_tooltip"));
        this.marginInt.setMax(999);
        this.marginInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.marginInt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gameWindowPanel.add((Component)spacer1, gridBagConstraints);
        this.locationLb.setText(this.options.getMsg("edit_act_location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)this.locationLb, gridBagConstraints);
        this.centeredBtn.setToolTipText(this.options.getMsg("edit_act_centered_tooltip"));
        this.centeredBtn.setSelected(true);
        this.centeredBtn.setText(this.options.getMsg("edit_act_centered"));
        this.locationGroup.add(this.centeredBtn);
        this.centeredBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.centeredBtn, gridBagConstraints);
        this.absoluteBtn.setToolTipText(this.options.getMsg("edit_act_absolute_tooltip"));
        this.absoluteBtn.setText(this.options.getMsg("edit_act_absolute"));
        this.locationGroup.add(this.absoluteBtn);
        this.absoluteBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.absoluteBtn, gridBagConstraints);
        xLb.setLabelFor(this.xInt);
        xLb.setText(this.options.getMsg("edit_act_x"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)xLb, gridBagConstraints);
        this.xInt.setToolTipText(this.options.getMsg("edit_act_x_tooltip"));
        this.xInt.setMax(999);
        this.xInt.setMin(-999);
        this.xInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.xInt, gridBagConstraints);
        yLb.setLabelFor(this.yInt);
        yLb.setText(this.options.getMsg("edit_act_y"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gameWindowPanel.add((Component)yLb, gridBagConstraints);
        this.yInt.setToolTipText(this.options.getMsg("edit_act_y_tooltip"));
        this.yInt.setMax(999);
        this.yInt.setMin(-999);
        this.yInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gameWindowPanel.add((Component)this.yInt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)gameWindowPanel, gridBagConstraints);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.marginInt.setEnabled(enabled);
        this.bgColorBtn.setEnabled(enabled);
        this.gradientButton.setEnabled(enabled);
        this.imgButton.setEnabled(enabled);
        this.tiledBgImgChk.setEnabled(enabled && this.imgButton.getObject() != null);
        this.borderChk.setEnabled(enabled);
        this.transpChk.setEnabled(enabled);
        this.actBgColorBtn.setEnabled(enabled);
        this.actGradientButton.setEnabled(enabled);
        this.absoluteBtn.setEnabled(enabled);
        this.centeredBtn.setEnabled(enabled);
        this.xInt.setEnabled(enabled && this.absoluteBtn.isSelected());
        this.yInt.setEnabled(enabled && this.absoluteBtn.isSelected());
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        Object cmp;
        Object object = cmp = ev == null ? null : ev.getSource();
        if (cmp == null || cmp == this.imgButton) {
            this.tiledBgImgChk.setEnabled(this.imgButton.getObject() != null);
        }
        if (cmp == null || cmp == this.centeredBtn || cmp == this.absoluteBtn) {
            this.xInt.setEnabled(this.absoluteBtn.isSelected());
            this.yInt.setEnabled(this.absoluteBtn.isSelected());
        }
        ((PreviewPanel)this.previewPanel).reset();
        return ev != null;
    }

    @Override
    public void fillData() {
        Activity act = this.getActivity();
        this.marginInt.setValue(act == null ? 8 : act.margin);
        this.mediaBagEditor = act == null ? null : this.getActivityEditor().getMediaBagEditor();
        this.bgColorBtn.setColor(act == null ? Activity.DEFAULT_BG_COLOR : act.bgColor);
        this.gradientButton.setGradient(act == null ? null : act.bgGradient);
        this.imgButton.setMediaBagEditor(this.mediaBagEditor);
        this.imgButton.setImgName(act == null ? null : act.bgImageFile);
        this.tiledBgImgChk.setSelected(act == null ? true : act.tiledBgImg || act.bgImageFile == null);
        ((PreviewPanel)this.previewPanel).reset();
        this.borderChk.setSelected(act == null ? true : act.border);
        this.transpChk.setSelected(act == null ? false : act.transparentBg);
        this.actBgColorBtn.setColor(act == null ? Activity.DEFAULT_BG_COLOR : act.activityBgColor);
        this.actGradientButton.setGradient(act == null ? null : act.activityBgGradient);
        this.absoluteBtn.setSelected(act == null ? false : act.absolutePositioned);
        this.centeredBtn.setSelected(act == null ? true : !act.absolutePositioned);
        if (act != null && act.absolutePosition != null) {
            this.xInt.setValue(act.absolutePosition.x);
            this.yInt.setValue(act.absolutePosition.y);
        } else {
            this.xInt.setValue(0);
            this.yInt.setValue(0);
        }
        this.eventPerformed(null);
    }

    @Override
    public void saveData() {
        Activity act = this.getActivity();
        if (act != null) {
            act.margin = this.marginInt.getValue();
            act.bgColor = this.bgColorBtn.getColor();
            act.bgGradient = this.gradientButton.getGradient();
            act.bgImageFile = this.imgButton.getImgName();
            act.tiledBgImg = this.tiledBgImgChk.isSelected() && act.bgImageFile != null;
            act.border = this.borderChk.isSelected();
            act.transparentBg = this.transpChk.isSelected();
            act.activityBgColor = this.actBgColorBtn.getColor();
            act.activityBgGradient = this.actGradientButton.getGradient();
            act.absolutePositioned = this.absoluteBtn.isSelected();
            act.absolutePosition = act.absolutePositioned ? new Point(this.xInt.getValue(), this.yInt.getValue()) : null;
        }
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.getImageIcon("icons/frame.gif");
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_act_panels_frame");
    }

    @Override
    protected String getTooltip() {
        return this.options.getMsg("edit_act_panels_frame_tooltip");
    }

    class PreviewPanel
    extends JPanel {
        InnerPreviewPane innerPane;
        Image bgImage;
        boolean tiledBgImg;
        Gradient bgGradient;
        Gradient actBgGradient;
        Point bgImageOrigin = new Point();
        double scale = 1.0;

        PreviewPanel() {
            this.setLayout(null);
            this.innerPane = new InnerPreviewPane();
            this.add(this.innerPane);
        }

        public void reset() {
            this.bgImage = null;
            this.bgGradient = null;
            this.actBgGradient = null;
            this.bgImage = null;
            this.tiledBgImg = true;
            if (ActivityEditorFramePanel.this.mediaBagEditor != null) {
                String bgImageFile = ActivityEditorFramePanel.this.imgButton.getImgName();
                if (bgImageFile != null) {
                    try {
                        this.bgImage = ActivityEditorFramePanel.this.mediaBagEditor.getMediaBag().getImageElement(bgImageFile).getImage();
                    }
                    catch (Exception ex) {
                        ActivityEditorFramePanel.this.options.getMessages().showErrorWarning(this, "ERROR", ex);
                    }
                }
                this.tiledBgImg = ActivityEditorFramePanel.this.tiledBgImgChk.isSelected();
            }
            this.innerPane.setBorder(ActivityEditorFramePanel.this.borderChk.isSelected() ? BorderFactory.createBevelBorder(0) : BorderFactory.createEmptyBorder());
            this.innerPane.setOpaque(!ActivityEditorFramePanel.this.transpChk.isSelected());
            this.innerPane.setBackground(ActivityEditorFramePanel.this.actBgColorBtn.getColor());
            this.actBgGradient = ActivityEditorFramePanel.this.actGradientButton.getGradient();
            this.bgGradient = ActivityEditorFramePanel.this.gradientButton.getGradient();
            this.setBackground(ActivityEditorFramePanel.this.bgColorBtn.getColor());
            this.revalidate();
            this.repaint();
        }

        @Override
        public void doLayout() {
            this.scale = 1.0;
            this.bgImageOrigin.x = 0;
            this.bgImageOrigin.y = 0;
            Rectangle bounds = this.getBounds();
            int margin = ActivityEditorFramePanel.this.marginInt.getValue();
            Rectangle proposedRect = new Rectangle(margin, margin, bounds.width - 2 * margin, bounds.height - 2 * margin);
            if (this.bgImage != null && !this.tiledBgImg) {
                int w = this.bgImage.getWidth(this);
                int h = this.bgImage.getHeight(this);
                if (w > 0 && h > 0 && (w > this.getWidth() || h > this.getHeight())) {
                    this.scale = Math.min((double)this.getWidth() / (double)w, (double)this.getHeight() / (double)h);
                    w = (int)(this.scale * (double)w);
                    h = (int)(this.scale * (double)h);
                } else {
                    this.scale = 1.0;
                }
                this.bgImageOrigin.x = (this.getWidth() - w) / 2;
                this.bgImageOrigin.y = (this.getHeight() - h) / 2;
                if (ActivityEditorFramePanel.this.absoluteBtn.isSelected()) {
                    proposedRect.x = this.bgImageOrigin.x;
                    proposedRect.y = this.bgImageOrigin.y;
                    proposedRect.width -= this.bgImageOrigin.x - margin;
                    proposedRect.height -= this.bgImageOrigin.y - margin;
                    proposedRect.width = Math.min(proposedRect.width, bounds.width);
                    proposedRect.height = Math.min(proposedRect.height, bounds.height);
                }
            }
            this.innerPane.fitTo(proposedRect, bounds);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle rBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            if (this.bgGradient == null || this.bgGradient.hasTransparency()) {
                super.paintComponent(g);
            }
            if (this.bgGradient != null || this.bgImage != null) {
                RenderingHints rh = g2.getRenderingHints();
                g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                if (this.bgGradient != null) {
                    this.bgGradient.paint(g2, rBounds);
                }
                if (this.bgImage != null) {
                    Rectangle r = new Rectangle(0, 0, this.bgImage.getWidth(this), this.bgImage.getHeight(this));
                    Rectangle gBounds = g2.getClipBounds();
                    if (!this.tiledBgImg) {
                        r.setLocation(this.bgImageOrigin);
                        if (r.intersects(gBounds)) {
                            if (this.scale == 1.0) {
                                g2.drawImage(this.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this);
                            } else {
                                int w0 = this.bgImage.getWidth(this);
                                int h0 = this.bgImage.getHeight(this);
                                int w = (int)(this.scale * (double)w0);
                                int h = (int)(this.scale * (double)h0);
                                g2.drawImage(this.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this.bgImageOrigin.x + w, this.bgImageOrigin.y + h, 0, 0, w0, h0, this);
                            }
                        }
                    } else {
                        Utils.tileImage(g2, this.bgImage, rBounds, r, this);
                    }
                }
                g2.setRenderingHints(rh);
            }
        }

        class InnerPreviewPane
        extends JPanel {
            InnerPreviewPane() {
                this.setLayout(null);
            }

            public void fitTo(Rectangle proposedRect, Rectangle maxRect) {
                Activity act = ActivityEditorFramePanel.this.getActivity();
                Dimension d = new Dimension(act == null ? 400 : act.getWindowSize().width, act == null ? 300 : act.getWindowSize().height);
                int w = Math.max(40, Math.min(proposedRect.width, (int)(PreviewPanel.this.scale * (double)d.width)));
                int h = Math.max(40, Math.min(proposedRect.height, (int)(PreviewPanel.this.scale * (double)d.height)));
                boolean b = ActivityEditorFramePanel.this.centeredBtn.isSelected();
                int xp = (b ? 0 : PreviewPanel.this.bgImageOrigin.x) + Math.max(0, b ? proposedRect.x + (proposedRect.width - w) / 2 : (int)(PreviewPanel.this.scale * (double)ActivityEditorFramePanel.this.xInt.getValue()));
                int yp = (b ? 0 : PreviewPanel.this.bgImageOrigin.y) + Math.max(0, b ? proposedRect.y + (proposedRect.height - h) / 2 : (int)(PreviewPanel.this.scale * (double)ActivityEditorFramePanel.this.yInt.getValue()));
                if (xp > maxRect.width - 40) {
                    xp = maxRect.width - 40;
                }
                if (xp + w > maxRect.width) {
                    w = maxRect.width - xp;
                }
                if (yp > maxRect.height - 40) {
                    yp = maxRect.height - 40;
                }
                if (yp + h > maxRect.height) {
                    h = maxRect.height - yp;
                }
                this.setBounds(xp, yp, w, h);
            }

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                Rectangle rBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                if (!this.isOpaque() || PreviewPanel.this.actBgGradient == null || PreviewPanel.this.actBgGradient.hasTransparency()) {
                    super.paintComponent(g);
                }
                RenderingHints rh = g2.getRenderingHints();
                if (this.isOpaque() && PreviewPanel.this.actBgGradient != null) {
                    g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                    PreviewPanel.this.actBgGradient.paint(g2, rBounds);
                }
                if (ActivityEditorFramePanel.this.getActivityEditor() != null) {
                    ActivityEditorFramePanel.this.getActivityEditor().drawPreview(g2, rBounds, ActivityEditorFramePanel.this.marginInt.getValue());
                }
                g2.setRenderingHints(rh);
            }
        }
    }
}

