/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ComplexEvaluatorPanel
extends JPanel {
    Options options;
    private SmallIntEditor detailField;
    private JCheckBox detailChk;
    private SmallIntEditor detailSteps;

    public ComplexEvaluatorPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    public void setEvaluator(ComplexEvaluator ev) {
        this.detailChk.setSelected(ev.detail);
        this.detailSteps.setValue(ev.checkSteps);
        this.detailField.setValue(ev.checkScope);
        this.checkEnabled();
    }

    public void collectData(ComplexEvaluator ev) {
        ev.detail = this.detailChk.isSelected();
        ev.checkSteps = this.detailSteps.getValue();
        ev.checkScope = this.detailField.getValue();
    }

    protected void checkEnabled() {
        this.detailSteps.setEnabled(this.detailChk.isSelected());
        this.detailField.setEnabled(this.detailChk.isSelected());
    }

    private void initComponents() {
        this.detailChk = new JCheckBox();
        JLabel detailLb = new JLabel();
        JLabel detailStepsLb = new JLabel();
        this.detailSteps = new SmallIntEditor();
        JLabel detailFieldLb = new JLabel();
        this.detailField = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_advancedCorrectionOptions")));
        this.detailChk.setText(this.options.getMsg("edit_text_act_checkDetail"));
        this.detailChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComplexEvaluatorPanel.this.detailChkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.detailChk, gridBagConstraints);
        detailLb.setText(this.options.getMsg("edit_text_act_checkDetail_params"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)detailLb, gridBagConstraints);
        detailStepsLb.setText(this.options.getMsg("edit_text_act_checkDetail_steps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)detailStepsLb, gridBagConstraints);
        this.detailSteps.setMax(99);
        this.detailSteps.setMin(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.detailSteps, gridBagConstraints);
        detailFieldLb.setText(this.options.getMsg("edit_text_act_checkDetail_field"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)detailFieldLb, gridBagConstraints);
        this.detailField.setMax(99);
        this.detailField.setMin(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.detailField, gridBagConstraints);
    }

    private void detailChkActionPerformed(ActionEvent evt) {
        this.checkEnabled();
    }
}

