/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Order;
import edu.xtec.jclic.activities.text.OrderCheckPanel;
import edu.xtec.jclic.activities.text.OrderTypePanel;
import edu.xtec.jclic.activities.text.TextActivityBaseEditor;
import edu.xtec.util.Options;
import java.awt.Component;
import java.util.HashMap;

public class OrderEditor
extends TextActivityBaseEditor {
    protected static HashMap<Options, OrderCheckPanel> panelMap = new HashMap(1);

    public OrderEditor(Order act) {
        super(act);
    }

    @Override
    protected void editCheckOptions(Options options, Component parent) {
        Order ord = (Order)this.getTextActivity();
        if (ord != null) {
            OrderCheckPanel checkPanel = panelMap.get(options);
            if (checkPanel == null) {
                checkPanel = new OrderCheckPanel(options);
                panelMap.put(options, checkPanel);
            }
            checkPanel.setOptions(ord);
            if (options.getMessages().showInputDlg(parent, checkPanel, "edit_text_act_check_title")) {
                checkPanel.collectData(ord);
                this.setModified(true);
            }
        }
    }

    @Override
    protected boolean hasType() {
        return true;
    }

    @Override
    protected boolean editType(Options options, Component parent) {
        Order ord = (Order)this.getActivity();
        int t = ord.type;
        boolean b = ord.amongParagraphs;
        boolean result = OrderTypePanel.editOrder(ord, options, parent);
        if (result && ord.type != t && ord.tad.tmb.size() > 0) {
            if (options.getMessages().showQuestionDlg(parent, "edit_text_act_warnChangeType", null, "yn") == 1) {
                ord.tad.clearAllTargets();
            } else {
                result = false;
                ord.type = t;
                ord.amongParagraphs = b;
            }
        }
        if (result) {
            ord.tad.targetType = ord.type == 1 ? 3 : 2;
            this.setModified(true);
        }
        return result;
    }
}

