/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTargetEditorPanel;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

public class TextActivityBaseEditor
extends ActivityEditor {
    protected int from;
    protected int to;

    public TextActivityBaseEditor(TextActivityBase act) {
        super(act);
    }

    @Override
    protected void createPanels(ActivityEditorPanel panel) {
        panel.addInternalPanel("TEXT_BASE", null, null);
    }

    protected TextActivityBase getTextActivity() {
        return (TextActivityBase)this.getActivity();
    }

    protected JPanelActiveBox createNewBox(int pos, Options options, Component parent) {
        JPanelActiveBox result = null;
        TextActivityBase tab = this.getTextActivity();
        AttributeSet a = tab.tad.getCharacterElement(pos).getAttributes();
        if (a.isDefined("target")) {
            options.getMessages().showAlert(parent, "edit_text_act_err_cellInTarget");
            return null;
        }
        ActiveBoxContent ab = new ActiveBoxContent();
        ab.setDimension(new Dimension(100, 40));
        ab.setBoxBase(tab.tad.boxesContent.bb);
        ab = ActiveBoxContentEditor.getActiveBoxContent(ab, parent, options, this.getMediaBagEditor(), null);
        if (ab != null) {
            try {
                result = TextActivityDocument.insertBox(ab, pos, tab.tad, tab, null);
            }
            catch (Exception ex) {
                options.getMessages().showErrorWarning(parent, "ERROR", ex);
            }
        }
        return result;
    }

    protected TargetMarker createNewTarget(int ifrom, int ito, Options options, Component parent) {
        TargetMarker tm = null;
        TextActivityBase tab = this.getTextActivity();
        if (tab != null) {
            this.from = ifrom;
            this.to = ito;
            if (!this.checkTargetSegment(options, parent)) {
                return null;
            }
            tm = new TargetMarker(tab.tad);
            tm.begOffset = this.from;
            tm.endOffset = this.to;
            tm.setPositions();
            tab.tad.tmb.add(tm);
            tab.tad.applyStyleToTarget(tm, "target", false, true);
        }
        return tm;
    }

    private boolean checkTargetSegment(Options options, Component parent) {
        String text;
        String errMsg = null;
        if (this.getTextActivity() == null) {
            return false;
        }
        TextActivityDocument tad = this.getTextActivity().tad;
        try {
            text = tad.getText(0, tad.getLength());
        }
        catch (Exception ex) {
            return false;
        }
        int len = text.length();
        this.from = Math.min(Math.max(0, this.from), Math.max(0, len - 1));
        this.to = Math.min(Math.max(this.from, this.to), len);
        switch (tad.getTargetType()) {
            case 0: {
                int fromBk = this.from;
                int toBk = this.to;
                while (this.from < len && Character.isWhitespace(text.charAt(this.from))) {
                    ++this.from;
                }
                while (this.to >= this.from && this.to > 0 && Character.isWhitespace(text.charAt(this.to - 1))) {
                    --this.to;
                }
                if (this.from < this.to) break;
                this.from = fromBk;
                this.to = toBk;
                break;
            }
            case 1: {
                while (this.from < len && Character.isWhitespace(text.charAt(this.from))) {
                    ++this.from;
                }
                this.to = Math.min(this.from + 1, len);
                break;
            }
            case 2: {
                while (this.from >= 0 && !Character.isWhitespace(text.charAt(this.from))) {
                    --this.from;
                }
                ++this.from;
                this.to = this.from;
                while (this.to < len && !Character.isWhitespace(text.charAt(this.to))) {
                    ++this.to;
                }
                break;
            }
            case 3: {
                Element element = tad.getParagraphElement(this.from);
                if (element == null) {
                    this.to = this.from;
                    break;
                }
                this.from = Math.max(0, element.getStartOffset());
                this.to = Math.max(0, Math.min(text.length() - 1, element.getEndOffset() - 1));
                while (this.to > this.from && (text.charAt(this.to) == '\r' || text.charAt(this.to) == '\n')) {
                    --this.to;
                }
                ++this.to;
                break;
            }
        }
        if (this.to == this.from) {
            errMsg = "edit_text_act_err_noSelection";
        } else if (this.from > this.to) {
            errMsg = "ERROR";
        } else {
            try {
                for (int i = this.from; i < this.to; ++i) {
                    char ch = tad.getText(i, 1).charAt(0);
                    if (ch == '\r' || ch == '\n' || ch == '\b') {
                        errMsg = "edit_text_act_err_badCharInSelection";
                    } else {
                        AttributeSet a = tad.getCharacterElement(i).getAttributes();
                        if (a.isDefined("target")) {
                            errMsg = "edit_text_act_err_nestedTargets";
                        } else {
                            if (a.getAttribute(StyleConstants.ComponentAttribute) == null) continue;
                            errMsg = "edit_text_act_err_cellInTarget";
                        }
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (errMsg != null && options != null) {
            options.getMessages().showAlert(parent, errMsg);
        }
        return errMsg == null;
    }

    protected boolean deleteTarget(TargetMarker tm, Options options, Component parent) {
        TextActivityBase tab = this.getTextActivity();
        if (tab != null) {
            tab.tad.tmb.remove(tm);
            tab.tad.applyStyleToTarget(tm, null, false, true);
        }
        return true;
    }

    protected boolean canEditTarget() {
        return false;
    }

    protected boolean editTarget(int pos, Options options, Component parent) {
        boolean result = false;
        TextActivityBase tab = this.getTextActivity();
        if (this.canEditTarget() && pos >= 0 && pos < tab.tad.getLength()) {
            TargetMarker tm = tab.tad.tmb.getElementByOffset(pos, true);
            if (tm != null && tm.target != null) {
                result = TextTargetEditorPanel.editTextTarget(tm.target, options, this.getMediaBagEditor(), parent);
            }
            if (result) {
                this.setModified(true);
            }
        }
        return result;
    }

    protected void editCheckOptions(Options options, Component parent) {
    }

    protected boolean hasType() {
        return false;
    }

    protected boolean editType(Options options, Component parent) {
        return false;
    }

    @Override
    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = super.nameChanged(type, oldName, newName);
        result |= ActiveBagContentEditor.nameChanged(this.getTextActivity().tad.boxesContent, type, oldName, newName);
        if (result |= ActiveBagContentEditor.nameChanged(this.getTextActivity().tad.popupsContent, type, oldName, newName)) {
            this.setModified(true);
        }
        return result;
    }
}

