/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.TestPlayerContainer;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceElementEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ActivitySequenceElementEditor
extends Editor {
    protected static ImageIcon icon;
    public static boolean actionsCreated;
    protected ActivitySequence activitySequence;

    public ActivitySequenceElementEditor(ActivitySequenceElement el) {
        super(el);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public Class getEditorPanelClass() {
        return ActivitySequenceElementEditorPanel.class;
    }

    @Override
    public EditorPanel createEditorPanel(Options options) {
        return new ActivitySequenceElementEditorPanel(options);
    }

    public ActivitySequenceElement getActivitySequenceElement() {
        return (ActivitySequenceElement)this.getFirstObject(ActivitySequenceElement.class);
    }

    public String getTag() {
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        return StrUtils.nullableString(ase.getTag());
    }

    protected void saveData() {
    }

    @Override
    protected boolean canClone() {
        return true;
    }

    @Override
    protected Editor getClone() throws Exception {
        ActivitySequenceElement asel = (ActivitySequenceElement)this.getActivitySequenceElement().clone();
        return asel.getEditor(null);
    }

    protected void setActionsFlag() {
        this.allowDelete = true;
        this.allowCut = true;
        this.allowCopy = true;
        this.allowPaste = true;
    }

    @Override
    public void setActionsOwner() {
        this.setActionsFlag();
        super.setActionsOwner();
        if (actionsCreated) {
            ActivityBagElementEditor.testActivityAction.setActionOwner(this);
            ActivitySequenceEditor.newActivitySequenceElementAction.setActionOwner(this);
        }
    }

    @Override
    public void clearActionsOwner() {
        super.clearActionsOwner();
        ActivityBagElementEditor.testActivityAction.setActionOwner(null);
        ActivitySequenceEditor.newActivitySequenceElementAction.setActionOwner(this.getEditorParent());
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    @Override
    public Icon getIcon(boolean leaf, boolean expanded) {
        return ActivitySequenceElementEditor.getIcon();
    }

    @Override
    public boolean canBeParentOf(Editor e) {
        return e instanceof ActivitySequenceEditor;
    }

    @Override
    public boolean canBeSiblingOf(Editor e) {
        return e instanceof ActivitySequenceElementEditor;
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public void testActivity() {
        TestPlayerContainer tpc;
        this.collectData();
        JClicProjectEditor pe = this.getProjectEditor();
        int item = this.getParent().getIndex(this);
        if (pe != null && item >= 0 && (tpc = pe.getTestPlayerContainer()) != null && tpc.getTestPlayer() != null) {
            tpc.getTestPlayer().load(null, Integer.toString(item), null, null);
            tpc.test();
        }
    }

    public static void createActions(Options options) {
        ActivityBagElementEditor.createActions(options);
        actionsCreated = true;
    }

    public static Icon getElementIcon(ActivitySequenceElement ase, boolean fwd) {
        ActivitySequenceJump asj;
        String iconName = fwd ? "seq_next" : "seq_prev";
        ActivitySequenceJump activitySequenceJump = asj = fwd ? ase.fwdJump : ase.backJump;
        if (asj != null) {
            if (asj.action == 1) {
                iconName = iconName + "_stop";
            } else if (asj.action == 0) {
                iconName = iconName + "_jump";
            } else if (asj.action == 2) {
                iconName = iconName + "_return";
            } else if (asj.action == 3) {
                iconName = "seq_exit";
            }
        }
        return ResourceManager.getImageIcon("icons/" + iconName + ".gif");
    }

    public static String getElementJumpDescription(ActivitySequenceElement ase, boolean fwd) {
        ActivitySequenceJump asj;
        String result = null;
        ActivitySequenceJump activitySequenceJump = asj = fwd ? ase.fwdJump : ase.backJump;
        if (asj != null) {
            result = StrUtils.secureString(asj.sequence);
            if (asj.projectPath != null) {
                result = result + " (" + asj.projectPath + ")";
            }
        }
        return result;
    }

    public static String getElementJumpDescription(ActivitySequenceElement ase) {
        String result = null;
        if (ase.fwdJump != null || ase.backJump != null) {
            result = ActivitySequenceElementEditor.getElementJumpDescription(ase, true);
            String r2 = ActivitySequenceElementEditor.getElementJumpDescription(ase, false);
            if (r2 != null && r2.length() > 0) {
                StringBuilder sb = new StringBuilder(100);
                if (result != null && result.length() > 0) {
                    sb.append(result).append(" ");
                }
                sb.append("* ").append(r2);
                result = sb.substring(0);
            }
        }
        return result;
    }

    public boolean nameChanged(int type, String oldName, String newName) {
        boolean result = false;
        ActivitySequenceElement ase = this.getActivitySequenceElement();
        if ((type & 1) != 0 && oldName.equals(ase.getActivityName())) {
            ase.setActivityName(newName);
            this.setModified(true);
            result = true;
        }
        if ((type & 2) != 0) {
            if (oldName.equals(ase.getTag())) {
                ase.setTag(newName);
                result = true;
            }
            if (ase.fwdJump != null) {
                result |= this.jumpInfoNameChanged(ase.fwdJump, oldName, newName) | this.jumpInfoNameChanged(ase.fwdJump.upperJump, oldName, newName) | this.jumpInfoNameChanged(ase.fwdJump.lowerJump, oldName, newName);
            }
            if (ase.backJump != null) {
                result |= this.jumpInfoNameChanged(ase.backJump, oldName, newName) | this.jumpInfoNameChanged(ase.backJump.upperJump, oldName, newName) | this.jumpInfoNameChanged(ase.backJump.lowerJump, oldName, newName);
            }
            if (result) {
                this.setModified(true);
            }
        }
        return result;
    }

    private boolean jumpInfoNameChanged(JumpInfo ji, String oldName, String newName) {
        boolean result = false;
        if (ji != null && ji.action == 0 && ji.projectPath == null && oldName.equals(ji.sequence)) {
            ji.sequence = newName;
            result = true;
        }
        return result;
    }

    static {
        actionsCreated = false;
    }
}

