/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceEditorPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ActivitySequenceTable
extends JTable {
    public static final Color DIVIDER_COLOR = Color.red;
    public static final int DIVIDER_WIDTH = 1;
    private BasicStroke stroke = new BasicStroke(1.0f);

    public ActivitySequenceTable(TableModel model) {
        super(model);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(this.getModel() instanceof ActivitySequenceEditorPanel.SeqTableModel)) {
            return;
        }
        ActivitySequenceEditorPanel.SeqTableModel model = (ActivitySequenceEditorPanel.SeqTableModel)this.getModel();
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point minLocation = clip.getLocation();
        Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.rowAtPoint(minLocation);
        int rMax = this.rowAtPoint(maxLocation);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.getRowCount() - 1;
        }
        int cMin = this.columnAtPoint(minLocation);
        int cMax = this.columnAtPoint(maxLocation);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.getColumnCount() - 1;
        }
        g.setColor(DIVIDER_COLOR);
        ((Graphics2D)g).setStroke(this.stroke);
        Rectangle minCell = this.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.getCellRect(rMax, cMax, true);
        int tableWidth = maxCell.x + maxCell.width;
        int y = minCell.y;
        for (int row = rMin; row <= rMax; ++row) {
            int rh = this.getRowHeight(row);
            y += rh;
            if (!model.drawDivider(row)) continue;
            g.drawLine(0, y - 1, tableWidth - 1, y - 1);
        }
    }
}

