/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.misc.GradientEditor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public class GradientButton
extends NullableObject {
    public static final String PROP_GRADIENT = "gradient";

    @Override
    protected String getObjectType() {
        return PROP_GRADIENT;
    }

    public Gradient getGradient() {
        return (Gradient)this.getObject();
    }

    public void setGradient(Gradient g) {
        this.setObject(g);
    }

    @Override
    protected AbstractButton buildButton() {
        return new JButton(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Gradient gradient = GradientButton.this.getGradient();
                if (gradient != null) {
                    Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    r.grow(-3, -3);
                    Graphics2D g2 = (Graphics2D)g;
                    RenderingHints rh = g2.getRenderingHints();
                    g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                    gradient.paint(g2, r);
                    g2.setRenderingHints(rh);
                }
            }
        };
    }

    @Override
    protected Object createObject() {
        return new Gradient();
    }

    @Override
    protected Object editObject(Object o) {
        Gradient g = (Gradient)(o == null ? this.createObject() : o);
        return GradientEditor.getGradient(g, this, this.options);
    }
}

