/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextListEditor
extends JPanel
implements ListSelectionListener {
    public static final String PROP_LIST = "list";
    Options options;
    DefaultListModel listModel;
    boolean modified;
    int maxItems = 999;
    int minItems = 0;
    boolean upperCase;
    private JButton addBtn;
    private JPanel btnPanel;
    private JButton downBtn;
    private JButton editBtn;
    private JList list;
    private JButton removeBtn;
    private JButton upBtn;

    public TextListEditor() {
        this((Options)null);
    }

    public TextListEditor(Options options) {
        this.options = options;
        this.listModel = new DefaultListModel();
        this.initComponents();
        this.list.addListSelectionListener(this);
    }

    private void initComponents() {
        JScrollPane listScroll = new JScrollPane();
        this.list = new JList();
        this.btnPanel = new JPanel();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.editBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.setLayout(new GridBagLayout());
        listScroll.setPreferredSize(new Dimension(100, 60));
        this.list.setModel(this.listModel);
        this.list.setSelectionMode(0);
        listScroll.setViewportView(this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)listScroll, gridBagConstraints);
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.addBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus16.gif")));
        this.addBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_newElement_tooltip"));
        this.addBtn.setMargin(new Insets(0, 0, 0, 0));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextListEditor.this.addBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.addBtn);
        this.removeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus16.gif")));
        this.removeBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_deleteElement_tooltip"));
        this.removeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextListEditor.this.removeBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.removeBtn);
        this.editBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.editBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_editElement_tooltip"));
        this.editBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editBtn.setEnabled(false);
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextListEditor.this.editBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.editBtn);
        this.upBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/up.gif")));
        this.upBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_upBtn_tooltip"));
        this.upBtn.setMargin(new Insets(0, 0, 0, 0));
        this.upBtn.setEnabled(false);
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextListEditor.this.upBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.upBtn);
        this.downBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/down.gif")));
        this.downBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_downBtn_tooltip"));
        this.downBtn.setMargin(new Insets(0, 0, 0, 0));
        this.downBtn.setEnabled(false);
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextListEditor.this.downBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.downBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.btnPanel, gridBagConstraints);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        Object s;
        int v = this.list.getSelectedIndex();
        if (this.options != null && (s = this.editItem(null, true)) != null && s.toString().length() > 0) {
            if (this.upperCase) {
                s = s.toString().toUpperCase();
            }
            this.listModel.add(v + 1, s);
            this.list.setSelectedIndex(v + 1);
            this.firePropertyChange(PROP_LIST, "", s);
            this.modified = true;
        }
    }

    private void editBtnActionPerformed(ActionEvent evt) {
        Object s;
        Object r;
        int v = this.list.getSelectedIndex();
        if (v >= 0 && this.options != null && (r = this.editItem(s = this.listModel.getElementAt(v), false)) != null && r.toString().length() > 0 && !r.equals(s)) {
            if (this.upperCase) {
                r = r.toString().toUpperCase();
            }
            this.listModel.setElementAt(r, v);
            this.firePropertyChange(PROP_LIST, s, r);
            this.modified = true;
        }
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        int i = this.list.getSelectedIndex();
        if (i >= 0 && i < this.listModel.getSize() - 1) {
            this.listModel.add(i + 1, this.listModel.remove(i));
            this.list.setSelectedIndex(i + 1);
            this.firePropertyChange(PROP_LIST, i, i + 1);
            this.modified = true;
        }
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        int i = this.list.getSelectedIndex();
        if (i > 0) {
            this.listModel.add(i - 1, this.listModel.remove(i));
            this.list.setSelectedIndex(i - 1);
            this.firePropertyChange(PROP_LIST, i, i - 1);
            this.modified = true;
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        Object o = this.list.getSelectedValue();
        if (o != null) {
            this.listModel.removeElement(o);
            this.firePropertyChange(PROP_LIST, o, null);
            this.modified = true;
            this.checkEnabled();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent == null || !listSelectionEvent.getValueIsAdjusting()) {
            this.checkEnabled();
        }
    }

    protected void checkEnabled() {
        boolean enabled = this.isEnabled();
        int v = this.list.getSelectedIndex();
        int c = this.listModel.size();
        this.addBtn.setEnabled(enabled && c < this.maxItems);
        this.upBtn.setEnabled(enabled && v > 0);
        this.downBtn.setEnabled(enabled && v >= 0 && v < this.list.getModel().getSize() - 1);
        this.removeBtn.setEnabled(enabled && v >= 0 && c > this.minItems);
        this.editBtn.setEnabled(enabled && v >= 0);
    }

    public List<Object> getListData() {
        Enumeration en = this.listModel.elements();
        ArrayList<Object> result = new ArrayList<Object>(this.listModel.getSize());
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o instanceof List) {
                List al = (List)o;
                o = al.get(0);
            }
            result.add(o);
        }
        return result;
    }

    public void setListData(List<Object> listData) {
        this.listModel.removeAllElements();
        if (listData != null) {
            for (Object o : listData) {
                if (this.upperCase) {
                    o = o.toString().toUpperCase();
                }
                this.listModel.addElement(o);
            }
        }
        this.modified = false;
        this.checkEnabled();
    }

    public void setTextList(String[] textList) {
        this.listModel.removeAllElements();
        if (textList != null) {
            for (int i = 0; i < textList.length && i < this.maxItems; ++i) {
                String s = textList[i];
                if (this.upperCase) {
                    s = s.toUpperCase();
                }
                this.listModel.addElement(s);
            }
        }
        this.modified = false;
        this.checkEnabled();
    }

    public String[] getTextList() {
        List<Object> v = this.getListData();
        int n = v.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = v.get(i).toString();
        }
        return result;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkEnabled();
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
        this.checkEnabled();
    }

    public int getMinItems() {
        return this.minItems;
    }

    public void setMinItems(int minItems) {
        this.minItems = minItems;
        this.checkEnabled();
    }

    protected Object editItem(Object currentValue, boolean newValue) {
        String result = newValue ? this.options.getMessages().showInputDlg((Component)this, (String)null, "edit_list_newValue", "", "edit_list_addElement", false) : this.options.getMessages().showInputDlg((Component)this, (String)null, "edit_list_newValue", StrUtils.nullableString(currentValue), "edit_list_modifyValue", false);
        return result;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.list.setToolTipText(text);
        this.btnPanel.setToolTipText(text);
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

