/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.Resizable;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.ResourceManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class ActiveBagContentPreviewPanel
extends ResizerPanel
implements FocusListener {
    public static final int MARGIN = 10;
    AbstractBox[] bg = new AbstractBox[2];
    ActiveBoxBag[] abg = new ActiveBoxBag[2];
    TextGrid[] grid = new TextGrid[2];
    ActiveBagContent[] abc = new ActiveBagContent[2];
    ActiveBagContent[] altAbc = new ActiveBagContent[2];
    ActiveBagContent[][] allAbc = new ActiveBagContent[][]{this.abc, this.altAbc};
    TextGridContent[] tgc = new TextGridContent[2];
    MediaBagEditor mbe;
    boolean[] allowResize = new boolean[2];
    boolean dragCursorX = false;
    boolean dragCursorY = false;
    boolean dragging = false;
    int margin = 10;
    private int cgrid = 0;
    int boxGridPos = 0;
    ActiveBagContentEditor parent;
    int editMode;
    int currentLine;
    int highlightLine;
    BoxConnector bc;
    boolean showAllArrows = true;
    boolean crossWord = false;
    ActiveBox hClue;
    ActiveBox vClue;
    Color softLineColor = Color.blue;
    Color activeLineColor = Color.red;
    Color arrowColor = BoxConnector.DEFAULT_XOR_COLOR;
    public static final int EDIT_GRIDS = 0;
    public static final int EDIT_LINKS = 1;
    public static final int EDIT_BOOL = 2;
    public static final float ARROW_WIDTH = 2.0f;

    public ActiveBagContentPreviewPanel(ActiveBagContentEditor parent, boolean isCrossWord) {
        this.parent = parent;
        this.crossWord = isCrossWord;
        this.bc = new BoxConnector(this);
        this.bc.arrow = true;
        this.bc.line_width = 2.0f;
        this.bc.lineColor = this.activeLineColor;
        this.currentLine = -1;
        this.highlightLine = -1;
        this.editMode = 0;
        this.enableEvents(56L);
        this.addFocusListener(this);
    }

    public AbstractBox getAbstractBox(int index) {
        return this.bg[index];
    }

    public boolean isCrossWord() {
        return this.crossWord;
    }

    public void setActiveBagContent(int index, ActiveBagContent abcx, ActiveBagContent altAbcx, TextGridContent tgcx) {
        this.abc[index] = abcx;
        this.altAbc[index] = altAbcx;
        this.tgc[index] = tgcx;
        this.bg[index] = null;
        this.grid[index] = null;
        this.abg[index] = null;
        if (this.tgc[index] != null) {
            this.grid[index] = TextGrid.createEmptyGrid(null, this, this.margin, this.margin, this.tgc[index], false);
            this.bg[index] = this.grid[index];
            this.grid[index].setChars(this.tgc[index].text);
            if (this.crossWord) {
                this.grid[index].setCellAttributes(true, false);
            }
            this.grid[index].setCursorAt(0, 0, false);
            this.grid[index].setCursorEnabled(true);
            this.checkCursor(false);
            this.allowResize[index] = true;
        } else if (this.crossWord && index == 1 && this.abc[index] != null && this.altAbc[index] != null) {
            this.abg[1] = new ActiveBoxBag(null, this, this.abc[1].bb);
            this.bg[1] = this.abg[1];
            ActiveBox ab = new ActiveBox(this.abg[1], this, null);
            ActiveBoxContent abct = new ActiveBoxContent();
            abct.setImgContent(ResourceManager.getImageIcon("buttons/textright.png").getImage(), null);
            ab.setContent(abct);
            this.abg[1].addActiveBox(ab);
            this.hClue = new ActiveBox(this.abg[1], this, null);
            this.abg[1].addActiveBox(this.hClue);
            ab = new ActiveBox(this.abg[1], this, null);
            abct = new ActiveBoxContent();
            abct.setImgContent(ResourceManager.getImageIcon("buttons/textdown.png").getImage(), null);
            ab.setContent(abct);
            this.abg[1].addActiveBox(ab);
            this.vClue = new ActiveBox(this.abg[1], this, null);
            this.abg[1].addActiveBox(this.vClue);
            this.abg[1].setBorder(true);
            this.resizeCrossWordPanel((int)this.abc[1].w, (int)this.abc[1].h);
            this.cursorPosChanged();
            this.allowResize[1] = true;
        } else if (this.abc[index] != null) {
            this.abg[index] = ActiveBoxGrid.createEmptyGrid(null, this, this.margin, this.margin, this.abc[index]);
            this.bg[index] = this.abg[index];
            this.abg[index].setContent(this.abc[index], this.altAbc[index]);
            boolean bl = this.allowResize[index] = this.abc[index].img == null;
        }
        if (this.bg[index] != null) {
            this.bg[index].setVisible(true);
        }
        if (this.bc.active) {
            this.bc.end();
        }
        this.currentLine = -1;
        this.highlightLine = -1;
        this.dragCursorX = false;
        this.dragCursorY = false;
        this.setCursor(null);
        this.revalidate();
        BoxBase.resetAllFonts();
        this.repaint();
    }

    protected void resizeCrossWordPanel(int w, int h) {
        if (this.crossWord && this.abg[1] != null && this.abg[1].getNumCells() == 4) {
            boolean rowDist = this.boxGridPos == 2 || this.boxGridPos == 3;
            int x = (int)this.abg[1].getX();
            int y = (int)this.abg[1].getY();
            ActiveBox ab = this.abg[1].getActiveBox(0);
            ab.setBounds(x, y, 40.0, h);
            ab = this.abg[1].getActiveBox(1);
            ab.setBounds(x + 40, y, w, h);
            int x0 = rowDist ? x + 40 + w : x;
            int y0 = rowDist ? y : y + h;
            ab = this.abg[1].getActiveBox(2);
            ab.setBounds(x0, y0, 40.0, h);
            ab = this.abg[1].getActiveBox(3);
            ab.setBounds(x0 + 40, y0, w, h);
            this.abg[1].recalcSize();
        }
    }

    @Override
    public void doLayout() {
        if (this.bg[0] != null) {
            if (this.bg[1] != null) {
                BoxBag.layoutDouble(this.getSize(), (Resizable)((Object)this.bg[0]), (Resizable)((Object)this.bg[1]), this.boxGridPos, this.margin);
            } else {
                BoxBag.layoutSingle(this.getSize(), (Resizable)((Object)this.bg[0]), this.margin);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bg[0] != null) {
            int i;
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            do {
                BoxBase.flagFontReduced = false;
                for (i = 0; i < 2; ++i) {
                    if (this.bg[i] == null) continue;
                    this.bg[i].update(g2, g2.getClipBounds(), this);
                }
            } while (BoxBase.flagFontReduced);
            if (this.editMode == 1 && this.abg[1] != null && this.abc[0] != null) {
                for (i = 0; i < this.abc[0].getNumCells(); ++i) {
                    if (!this.showAllArrows || i == this.currentLine || i == this.highlightLine) continue;
                    this.drawArrow(g2, i);
                }
                if (this.highlightLine >= 0) {
                    this.drawArrow(g2, this.highlightLine);
                }
                this.bc.update(g2, g2.getClipBounds(), this);
            }
            g2.setRenderingHints(rh);
        }
    }

    private void drawArrow(Graphics2D g2, int i) {
        if (this.abg[0] == null || this.abg[1] == null) {
            return;
        }
        ActiveBox bx = this.abg[0].getActiveBox(i);
        int id = this.abc[0].getActiveBoxContent((int)i).id;
        if (id >= 0 && id < this.abc[1].getNumCells()) {
            ActiveBox bx2 = this.abg[1].getActiveBox(id);
            if (bx != null && bx2 != null) {
                BoxConnector.drawLine(g2, new Point2D.Double(bx.getX() + bx.getWidth() / 2.0, bx.getY() + bx.getHeight() / 2.0), new Point2D.Double(bx2.getX() + bx2.getWidth() / 2.0, bx2.getY() + bx2.getHeight() / 2.0), true, i == this.highlightLine ? this.activeLineColor : this.softLineColor, this.arrowColor, 10.0, 0.5235987755982988, i == this.highlightLine ? 2.0f : 1.5f);
            }
        }
    }

    public void setMediaBagEditor(MediaBagEditor mbe) {
        this.mbe = mbe;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        boolean consumed = false;
        if (this.bg[0] != null) {
            if (e instanceof MouseEvent) {
                switch (this.editMode) {
                    case 0: {
                        consumed = this.processMouseGrids((MouseEvent)e);
                        break;
                    }
                    case 1: {
                        consumed = this.processMouseLinks((MouseEvent)e);
                        break;
                    }
                    case 2: {
                        consumed = this.processMouseBool((MouseEvent)e);
                    }
                }
            } else if (e instanceof KeyEvent && (this.grid[0] != null || this.grid[1] != null)) {
                consumed = this.processKey((KeyEvent)e);
            }
        }
        if (!consumed) {
            super.processEvent(e);
        }
    }

    private boolean processMouseGrids(MouseEvent ev) {
        ActiveBoxBag xbg;
        AbstractBox xbox;
        boolean consumed = false;
        Point p = ev.getPoint();
        int id = ev.getID();
        int index = this.cgrid;
        if (!(this.dragging || id != 503 && id != 501)) {
            index = this.bg[0] != null && this.bg[0].contains(p) ? 0 : (this.bg[1] != null && this.bg[1].contains(p) ? 1 : -1);
        }
        AbstractBox abstractBox = xbox = index >= 0 ? this.bg[index] : null;
        ActiveBoxBag activeBoxBag = this.abg[0] == xbox ? this.abg[0] : (xbg = this.abg[1] == xbox ? this.abg[1] : null);
        TextGrid xgrid = this.grid[0] == xbox ? this.grid[0] : (this.grid[1] == xbox ? this.grid[1] : null);
        switch (ev.getID()) {
            case 503: {
                if (this.dragging) break;
                Cursor newCursor = null;
                if (xbox != null && this.allowResize[index]) {
                    this.dragCursorX = Math.abs((double)p.x - xbox.x - xbox.width) < 5.0 && (double)p.y >= xbox.y && (double)p.y < xbox.y + xbox.height + 5.0;
                    boolean bl = this.dragCursorY = Math.abs((double)p.y - xbox.y - xbox.height) < 5.0 && (double)p.x >= xbox.x && (double)p.x < xbox.x + xbox.width + 5.0;
                    if (this.dragCursorX && this.dragCursorY) {
                        newCursor = Cursor.getPredefinedCursor(6);
                    } else if (this.dragCursorY) {
                        newCursor = Cursor.getPredefinedCursor(8);
                    } else if (this.dragCursorX) {
                        newCursor = Cursor.getPredefinedCursor(11);
                    }
                }
                if (newCursor == null && xbg != null && xbg.findActiveBox(p) != null) {
                    newCursor = Cursor.getPredefinedCursor(12);
                }
                this.setCursor(newCursor);
                break;
            }
            case 501: {
                Point pt;
                if (xbox == null) break;
                this.setPanelSelected(index);
                if (this.dragCursorX || this.dragCursorY) {
                    this.dragging = true;
                    this.resizeByDrag(p, false);
                } else if (xgrid != null && xgrid.contains(p) && (pt = xgrid.getLogicalCoords(p)) != null) {
                    this.setCursorAt(pt.x, pt.y);
                }
                consumed = true;
                break;
            }
            case 502: {
                ActiveBox ab;
                if (xbox == null) break;
                if (this.dragging) {
                    this.resizeByDrag(p, true);
                    this.dragging = false;
                } else if (xbg != null && (ab = xbg.findActiveBox(p)) != null) {
                    ActiveBoxContent abxc;
                    ActiveBoxContent abxcnt = ab.getCurrentContent();
                    int group = -1;
                    int bag = -1;
                    int item = -1;
                    for (int i = 0; i < this.allAbc.length && item < 0; ++i) {
                        for (int j = 0; j < this.allAbc[i].length && item < 0; ++j) {
                            if (this.allAbc[i][j] == null || (item = this.allAbc[i][j].indexOf(abxcnt)) < 0) continue;
                            bag = j;
                            group = i;
                        }
                    }
                    if (item >= 0 && (abxc = ActiveBoxContentEditor.getActiveBoxContent(abxcnt, this, this.parent.getOptions(), this.mbe, ab)) != null) {
                        this.allAbc[group][bag].setActiveBoxContentAt(abxc, item);
                        this.setModified(true);
                        if (!ab.isAlternative()) {
                            ab.setContent(abxc);
                        } else {
                            ab.setAltContent(abxc);
                        }
                        BoxBase.resetAllFonts();
                        this.repaint();
                    }
                }
                consumed = true;
                break;
            }
            case 506: {
                if (xbox == null || !this.dragging) break;
                this.resizeByDrag(p, false);
                consumed = true;
            }
        }
        return consumed;
    }

    protected boolean processMouseLinks(MouseEvent ev) {
        boolean consumed = false;
        if (this.abg[0] != null && this.abg[1] != null) {
            Point pt = ev.getPoint();
            switch (ev.getID()) {
                case 503: 
                case 506: {
                    if (this.bc.active) {
                        this.bc.moveTo(pt);
                    } else {
                        int newLine = -1;
                        ActiveBox bx = this.abg[0].findActiveBox(pt);
                        if (bx != null) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                            newLine = bx.idOrder;
                        } else {
                            this.setCursor(null);
                        }
                        if (newLine != this.highlightLine) {
                            this.highlightLine = newLine;
                            this.repaint();
                        }
                    }
                    consumed = true;
                    break;
                }
                case 501: {
                    if (this.bc.active) {
                        this.bc.end();
                        ActiveBox bx = this.abg[1].findActiveBox(this.bc.dest);
                        ActiveBoxContent bc0 = this.abc[0].getActiveBoxContent(this.currentLine);
                        bc0.id = bx == null ? -1 : bx.idOrder;
                        this.highlightLine = this.currentLine;
                        this.currentLine = -1;
                        this.setModified(true);
                        this.repaint();
                    } else {
                        ActiveBox bx = this.abg[0].findActiveBox(pt);
                        if (bx != null) {
                            this.highlightLine = -1;
                            this.currentLine = bx.idOrder;
                            this.repaint();
                            this.bc.begin(pt);
                        }
                    }
                    consumed = true;
                }
            }
        }
        return consumed;
    }

    private void resizeByDrag(Point p, boolean finish) {
        if (this.cgrid >= 0 && this.bg[this.cgrid] != null) {
            int ncw = 0;
            int nch = 0;
            if (this.abg[this.cgrid] == this.bg[this.cgrid] && this.abc[this.cgrid] != null) {
                if (this.crossWord) {
                    ncw = 1;
                    nch = 1;
                } else {
                    ncw = this.abc[this.cgrid].ncw;
                    nch = this.abc[this.cgrid].nch;
                }
            } else if (this.grid[this.cgrid] == this.bg[this.cgrid] && this.tgc[this.cgrid] != null) {
                ncw = this.tgc[this.cgrid].ncw;
                nch = this.tgc[this.cgrid].nch;
            }
            if (ncw > 0 && nch > 0) {
                int w = (int)(this.bg[this.cgrid].width / (double)ncw);
                int h = (int)(this.bg[this.cgrid].height / (double)nch);
                if (this.dragCursorX) {
                    w = (int)(((double)p.x - this.bg[this.cgrid].x) / (double)ncw);
                }
                if (this.dragCursorY) {
                    h = (int)(((double)p.y - this.bg[this.cgrid].y) / (double)nch);
                }
                if (this.crossWord && this.cgrid == 1) {
                    if (this.boxGridPos == 2 || this.boxGridPos == 3) {
                        w = (w - 80) / 2;
                    } else {
                        w -= 40;
                        h /= 2;
                    }
                }
                if (w > 10 && h > 10) {
                    this.doResize(this.cgrid, w, h, finish);
                    if (finish && this.crossWord) {
                        this.cursorPosChanged();
                    }
                }
            }
        }
    }

    protected void doResize(int index, int w, int h, boolean finish) {
        AbstractBox xbox;
        AbstractBox abstractBox = xbox = index >= 0 ? this.bg[index] : null;
        if (xbox != null) {
            this.setModified(true);
            if (this.tgc[index] != null) {
                this.tgc[index].w = w;
                this.tgc[index].h = h;
            } else if (this.abc[index] != null) {
                this.abc[index].w = w;
                this.abc[index].h = h;
            }
            if (this.crossWord && index == 1) {
                this.altAbc[index].w = w;
                this.altAbc[index].h = h;
                this.resizeCrossWordPanel(w, h);
            } else {
                int ncw = this.tgc[index] != null ? this.tgc[index].ncw : this.abc[index].ncw;
                int nch = this.tgc[index] != null ? this.tgc[index].nch : this.abc[index].nch;
                Rectangle r = new Rectangle((int)this.bg[index].getX(), (int)this.bg[index].getY(), w * ncw, h * nch);
                xbox.setBounds(r);
            }
            if (finish) {
                ActiveBoxBag xbg = xbox == this.abg[0] ? this.abg[0] : (xbox == this.abg[1] ? this.abg[1] : null);
                boolean xbgAlt = xbg != null && xbg.isAlternative();
                this.setActiveBagContent(index, this.abc[index], this.altAbc[index], this.tgc[index]);
                if (xbgAlt && this.abg[index] != null) {
                    this.abg[index].setAlternative(true);
                }
            }
            this.parent.resized(index);
        }
        this.repaint();
    }

    protected boolean processMouseBool(MouseEvent ev) {
        boolean consumed = false;
        if (this.abg[0] != null) {
            ActiveBox bx = this.abg[0].findActiveBox(ev.getPoint());
            switch (ev.getID()) {
                case 503: {
                    this.setCursor(bx != null ? Cursor.getPredefinedCursor(12) : null);
                    consumed = true;
                    break;
                }
                case 502: {
                    if (bx == null) break;
                    int v = bx.getContent().id;
                    bx.getContent().id = v = v > 0 ? 0 : 1;
                    bx.setInverted(v > 0);
                    bx.setMarked(v > 0);
                    this.setModified(true);
                    consumed = true;
                }
            }
        }
        return consumed;
    }

    public void setModified(boolean modified) {
        this.parent.setModified(modified);
    }

    public int getBoxGridPos() {
        return this.boxGridPos;
    }

    public void setBoxGridPos(int boxGridPos) {
        this.boxGridPos = boxGridPos;
        if (this.crossWord && this.abc[1] != null) {
            this.resizeCrossWordPanel((int)this.abc[1].w, (int)this.abc[1].h);
        }
        BoxBase.resetAllFonts();
        this.revalidate();
    }

    public int getEditMode() {
        return this.editMode;
    }

    public void setEditMode(int editMode) {
        boolean checkBool = editMode == 2 || this.editMode == 2;
        this.editMode = editMode;
        if (checkBool && this.abg[0] != null) {
            for (int i = 0; i < this.abg[0].getNumCells(); ++i) {
                ActiveBox bx = this.abg[0].getActiveBox(i);
                if (bx == null) continue;
                bx.setInverted(editMode == 2 ? bx.getContent().id > 0 : false);
                bx.setMarked(editMode == 2 ? bx.getContent().id > 0 : false);
            }
        }
        this.repaint();
    }

    public boolean isShowAllArrows() {
        return this.showAllArrows;
    }

    public void setShowAllArrows(boolean showAllArrows) {
        this.showAllArrows = showAllArrows;
        this.repaint();
    }

    protected void moveCursor(int dx, int dy) {
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null) {
            this.grid[this.cgrid].moveCursor(dx, dy, false);
            this.cursorPosChanged();
        }
    }

    protected void setCursorAt(int x, int y) {
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null) {
            this.grid[this.cgrid].setCursorAt(x, y, false);
        }
        this.cursorPosChanged();
    }

    protected void cursorPosChanged() {
        Point items;
        Point pt;
        if (this.crossWord && this.grid[0] != null && this.hClue != null && this.vClue != null && (pt = this.grid[0].getCursor()) != null && (items = this.grid[0].getItemFor(pt.x, pt.y)) != null) {
            ActiveBoxContent abxc = this.abc[1].getActiveBoxContentWith(pt.y, items.x);
            if (abxc == null) {
                this.abc[1].insertActiveBoxContentWith(pt.y, items.x);
                abxc = this.abc[1].getActiveBoxContentWith(pt.y, items.x);
            }
            this.hClue.setContent(abxc);
            abxc = this.altAbc[1].getActiveBoxContentWith(pt.x, items.y);
            if (abxc == null) {
                this.altAbc[1].insertActiveBoxContentWith(pt.x, items.y);
                abxc = this.altAbc[1].getActiveBoxContentWith(pt.x, items.y);
            }
            this.vClue.setContent(abxc);
        }
    }

    public boolean processKey(KeyEvent e) {
        boolean consumed = false;
        if (this.cgrid >= 0 && this.grid[this.cgrid] != null && this.tgc[this.cgrid] != null) {
            int dx = 0;
            int dy = 0;
            boolean delete = false;
            boolean moveFirst = false;
            Point cur = this.grid[this.cgrid].getCursor();
            char ch1 = '\u0000';
            switch (e.getID()) {
                case 401: {
                    switch (e.getKeyCode()) {
                        case 39: {
                            dx = 1;
                            break;
                        }
                        case 37: {
                            dx = -1;
                            break;
                        }
                        case 40: {
                            dy = 1;
                            break;
                        }
                        case 38: {
                            dy = -1;
                            break;
                        }
                        case 8: {
                            dx = -1;
                            delete = true;
                            moveFirst = true;
                            break;
                        }
                        case 127: {
                            delete = true;
                        }
                    }
                    break;
                }
                case 400: {
                    char ch0 = e.getKeyChar();
                    int kk = e.getKeyCode();
                    if (cur == null) break;
                    dx = 1;
                    if (Character.isLetterOrDigit(ch0)) {
                        ch1 = Character.toUpperCase(ch0);
                        break;
                    }
                    if (ch0 == this.tgc[this.cgrid].wild || Character.isSpaceChar(ch0)) {
                        delete = true;
                        break;
                    }
                    dx = 0;
                }
            }
            if (moveFirst && (dx != 0 || dy != 0)) {
                this.moveCursor(dx, dy);
                cur = this.grid[this.cgrid].getCursor();
                consumed = true;
            }
            if (delete) {
                ch1 = this.tgc[this.cgrid].wild;
            }
            if (ch1 != '\u0000' && cur != null) {
                if (this.crossWord) {
                    this.checkWildChanges(cur, ch1);
                }
                this.grid[this.cgrid].setCharAt(cur.x, cur.y, ch1);
                this.tgc[this.cgrid].setCharAt(cur.x, cur.y, ch1);
                this.setModified(true);
                consumed = true;
            }
            if (!(moveFirst || dx == 0 && dy == 0)) {
                this.moveCursor(dx, dy);
                consumed = true;
            }
        }
        return consumed;
    }

    protected void checkWildChanges(Point pt, char ch) {
        Point items;
        boolean addWild;
        if (!this.crossWord) {
            return;
        }
        char oldCh = this.grid[this.cgrid].getCharAt(pt.x, pt.y);
        boolean deleteWild = oldCh == this.tgc[this.cgrid].wild && ch != oldCh;
        boolean bl = addWild = !deleteWild && ch == this.tgc[this.cgrid].wild && ch != oldCh;
        if ((addWild || deleteWild) && (items = this.grid[this.cgrid].getItemFor(pt.x, pt.y)) != null) {
            boolean intoWhitesH = this.grid[this.cgrid].isIntoWhites(pt, true);
            boolean intoWhitesV = this.grid[this.cgrid].isIntoWhites(pt, false);
            boolean intoBlacksH = this.grid[this.cgrid].isIntoBlacks(pt, true);
            boolean intoBlacksV = this.grid[this.cgrid].isIntoBlacks(pt, false);
            if (deleteWild) {
                if (intoWhitesH) {
                    this.abc[1].deleteActiveBoxContentWith(pt.y, items.x);
                } else if (intoBlacksH) {
                    this.abc[1].insertActiveBoxContentWith(pt.y, items.x);
                }
                if (intoWhitesV) {
                    this.altAbc[1].deleteActiveBoxContentWith(pt.x, items.y);
                } else if (intoBlacksV) {
                    this.altAbc[1].insertActiveBoxContentWith(pt.x, items.y);
                }
            } else {
                if (intoWhitesH) {
                    this.abc[1].insertActiveBoxContentWith(pt.y, items.x);
                } else if (intoBlacksH) {
                    this.abc[1].deleteActiveBoxContentWith(pt.y, items.x);
                }
                if (intoWhitesV) {
                    this.altAbc[1].insertActiveBoxContentWith(pt.x, items.y);
                } else if (intoBlacksV) {
                    this.altAbc[1].deleteActiveBoxContentWith(pt.x, items.y);
                }
            }
            this.grid[this.cgrid].setCellLocked(pt.x, pt.y, addWild);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.checkCursor(false);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.checkCursor(true);
    }

    public void checkCursor(boolean forceLost) {
        for (int i = 0; i < 2; ++i) {
            if (this.grid[i] == null) continue;
            if (this.cgrid == i && !forceLost && this.hasFocus()) {
                this.grid[i].startCursorBlink();
                continue;
            }
            this.grid[i].stopCursorBlink();
        }
    }

    private void setPanelSelected(int index) {
        this.cgrid = index;
        this.parent.panelSelected(this.cgrid);
        if (!this.hasFocus()) {
            this.requestFocus();
        } else {
            this.checkCursor(false);
        }
    }
}

