/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.BoxBaseButton;
import edu.xtec.jclic.beans.Compass;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.MediaContentButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.media.MediaContentEditor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;

public class ActiveBoxContentEditor
extends CtrlPanel {
    Options options;
    ActiveBoxContent abc;
    MediaBagEditor mbe;
    boolean eventsEnabled = true;
    public static final String PROP_ABC = "activeBoxContent";
    ActiveBox preview;
    private static Map<Options, ActiveBoxContentEditor> panels = new HashMap<Options, ActiveBoxContentEditor>();
    private JCheckBox borderChk;
    private BoxBaseButton boxBaseButton;
    private ButtonGroup hAlignGrp;
    private SmallIntEditor heightEdit;
    private JLabel heightLb;
    private ImgButton imgButton;
    private Compass imgCompass;
    private MediaContentButton mcButton;
    private JLabel mcLb;
    private JCheckBox overlapChk;
    private JLabel sizeLb;
    private JPanel sizePanel;
    private JSeparator sizeSep;
    private JLabel styleLb;
    private JTextArea textArea;
    private Compass textCompass;
    private JScrollPane textScroll;
    private ButtonGroup vAlignGrp;
    private SmallIntEditor widthEdit;
    private JLabel widthLb;

    public ActiveBoxContentEditor(Options options, ActiveBoxContent abc, MediaBagEditor mbe, ActiveBox ab) {
        this.options = options;
        this.initComponents();
        this.setMediaBagEditor(mbe);
        this.setActiveBoxContent(abc);
        this.textArea.getDocument().addDocumentListener(this);
        this.setPreview(ab);
    }

    private void initComponents() {
        this.hAlignGrp = new ButtonGroup();
        this.vAlignGrp = new ButtonGroup();
        JLabel textLb = new JLabel();
        this.textScroll = new JScrollPane();
        this.textArea = new JTextArea();
        this.textCompass = new Compass();
        JSeparator sep1 = new JSeparator();
        JLabel imgLb = new JLabel();
        this.imgButton = new ImgButton();
        this.imgButton.setOptions(this.options);
        this.overlapChk = new JCheckBox();
        this.imgCompass = new Compass();
        JSeparator sep2 = new JSeparator();
        this.styleLb = new JLabel();
        this.boxBaseButton = new BoxBaseButton();
        this.boxBaseButton.setOptions(this.options);
        this.borderChk = new JCheckBox();
        JSeparator sep11 = new JSeparator();
        this.mcLb = new JLabel();
        this.mcButton = new MediaContentButton();
        this.mcButton.setOptions(this.options);
        this.sizeSep = new JSeparator();
        this.sizeLb = new JLabel();
        this.sizePanel = new JPanel();
        this.widthLb = new JLabel();
        this.widthEdit = new SmallIntEditor();
        this.heightLb = new JLabel();
        this.heightEdit = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        textLb.setLabelFor(this.textArea);
        textLb.setText(this.options.getMsg("edit_act_text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)textLb, gridBagConstraints);
        this.textScroll.setPreferredSize(new Dimension(300, 3));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textScroll.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textScroll, gridBagConstraints);
        this.textCompass.addPropertyChangeListener("direction", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.textCompass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)sep1, gridBagConstraints);
        imgLb.setText(this.options.getMsg("edit_act_image"));
        imgLb.setLabelFor(this.imgButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)imgLb, gridBagConstraints);
        this.imgButton.setToolTipText(this.options.getMsg("edit_act_image_tooltip"));
        this.imgButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.imgButton, gridBagConstraints);
        this.overlapChk.setToolTipText(this.options.getMsg("edit_act_overlap_tooltip"));
        this.overlapChk.setText(this.options.getMsg("edit_act_overlap"));
        this.overlapChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.overlapChk, gridBagConstraints);
        this.imgCompass.addPropertyChangeListener("direction", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.imgCompass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)sep2, gridBagConstraints);
        this.styleLb.setText(this.options.getMsg("edit_act_style"));
        this.styleLb.setLabelFor(this.boxBaseButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.styleLb, gridBagConstraints);
        this.boxBaseButton.setToolTipText(this.options.getMsg("edit_style_tooltip"));
        this.boxBaseButton.addPropertyChangeListener("boxBase", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.boxBaseButton, gridBagConstraints);
        this.borderChk.setToolTipText(this.options.getMsg("edit_act_border_tooltip"));
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.borderChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)sep11, gridBagConstraints);
        this.mcLb.setLabelFor(this.mcButton);
        this.mcLb.setText(this.options.getMsg("edit_mc_label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.mcLb, gridBagConstraints);
        this.mcButton.addPropertyChangeListener("mediaContent", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mcButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.sizeSep, gridBagConstraints);
        this.sizeLb.setLabelFor(this.sizePanel);
        this.sizeLb.setText(this.options.getMsg("edit_cell_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.sizeLb, gridBagConstraints);
        this.sizePanel.setLayout(new GridBagLayout());
        this.widthLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_width.gif")));
        this.widthLb.setLabelFor(this.widthEdit);
        this.widthLb.setText(":");
        this.widthLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 2);
        gridBagConstraints.anchor = 13;
        this.sizePanel.add((Component)this.widthLb, gridBagConstraints);
        this.widthEdit.setToolTipText(this.options.getMsg("edit_act_cell_width_tooltip"));
        this.widthEdit.setMax(999);
        this.widthEdit.setMin(10);
        this.widthEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 2, 3, 3);
        gridBagConstraints.anchor = 17;
        this.sizePanel.add((Component)this.widthEdit, gridBagConstraints);
        this.heightLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/adjust_height.gif")));
        this.heightLb.setLabelFor(this.widthEdit);
        this.heightLb.setText(":");
        this.heightLb.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 12, 3, 2);
        gridBagConstraints.anchor = 13;
        this.sizePanel.add((Component)this.heightLb, gridBagConstraints);
        this.heightEdit.setToolTipText(this.options.getMsg("edit_act_cell_height_tooltip"));
        this.heightEdit.setMax(999);
        this.heightEdit.setMin(10);
        this.heightEdit.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 2, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.sizePanel.add((Component)this.heightEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sizePanel, gridBagConstraints);
    }

    public void setPreview(ActiveBox ab) {
        this.preview = ab;
        this.boxBaseButton.setPreview(ab);
    }

    @Override
    public boolean genericEvent(Object event) {
        Object src;
        Object object = event instanceof EventObject ? ((EventObject)event).getSource() : (src = event instanceof DocumentEvent ? this.textArea : null);
        if (this.eventsEnabled && src != null) {
            this.eventsEnabled = false;
            ActiveBoxContent oldAbc = this.getAbcClone();
            boolean resetPreviewFont = false;
            if (src == this.textArea) {
                String txt = this.textArea.getText();
                if (!StrUtils.compareTrimStringsIgnoreCase(txt, this.abc.rawText)) {
                    this.abc.setTextContent(txt != null && txt.length() > 0 ? txt : null);
                    if (this.abc.bb != null) {
                        this.abc.bb.resetFont();
                    }
                }
            } else if (src == this.imgButton) {
                if (this.abc.imgName != null) {
                    this.abc.img = null;
                }
                this.abc.imgName = this.imgButton.getImgName();
            } else if (src == this.borderChk) {
                this.abc.border = this.borderChk.isSelected();
            } else if (src == this.overlapChk) {
                this.abc.avoidOverlapping = this.overlapChk.isSelected();
                resetPreviewFont = true;
            } else if (src == this.textCompass) {
                this.abc.txtAlign = this.textCompass.getDoubleDirection();
                resetPreviewFont = true;
            } else if (src == this.imgCompass) {
                this.abc.imgAlign = this.imgCompass.getDoubleDirection();
                resetPreviewFont = true;
            } else if (src == this.boxBaseButton) {
                this.abc.bb = this.boxBaseButton.getBoxBase();
                resetPreviewFont = true;
            } else if (src == this.mcButton) {
                this.abc.mediaContent = this.mcButton.getMediaContent();
            } else if (this.abc.dimension != null && src == this.widthEdit || src == this.heightEdit) {
                this.abc.setDimension(new Dimension(this.widthEdit.getValue(), this.heightEdit.getValue()));
            }
            if (this.mbe != null && (src == this.textArea || src == this.imgButton)) {
                try {
                    this.abc.realizeContent(this.mbe.getMediaBag());
                }
                catch (Exception ex) {
                    this.options.getMessages().showErrorWarning(this, "ERROR", ex);
                }
            }
            if (this.preview != null) {
                BoxBase bb = this.abc.bb;
                if (resetPreviewFont && bb != null) {
                    bb.resetFont();
                }
                this.preview.setCurrentContent(this.abc);
            }
            this.checkAndFirePropertyChange(oldAbc);
            this.eventsEnabled = true;
        }
        return true;
    }

    public void setActiveBoxContent(ActiveBoxContent c) {
        if (c == null) {
            c = new ActiveBoxContent();
        }
        this.eventsEnabled = false;
        this.abc = (ActiveBoxContent)c.clone();
        this.textArea.setText(this.abc.text);
        this.imgButton.clear();
        this.imgButton.setImgName(this.abc.imgName);
        this.borderChk.setSelected(this.abc.border == null ? false : this.abc.border);
        this.textCompass.setDoubleDirection(this.abc.txtAlign);
        this.imgCompass.setDoubleDirection(this.abc.imgAlign);
        this.overlapChk.setSelected(this.abc.avoidOverlapping);
        this.boxBaseButton.setBoxBase(this.abc.bb);
        this.mcButton.clear();
        this.mcButton.setMediaContent(this.abc.mediaContent);
        Dimension size = this.abc.getDimension();
        this.sizeSep.setVisible(size != null);
        this.sizeLb.setVisible(size != null);
        this.sizePanel.setVisible(size != null);
        this.widthEdit.setValue(size == null ? 0 : size.width);
        this.heightEdit.setValue(size == null ? 0 : size.height);
        if (this.preview != null) {
            this.preview.setCurrentContent(this.abc);
        }
        this.eventsEnabled = true;
    }

    public ActiveBoxContent getAbc() {
        if (this.abc.dimension != null) {
            this.abc.setDimension(new Dimension(this.widthEdit.getValue(), this.heightEdit.getValue()));
        }
        return this.abc;
    }

    public ActiveBoxContent getAbcClone() {
        return this.abc == null ? null : (ActiveBoxContent)this.abc.clone();
    }

    private void checkAndFirePropertyChange(ActiveBoxContent oldAbc) {
        boolean eq;
        ActiveBoxContent currentAbc = this.getAbc();
        boolean bl = eq = oldAbc == null && currentAbc == null || oldAbc != null && oldAbc.equals(currentAbc);
        if (!eq) {
            this.firePropertyChange(PROP_ABC, oldAbc, currentAbc);
        }
    }

    public void setMediaBagEditor(MediaBagEditor mbe) {
        this.mbe = mbe;
        this.imgButton.setMediaBagEditor(mbe);
        this.mcButton.setMediaBagEditor(mbe);
    }

    public static ActiveBoxContent getActiveBoxContent(ActiveBoxContent initialAbc, Component parent, Options options, MediaBagEditor mbe, ActiveBox preview) {
        boolean b;
        if (initialAbc == null) {
            initialAbc = new ActiveBoxContent();
        }
        Messages msg = options.getMessages();
        ActiveBoxContentEditor abce = panels.get(options);
        if (abce == null) {
            abce = new ActiveBoxContentEditor(options, initialAbc, mbe, preview);
            panels.put(options, abce);
        } else {
            abce.setPreview(null);
            abce.setMediaBagEditor(mbe);
            abce.setActiveBoxContent(initialAbc);
            abce.setPreview(preview);
        }
        ActiveBoxContent abcBackup = null;
        ActiveBoxContent abcOriginal = null;
        if (preview != null && (abcOriginal = preview.getCurrentContent()) != null) {
            abcBackup = (ActiveBoxContent)abcOriginal.clone();
        }
        if (!(b = msg.showInputDlg(parent, abce, "edit_cell_title")) && preview != null) {
            if (abcOriginal != null && abcBackup != null) {
                abcOriginal.copyRawDataFrom(abcBackup);
            }
            preview.setCurrentContent(abcOriginal);
        }
        return b ? abce.getAbc() : null;
    }

    public static boolean nameChanged(ActiveBoxContent abc, int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 0x10) != 0 && oldName.equals(abc.imgName)) {
            abc.imgName = newName;
            result = true;
        }
        if (abc.mediaContent != null) {
            result |= MediaContentEditor.nameChanged(abc.mediaContent, type, oldName, newName);
        }
        return result;
    }
}

