/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectFileUtils;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.json.JSONObject;

public class ExportTaskDlg
extends JPanel {
    ResourceBridge rb;
    Options options;
    SwingWorker sw;
    File exportPath;
    static String indexHtml = "<!DOCTYPE html>\n<html>\n  <head>\n    <meta charset=\"UTF-8\">\n    <title>%TITLE%</title>\n    <meta name=\"apple-mobile-web-app-capable\" content=\"yes\">\n    <meta name=\"mobile-web-app-capable\" content=\"yes\">\n    <meta name=\"application-name\" content=\"%TITLE%\">\n    <link rel=\"shortcut icon\" href=\"favicon.ico\">\n    <link rel=\"icon\" sizes=\"16x16\" href=\"favicon.ico\">\n    <link rel=\"icon\" sizes=\"72x72\" href=\"icon-72.png\">\n    <link rel=\"icon\" sizes=\"192x192\" href=\"icon-192.png\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <script type=\"text/javascript\" src=\"%JSCODEBASE%\"></script>\n  </head>\n  <body style=\"margin:0\">\n    <div class =\"JClic\" data-project=\"%MAINFILE%\"></div>\n  </body>\n</html>";
    static String imsmanifest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Generated by JClic - https://projectestac.github.io/jclic -->\n<manifest identifier=\"%SCORMID%\" version=\"1.0\" xmlns=\"http://www.imsproject.org/xsd/imscp_rootv1p1p2\" xmlns:adlcp=\"http://www.adlnet.org/xsd/adlcp_rootv1p2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation= \"http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd\">\n <metadata> \n  <schema>ADL SCORM</schema>\n  <schemaversion>1.2</schemaversion>\n </metadata> \n <organizations default=\"JClic\">  \n  <organization identifier=\"JClic\">  \n   <title>%SCORMTITLE%</title>\n   <item identifier=\"ITEM_%SCORMID%\" identifierref=\"RES_%SCORMID%\">\n    <title>%SCORMTITLE%</title>\n   </item>\n  </organization>\n </organizations>\n <resources>\n  <resource identifier=\"RES_%SCORMID%\" type=\"webcontent\" href=\"/index.html\" adlcp:scormtype=\"sco\"> \n%FILETAGS%  </resource>\n </resources>\n</manifest>";
    PrintStream ps = new PrintStream(new ByteArrayOutputStream()){

        @Override
        public synchronized void println(String s) {
            ExportTaskDlg.this.logArea.append(s + "\n");
            ExportTaskDlg.this.logArea.setCaretPosition(ExportTaskDlg.this.logArea.getText().length());
        }

        @Override
        public synchronized void print(String s) {
            ExportTaskDlg.this.logArea.append(s);
            ExportTaskDlg.this.logArea.setCaretPosition(ExportTaskDlg.this.logArea.getText().length());
        }
    };
    private JButton browserBtn;
    private JButton cancelBtn;
    private JButton copyBtn;
    private JScrollPane jScrollPane1;
    private JTextArea logArea;

    public ExportTaskDlg(ResourceBridge rb) {
        this.rb = rb;
        this.options = rb.getOptions();
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.logArea = new JTextArea();
        JPanel bottomPanel = new JPanel();
        this.copyBtn = new JButton();
        this.browserBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(0, 10));
        this.jScrollPane1.setPreferredSize(new Dimension(600, 500));
        this.logArea.setEditable(false);
        this.logArea.setLineWrap(true);
        this.logArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.logArea);
        this.add((Component)this.jScrollPane1, "Center");
        bottomPanel.setLayout(new FlowLayout(1, 10, 5));
        this.copyBtn.setText(this.options.getMsg("export_project_copyLog"));
        this.copyBtn.setEnabled(false);
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportTaskDlg.this.copyBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.copyBtn);
        this.browserBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/html_doc.gif")));
        this.browserBtn.setText(this.options.getMsg("export_project_launchBrowser"));
        this.browserBtn.setEnabled(false);
        this.browserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportTaskDlg.this.browserBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.browserBtn);
        this.cancelBtn.setText(this.options.getMsg("CANCEL"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportTaskDlg.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.cancelBtn);
        this.add((Component)bottomPanel, "South");
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        StringSelection stringSelection = new StringSelection(this.logArea.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        if (this.sw != null) {
            ProjectFileUtils.interrupt = true;
        } else {
            JDialog myDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            if (myDlg != null) {
                myDlg.dispose();
            }
        }
    }

    private void browserBtnActionPerformed(ActionEvent evt) {
        String url = this.exportPath + "/index.html";
        BrowserLauncher.openURL(url);
        this.ps.println("File " + url + " opened in web browser.");
    }

    public static void doTask(ResourceBridge rb, AuthorSettings settings, Component parent, final String inputPath, final String outputPath, final String mainFileName, final JClicProject project, final boolean copyAll, final String scormFile) {
        final Messages msg = rb.getOptions().getMessages();
        final ExportTaskDlg exportDlg = new ExportTaskDlg(rb);
        final AuthorSettings set = settings;
        JDialog dlg = new JDialog(JOptionPane.getFrameForComponent(parent), true);
        dlg.setTitle(msg.get("export_project_exporting"));
        dlg.setDefaultCloseOperation(2);
        dlg.getContentPane().setLayout(new BorderLayout(10, 10));
        dlg.getContentPane().add((Component)exportDlg, "Center");
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.setLocation((parent.getWidth() - dlg.getWidth()) / 2, (parent.getHeight() - dlg.getHeight()) / 2);
        exportDlg.sw = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    ArrayList<String> fileList = new ArrayList<String>();
                    fileList.add("imsmanifest.xml");
                    if (!copyAll) {
                        exportDlg.ps.println("Processing: " + inputPath);
                        ProjectFileUtils.processSingleFile(inputPath, outputPath, fileList, exportDlg.ps);
                    } else {
                        exportDlg.ps.println("Processing all projects in: " + inputPath);
                        ProjectFileUtils.processRootFolder(inputPath, outputPath, fileList, exportDlg.ps);
                    }
                    exportDlg.ps.println("Generating file " + outputPath + "/index.html");
                    FileOutputStream fos = new FileOutputStream(new File(outputPath, "index.html"));
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                    String s = indexHtml.replaceAll("%TITLE%", StrUtils.safeHtml(project.settings.title));
                    s = StrUtils.replace(s, "%MAINFILE%", mainFileName);
                    s = StrUtils.replace(s, "%JSCODEBASE%", set.jsCodeBase);
                    pw.print(s);
                    pw.flush();
                    pw.close();
                    fileList.add("index.html");
                    JSONObject json = project.settings.toJSON(msg);
                    json.put("mainFile", mainFileName);
                    exportDlg.exportPath = new File(outputPath);
                    String fn = "favicon.ico";
                    exportDlg.ps.println("Copying " + fn);
                    StreamIO.writeStreamTo(this.getClass().getResourceAsStream("/edu/xtec/resources/icons/" + fn), new FileOutputStream(new File(outputPath, fn)));
                    fileList.add(fn);
                    fn = "icon-192.png";
                    exportDlg.ps.println("Copying " + fn);
                    StreamIO.writeStreamTo(this.getClass().getResourceAsStream("/edu/xtec/resources/icons/" + fn), new FileOutputStream(new File(outputPath, fn)));
                    fileList.add(fn);
                    fn = "icon-72.png";
                    exportDlg.ps.println("Copying " + fn);
                    StreamIO.writeStreamTo(this.getClass().getResourceAsStream("/edu/xtec/resources/icons/" + fn), new FileOutputStream(new File(outputPath, fn)));
                    fileList.add(fn);
                    exportDlg.ps.println("Copying project cover model");
                    StreamIO.writeStreamTo(this.getClass().getResourceAsStream("/edu/xtec/resources/icons/cover-base.jpg"), new FileOutputStream(new File(outputPath, "project-cover.jpg")));
                    fileList.add("project-cover.jpg");
                    json.put("cover", "project-cover.jpg");
                    exportDlg.ps.println("Copying project thumbnail model");
                    StreamIO.writeStreamTo(this.getClass().getResourceAsStream("/edu/xtec/resources/icons/thumb-base.jpg"), new FileOutputStream(new File(outputPath, "project-thumb.jpg")));
                    fileList.add("project-thumb.jpg");
                    json.put("thumbnail", "project-thumb.jpg");
                    exportDlg.ps.println("Generating project.json");
                    fileList.add("project.json");
                    Collections.sort(fileList);
                    fileList = new ArrayList<String>(new LinkedHashSet<String>(fileList));
                    json.append("files", fileList);
                    fos = new FileOutputStream(new File(outputPath, "project.json"));
                    pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                    pw.print(json.toString(2));
                    pw.flush();
                    pw.close();
                    exportDlg.ps.println("Generating imsmanifest.xml");
                    fos = new FileOutputStream(new File(outputPath, "imsmanifest.xml"));
                    pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                    s = imsmanifest.replaceAll("%SCORMTITLE%", StrUtils.safeHtml(project.settings.title));
                    s = StrUtils.replace(s, "%SCORMID%", "JClic-" + Integer.toHexString((int)(Math.random() * 1.5728639E7 + 1048576.0)).toUpperCase());
                    StringBuilder sb = new StringBuilder();
                    ListIterator<String> it = fileList.listIterator();
                    while (it.hasNext()) {
                        sb.append("   <file href=\"").append(it.next()).append("\"/>\n");
                    }
                    s = StrUtils.replace(s, "%FILETAGS%", sb.toString());
                    pw.print(s);
                    pw.flush();
                    pw.close();
                    if (scormFile != null) {
                        byte[] BUFFER = new byte[1024];
                        exportDlg.ps.println("Generating file \"" + scormFile + "\" with all content inside");
                        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(scormFile));
                        it = fileList.listIterator();
                        while (it.hasNext()) {
                            int i;
                            String file = it.next();
                            FileInputStream in = new FileInputStream(new File(outputPath, file));
                            ZipEntry entry = new ZipEntry(file);
                            out.putNextEntry(entry);
                            while ((i = in.read(BUFFER)) != -1) {
                                out.write(BUFFER, 0, i);
                            }
                            out.closeEntry();
                        }
                        out.close();
                    }
                    exportDlg.ps.println("\n" + msg.get("export_project_finished") + " " + outputPath);
                    exportDlg.ps.println("\n" + msg.get("export_project_notice"));
                    if (scormFile != null) {
                        exportDlg.ps.printf("\n" + msg.get("export_project_scorm_notice") + "\n\n", scormFile);
                    }
                    exportDlg.browserBtn.setEnabled(true);
                }
                catch (InterruptedException iex) {
                    exportDlg.ps.println("\nWARNING: The process was interrupted! Contents of the output folder might be unsuitable.");
                }
                catch (Exception ex) {
                    exportDlg.ps.println("\nERROR processing ZIP file: " + ex.getMessage());
                }
                return null;
            }

            @Override
            public void finished() {
                exportDlg.cancelBtn.setText(msg.get("OK"));
                exportDlg.copyBtn.setEnabled(true);
                exportDlg.sw = null;
            }
        };
        exportDlg.sw.start();
        dlg.setVisible(true);
    }
}

