/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.beans.EventSoundsButton;
import edu.xtec.jclic.beans.RollPanel;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.AuthorEditPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.OrganizationEditPanel;
import edu.xtec.jclic.project.ProjectSettings;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.jclic.project.Revision;
import edu.xtec.jclic.project.RevisionEditPanel;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class ProjectSettingsEditorPanel
extends EditorPanel {
    private static JScrollPane langListPanel;
    private static JList langList;
    private AuthorEditPanel authorEditPanel;
    private OrganizationEditPanel organizationEditPanel;
    private RevisionEditPanel revisionEditPanel;
    private JTextField areaText;
    private RollPanel authPanel;
    private TextListEditor authorListEditor;
    private RollPanel descPanel;
    private JTextPane descText;
    private RollPanel descrPanel;
    private JTextField descriptorsText;
    private EventSoundsButton evSoundsBtn;
    private TextListEditor langListEditor;
    private JTextField levelText;
    private JPanel mainPanel;
    private TextListEditor orgListEditor;
    private TextListEditor revListEditor;
    private JScrollPane scroll;
    private JComboBox skinCombo;
    private JTextField titleText;
    private RollPanel uiPanel;

    public ProjectSettingsEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.evSoundsBtn.setOptions(options);
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.mainPanel = new JPanel();
        this.descrPanel = new RollPanel();
        JLabel titleLb = new JLabel();
        this.titleText = new JTextField();
        JLabel descLb = new JLabel();
        JScrollPane descScroll = new JScrollPane();
        this.descText = new JTextPane();
        this.authPanel = new RollPanel();
        JLabel authorLb = new JLabel();
        this.authorListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editAuthor(currentValue, newValue);
            }
        };
        JLabel orgLb = new JLabel();
        this.orgListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editOrg(currentValue, newValue);
            }
        };
        JLabel revLb = new JLabel();
        this.revListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editRevision(currentValue, newValue);
            }
        };
        this.descPanel = new RollPanel();
        JLabel levelLb = new JLabel();
        this.levelText = new JTextField();
        JLabel areaLb = new JLabel();
        this.areaText = new JTextField();
        JLabel descriptorslLb = new JLabel();
        this.descriptorsText = new JTextField();
        JLabel langLb = new JLabel();
        this.langListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return ProjectSettingsEditorPanel.this.editLanguage(currentValue, newValue);
            }
        };
        this.uiPanel = new RollPanel();
        JLabel skinLb = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(false));
        this.skinCombo.setSelectedItem(null);
        JLabel evSoundsLb = new JLabel();
        this.evSoundsBtn = new EventSoundsButton();
        JLabel spacer = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.descrPanel.getMainPanel().setLayout(new GridBagLayout());
        this.descrPanel.setTitle(this.options.getMsg("edit_project_description_block"));
        titleLb.setLabelFor(this.titleText);
        titleLb.setText(this.options.getMsg("edit_project_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)titleLb, gridBagConstraints);
        this.titleText.setToolTipText(this.options.getMsg("edit_project_title_tooltip"));
        this.titleText.setPreferredSize(new Dimension(400, 21));
        this.titleText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)this.titleText, gridBagConstraints);
        descLb.setText(this.options.getMsg("edit_project_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)descLb, gridBagConstraints);
        descScroll.setHorizontalScrollBarPolicy(31);
        descScroll.setPreferredSize(new Dimension(400, 100));
        this.descText.setToolTipText(this.options.getMsg("edit_project_description_tooltip"));
        this.descText.getDocument().addDocumentListener(this);
        descScroll.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descrPanel.getMainPanel().add((Component)descScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descrPanel, gridBagConstraints);
        this.authPanel.getMainPanel().setLayout(new GridBagLayout());
        this.authPanel.setTitle(this.options.getMsg("edit_project_author_group"));
        authorLb.setLabelFor(this.authorListEditor);
        authorLb.setText(this.options.getMsg("edit_project_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)authorLb, gridBagConstraints);
        this.authorListEditor.setToolTipText(this.options.getMsg("edit_project_authors_tooltip"));
        this.authorListEditor.setPreferredSize(new Dimension(400, 80));
        this.authorListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.authPanel.getMainPanel().add((Component)this.authorListEditor, gridBagConstraints);
        orgLb.setLabelFor(this.orgListEditor);
        orgLb.setText(this.options.getMsg("edit_project_org"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)orgLb, gridBagConstraints);
        this.orgListEditor.setToolTipText(this.options.getMsg("edit_project_org_tooltip"));
        this.orgListEditor.setPreferredSize(new Dimension(400, 80));
        this.orgListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.orgListEditor, gridBagConstraints);
        revLb.setLabelFor(this.revListEditor);
        revLb.setText(this.options.getMsg("edit_project_rev"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authPanel.getMainPanel().add((Component)revLb, gridBagConstraints);
        this.revListEditor.setToolTipText(this.options.getMsg("edit_project_rev_tooltip"));
        this.revListEditor.setPreferredSize(new Dimension(400, 80));
        this.revListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.authPanel.getMainPanel().add((Component)this.revListEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.authPanel, gridBagConstraints);
        this.descPanel.getMainPanel().setLayout(new GridBagLayout());
        this.descPanel.setTitle(this.options.getMsg("edit_project_descriptors_block"));
        levelLb.setLabelFor(this.levelText);
        levelLb.setText(this.options.getMsg("edit_project_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)levelLb, gridBagConstraints);
        this.levelText.setToolTipText(this.options.getMsg("edit_project_level_tooltip"));
        this.levelText.setPreferredSize(new Dimension(400, 21));
        this.levelText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.levelText, gridBagConstraints);
        areaLb.setLabelFor(this.areaText);
        areaLb.setText(this.options.getMsg("edit_project_area"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)areaLb, gridBagConstraints);
        this.areaText.setToolTipText(this.options.getMsg("edit_project_area_tooltip"));
        this.areaText.setPreferredSize(new Dimension(400, 21));
        this.areaText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.areaText, gridBagConstraints);
        descriptorslLb.setLabelFor(this.descriptorsText);
        descriptorslLb.setText(this.options.getMsg("edit_project_descriptors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)descriptorslLb, gridBagConstraints);
        this.descriptorsText.setToolTipText(this.options.getMsg("edit_project_descriptors_tooltip"));
        this.descriptorsText.setPreferredSize(new Dimension(400, 21));
        this.descriptorsText.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)this.descriptorsText, gridBagConstraints);
        langLb.setLabelFor(this.langListEditor);
        langLb.setText(this.options.getMsg("edit_project_languages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.descPanel.getMainPanel().add((Component)langLb, gridBagConstraints);
        this.langListEditor.setToolTipText(this.options.getMsg("edit_project_languages_tooltip"));
        this.langListEditor.setPreferredSize(new Dimension(200, 80));
        this.langListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.descPanel.getMainPanel().add((Component)this.langListEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descPanel, gridBagConstraints);
        this.uiPanel.getMainPanel().setLayout(new GridBagLayout());
        this.uiPanel.setTitle(this.options.getMsg("edit_project_ui_block"));
        skinLb.setLabelFor(this.skinCombo);
        skinLb.setText(this.options.getMsg("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)skinLb, gridBagConstraints);
        this.skinCombo.setToolTipText(this.options.getMsg("settings_skin_tooltip"));
        this.skinCombo.setEditable(true);
        this.skinCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.skinCombo, gridBagConstraints);
        evSoundsLb.setLabelFor(this.revListEditor);
        evSoundsLb.setText(this.options.getMsg("edit_project_evsounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)evSoundsLb, gridBagConstraints);
        this.evSoundsBtn.setToolTipText(this.options.getMsg("edit_project_evsounds_tooltip"));
        this.evSoundsBtn.addPropertyChangeListener("eventSounds", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.uiPanel.getMainPanel().add((Component)this.evSoundsBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.uiPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)spacer, gridBagConstraints);
        this.scroll.setViewportView(this.mainPanel);
        this.add((Component)this.scroll, "Center");
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ProjectSettingsEditor;
    }

    protected ProjectSettingsEditor getProjectSettingsEditor() {
        return (ProjectSettingsEditor)this.getEditor();
    }

    protected ProjectSettings getProjectSettings() {
        ProjectSettings result = null;
        ProjectSettingsEditor pse = this.getProjectSettingsEditor();
        if (pse != null) {
            result = pse.getProjectSettings();
        }
        return result;
    }

    @Override
    protected void fillData() {
        int n;
        JClicProjectEditor prjed;
        ProjectSettings ps = this.getProjectSettings();
        JClicProjectEditor jClicProjectEditor = prjed = ps == null ? null : this.getProjectSettingsEditor().getProjectEditor();
        if (prjed != null) {
            this.evSoundsBtn.setMediaBagEditor(prjed.getMediaBagEditor());
        }
        this.evSoundsBtn.setEventSounds(ps == null ? null : ps.eventSounds);
        this.titleText.setText(ps == null || ps.title == null ? this.options.getMsg("UNNAMED") : ps.title);
        this.descText.setText(ps == null ? "" : StrUtils.secureString(ps.description));
        this.areaText.setText(ps == null ? "" : StrUtils.secureString(ps.area));
        this.levelText.setText(ps == null ? "" : StrUtils.secureString(ps.level));
        this.descriptorsText.setText(ps == null ? "" : StrUtils.secureString(ps.descriptors));
        this.skinCombo.setSelectedItem(ps == null ? null : ps.skinFileName);
        ArrayList<Object> v = new ArrayList<Object>();
        if (ps != null && ps.languages != null) {
            for (int i = 0; i < ps.languages.length; ++i) {
                String code = (String)Messages.getNamesToCodes().get(ps.languages[i].toLowerCase());
                if (code != null) {
                    v.add(Messages.getDescriptiveLanguageCode(code));
                    continue;
                }
                v.add(ps.languages[i]);
            }
        }
        this.langListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.authors != null) {
            Author[] authorArray = ps.authors;
            int n2 = authorArray.length;
            for (n = 0; n < n2; ++n) {
                Author a = authorArray[n];
                v.add(a);
            }
        }
        this.authorListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.organizations != null) {
            Organization[] organizationArray = ps.organizations;
            int n3 = organizationArray.length;
            for (n = 0; n < n3; ++n) {
                Organization o = organizationArray[n];
                v.add(o);
            }
        }
        this.orgListEditor.setListData(v);
        v.clear();
        if (ps != null && ps.revisions != null) {
            for (Revision r : ps.revisions) {
                v.add(r);
            }
        }
        this.revListEditor.setListData(v);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.evSoundsBtn.setEnabled(enabled);
        this.titleText.setEnabled(enabled);
        this.descText.setEnabled(enabled);
        this.areaText.setEnabled(enabled);
        this.levelText.setEnabled(enabled);
        this.descriptorsText.setEnabled(enabled);
        this.skinCombo.setEnabled(enabled);
        this.langListEditor.setEnabled(enabled);
        this.authorListEditor.setEnabled(enabled);
        this.orgListEditor.setEnabled(enabled);
        this.revListEditor.setEnabled(enabled);
    }

    @Override
    protected void saveData() {
        ProjectSettings ps = this.getProjectSettings();
        if (ps != null) {
            ps.title = StrUtils.secureString(this.titleText.getText(), this.options.getMsg("UNNAMED"));
            ps.description = StrUtils.nullableString(this.descText.getText());
            List<Object> v = this.authorListEditor.getListData();
            ps.authors = v.toArray(new Author[v.size()]);
            v = this.orgListEditor.getListData();
            ps.organizations = v.toArray(new Organization[v.size()]);
            v = this.revListEditor.getListData();
            ps.revisions = v.toArray(new Revision[v.size()]);
            ps.level = StrUtils.nullableString(this.levelText.getText());
            ps.area = StrUtils.nullableString(this.areaText.getText());
            ps.descriptors = StrUtils.nullableString(this.descriptorsText.getText());
            String[] langs = this.langListEditor.getTextList();
            ps.languages = new String[langs.length];
            for (int i = 0; i < langs.length; ++i) {
                String ln = langs[i];
                int p = ln.length();
                if (p > 5) {
                    String code = ln.substring(p - 3, p - 1);
                    ln = (String)Messages.getNamesToCodes().get(code);
                }
                ps.languages[i] = ln == null ? langs[i] : ln;
            }
            ps.skinFileName = StrUtils.nullableString(this.skinCombo.getSelectedItem());
            EventSounds evs = this.evSoundsBtn.getEventSounds();
            ps.eventSounds = evs == null ? new EventSounds(null) : evs;
        }
    }

    private Object editLanguage(final Object currentValue, boolean newValue) {
        if (langList == null || langListPanel == null) {
            langList = new JList<String>(this.options.getMessages().getDescriptiveLanguageCodes());
            langListPanel = new JScrollPane(langList);
        }
        Object result = null;
        if (!newValue && currentValue != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    langList.setSelectedValue(currentValue, true);
                }
            });
        } else {
            langList.setSelectedIndex(-1);
        }
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_languages_select"}, null, new JComponent[]{langListPanel}, newValue ? "edit_project_languages_add" : "edit_project_languages_modify")) {
            result = langList.getSelectedValue();
        }
        return result;
    }

    private Object editAuthor(Object currentValue, boolean newValue) {
        Author result = null;
        if (this.authorEditPanel == null) {
            this.authorEditPanel = new AuthorEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.authorEditPanel.setAuthor((Author)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_author_info"}, null, new JComponent[]{this.authorEditPanel}, newValue ? "edit_project_author_add" : "edit_project_author_edit")) {
            result = this.authorEditPanel.getAuthor();
            if (result.name.length() < 1) {
                result = null;
            }
        }
        return result;
    }

    private Object editOrg(Object currentValue, boolean newValue) {
        Organization result = null;
        if (this.organizationEditPanel == null) {
            this.organizationEditPanel = new OrganizationEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.organizationEditPanel.setOrganization((Organization)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_org_info"}, null, new JComponent[]{this.organizationEditPanel}, newValue ? "edit_project_org_add" : "edit_project_org_edit")) {
            result = this.organizationEditPanel.getOrganization();
            if (result.name.length() < 1) {
                result = null;
            }
        }
        return result;
    }

    private Object editRevision(Object currentValue, boolean newValue) {
        Revision result = null;
        if (this.revisionEditPanel == null) {
            this.revisionEditPanel = new RevisionEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.revisionEditPanel.setRevision((Revision)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_rev_info"}, null, new JComponent[]{this.revisionEditPanel}, newValue ? "edit_project_rev_add" : "edit_project_rev_edit") && (result = this.revisionEditPanel.getRevision()) != null && result.description.length() < 1) {
            result = null;
        }
        return result;
    }
}

