/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableCubicCurve2D;
import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableQuadCurve2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class EditableEllipse2D
extends EditableRectangle
implements Cloneable {
    public EditableEllipse2D(Point2D ini, Point2D end) {
        super(ini, end);
    }

    public EditableEllipse2D(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void paintWithColor(Graphics g, int drawingMode, Color c) {
        g.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(g);
        if (this.selected) {
            this.paintSelection(g);
        } else if (drawingMode == 4) {
            g.setColor(Color.red);
            this.drawBorders(g);
            g.setColor(c);
        } else {
            g.setColor(c);
        }
        g.drawOval((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    public boolean contains(double x, double y) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).contains(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).getPathIterator(at);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()).intersects(x, y, w, h);
    }

    @Override
    public EditableShape[] divide(double x, double y, boolean b) {
        return this.divide(x, y);
    }

    @Override
    public EditableShape[] divide(double x, double y) {
        EditableShape[] shapes = new EditableShape[10];
        int currentShape = 0;
        double currentX = 0.0;
        double currentY = 0.0;
        PathIterator pi = this.getPathIterator(new AffineTransform());
        while (!pi.isDone()) {
            double[] points = new double[6];
            int type = pi.currentSegment(points);
            switch (type) {
                case 0: {
                    currentX = points[0];
                    currentY = points[1];
                    break;
                }
                case 1: {
                    shapes[currentShape] = new EditableLine2D(currentX, currentY, points[0], points[1]);
                    ++currentShape;
                    currentX = points[0];
                    currentY = points[1];
                    break;
                }
                case 3: {
                    shapes[currentShape] = new EditableCubicCurve2D(currentX, currentY, points[0], points[1], points[2], points[3], points[4], points[5]);
                    ++currentShape;
                    currentX = points[4];
                    currentY = points[5];
                    break;
                }
                case 2: {
                    shapes[currentShape] = new EditableQuadCurve2D(currentX, currentY, points[0], points[1], points[2], points[3]);
                    ++currentShape;
                    currentX = points[2];
                    currentY = points[3];
                }
            }
            pi.next();
        }
        return shapes;
    }

    public Ellipse2D getEllipse() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public Object clone() {
        return new EditableEllipse2D(this.getLocation(), new Point2D.Double(this.getLocation().getX() + this.getWidth(), this.getLocation().getY() + this.getHeight()));
    }
}

