/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public class EditableQuadCurve2D
extends QuadCurve2D.Double
implements EditableShape {
    private boolean selected = false;
    private int border = -1;
    private int selectedBorder = -1;

    public EditableQuadCurve2D(QuadCurve2D curve) {
        this.setCurve(curve);
    }

    public EditableQuadCurve2D(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        super(x1, y1, ctrlx, ctrly, x2, y2);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isInto(Rectangle2D r) {
        return r.contains(this.getP1()) || r.contains(this.getP2()) || r.contains(this.getCtrlPt());
    }

    @Override
    public void drawBorders(Graphics g) {
        if (this.getP1().getX() != -1.0) {
            g.drawRect((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        if (this.getP2().getX() != -1.0) {
            g.drawRect((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        if (this.getCtrlPt().getX() != -1.0) {
            g.fillRect((int)this.getCtrlPt().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlPt().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
        g.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            g.fillRect((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            g.fillRect((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    @Override
    public boolean hasClickedBorder(double x, double y, boolean needSelected) {
        boolean hasClicked = false;
        if (!needSelected || this.selected) {
            Rectangle r1 = new Rectangle((int)this.getP1().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP1().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r2 = new Rectangle((int)this.getP2().getX() - EditableShapeConstants.selectLength / 2, (int)this.getP2().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r3 = new Rectangle((int)this.getCtrlPt().getX() - EditableShapeConstants.selectLength / 2, (int)this.getCtrlPt().getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (r1.contains(x, y)) {
                this.border = 1;
                hasClicked = true;
            } else if (r2.contains(x, y)) {
                this.border = 2;
                hasClicked = true;
            } else if (r3.contains(x, y)) {
                this.border = 3;
                hasClicked = true;
            }
        }
        return hasClicked;
    }

    @Override
    public void aproximateNearestBorder(double x, double y) {
        if (this.hasClickedBorder(x, y, false)) {
            this.changeBorder(x, y);
        }
    }

    @Override
    public Point2D getNearestBorder(double x, double y) {
        Point2D p1;
        double d1 = this.getP1().distance(x, y);
        double d2 = this.getP2().distance(x, y);
        double d3 = this.getCtrlPt().distance(x, y);
        if (d1 < d2) {
            p1 = this.getP1();
        } else {
            p1 = this.getP2();
            d1 = d2;
        }
        if (d3 < d1) {
            p1 = this.getCtrlPt();
        }
        return p1;
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public void changeBorder(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        if (this.border == 1) {
            this.setCurve(p, this.getCtrlPt(), this.getP2());
        } else if (this.border == 2) {
            this.setCurve(this.getP1(), this.getCtrlPt(), p);
        } else {
            this.setCurve(this.getP1(), p, this.getP2());
        }
    }

    @Override
    public double distanceTo(double x, double y) {
        double d1 = this.getNearestBorder(x, y).distance(x, y);
        double d2 = new Line2D.Double(this.getP1(), this.getP2()).ptSegDist(x, y);
        return Math.min(d1, d2);
    }

    @Override
    public void paintWithColor(Graphics g, int drawingMode, Color c) {
        g.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(g);
        if (this.selected) {
            this.paintSelection(g);
        } else if (drawingMode == 4) {
            g.setColor(Color.red);
            this.drawBorders(g);
            g.setColor(c);
        } else {
            g.setColor(c);
        }
        ((Graphics2D)g).draw(this);
    }

    @Override
    public void paint(Graphics g, int drawingMode) {
        this.paintWithColor(g, drawingMode, EditableShapeConstants.defaultColor);
    }

    @Override
    public void paintSelection(Graphics g) {
        g.setColor(Color.black);
        this.drawBorders(g);
        g.setColor(EditableShapeConstants.selectedColor);
    }

    public void move(double incX, double incY) {
        this.setCurve(this.getP1().getX() + incX, this.getP1().getY() + incY, this.getCtrlX() + incX, this.getCtrlY() + incY, this.getP2().getX() + incX, this.getP2().getY() + incY);
    }

    @Override
    public void transform(AffineTransform aTransf) {
        Point2D p1 = this.getP1();
        Point2D p2 = this.getCtrlPt();
        Point2D p3 = this.getP2();
        aTransf.transform(p1, p1);
        aTransf.transform(p2, p2);
        aTransf.transform(p3, p3);
        this.setCurve(p1, p2, p3);
    }

    @Override
    public EditableShape[] divide(double x, double y) {
        EditableShape[] newShapes = new EditableShape[2];
        QuadCurve2D.Double left = new QuadCurve2D.Double();
        QuadCurve2D.Double right = new QuadCurve2D.Double();
        this.subdivide(left, right);
        newShapes[0] = new EditableQuadCurve2D(left);
        newShapes[1] = new EditableQuadCurve2D(right);
        return newShapes;
    }

    @Override
    public boolean isAdjacentTo(Point2D p) {
        if (this.getP1().equals(p)) {
            return true;
        }
        if (this.getP2().equals(p)) {
            this.setCurve(this.getP2(), this.getCtrlPt(), this.getP1());
            return true;
        }
        return false;
    }

    @Override
    public Point2D getEndPoint() {
        return this.getP2();
    }

    @Override
    public Point2D getInitialPoint() {
        return this.getP1();
    }

    @Override
    public Object clone() {
        return new EditableQuadCurve2D(this);
    }

    @Override
    public Point2D[] getBorders() {
        return new Point2D[]{this.getP1(), this.getP2(), this.getCtrlPt()};
    }

    @Override
    public void selectBorder(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.selectedBorder = this.getP1().equals(p) ? 1 : (this.getP2().equals(p) ? 2 : -1);
    }

    @Override
    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    @Override
    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    @Override
    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.getP2();
        }
        return this.getP1();
    }
}

