/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Options;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Attribute;
import org.jdom.Element;

public class JDomTreeObject
extends AbstractTableModel {
    Element element;
    Options options;

    JDomTreeObject(Element element, Options options) {
        this.element = element;
        this.options = options;
    }

    @Override
    public String getColumnName(int column) {
        return this.options.getMsg(column == 0 ? "XML_ATTRIBUTE" : "XML_VALUE");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        if (rowIndex == 0) {
            if (this.element.getChildren().isEmpty()) {
                this.element.setText(aValue.toString());
            } else {
                this.options.getMessages().showAlert(this.options.getMainComponent(), "XML_NOT_EDITABLE");
            }
        } else {
            Attribute atr = (Attribute)this.element.getAttributes().get(rowIndex - 1);
            atr.setValue(aValue.toString());
        }
    }

    @Override
    public int getRowCount() {
        return 1 + this.element.getAttributes().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row == 0) {
            return column == 0 ? this.options.getMsg("XML_TEXT") : this.element.getText();
        }
        Attribute atr = (Attribute)this.element.getAttributes().get(row - 1);
        return column == 0 ? atr.getName() : atr.getValue();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.element.getName());
        Attribute atr = this.element.getAttribute("name");
        if (atr != null) {
            result.append(" ").append(atr.getValue());
        }
        if ((atr = this.element.getAttribute("id")) != null) {
            result.append(" - ").append(atr.getValue());
        }
        if ((atr = this.element.getAttribute("type")) != null) {
            result.append(" - ").append(atr.getValue());
        }
        return result.substring(0);
    }

    public static DefaultMutableTreeNode processNode(DefaultMutableTreeNode parent, Element element, Options options) {
        JDomTreeObject te = new JDomTreeObject(element, options);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(te);
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            JDomTreeObject.processNode(node, (Element)iter.next(), options);
        }
        if (parent != null) {
            parent.add(node);
        }
        return node;
    }

    public Element getElement() {
        return this.element;
    }
}

