/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.svg.SVGStyleElement;

public class SVGOMStyleElement
extends SVGOMElement
implements CSSStyleSheetNode,
SVGStyleElement,
LinkStyle {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(1);
    protected transient org.w3c.dom.stylesheets.StyleSheet sheet;
    protected transient StyleSheet styleSheet;
    protected transient EventListener domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();

    protected SVGOMStyleElement() {
    }

    public SVGOMStyleElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "style";
    }

    public StyleSheet getCSSStyleSheet() {
        if (this.styleSheet == null && this.getType().equals("text/css")) {
            StringBuffer stringBuffer;
            SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)this.getOwnerDocument());
            CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
            String string = "";
            Node node = this.getFirstChild();
            if (node != null) {
                stringBuffer = new StringBuffer();
                while (node != null) {
                    if (node.getNodeType() == 4 || node.getNodeType() == 3) {
                        stringBuffer.append(node.getNodeValue());
                    }
                    node = node.getNextSibling();
                }
                string = stringBuffer.toString();
            }
            stringBuffer = null;
            String string2 = this.getBaseURI();
            if (string2 != null) {
                stringBuffer = new ParsedURL(string2);
            }
            String string3 = this.getAttributeNS(null, "media");
            this.styleSheet = cSSEngine.parseStyleSheet(string, (ParsedURL)stringBuffer, string3);
            this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedListener, false, null);
        }
        return this.styleSheet;
    }

    public org.w3c.dom.stylesheets.StyleSheet getSheet() {
        throw new UnsupportedOperationException("LinkStyle.getSheet() is not implemented");
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String string) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public String getType() {
        return this.getAttributeNS(null, "type");
    }

    public void setType(String string) throws DOMException {
        this.setAttributeNS(null, "type", string);
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String string) throws DOMException {
        this.setAttribute("media", string);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String string) throws DOMException {
        this.setAttribute("title", string);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMStyleElement();
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/XML/1998/namespace", "xml", "space", "preserve");
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event event) {
            SVGOMStyleElement.this.styleSheet = null;
        }
    }
}

