/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class NamedKeyStrokeArrayConfigurer
extends Configurer {
    private List<NamedHotKeyConfigurer> configs = new ArrayList<NamedHotKeyConfigurer>();
    private Box controls;
    private JPanel panel;

    public NamedKeyStrokeArrayConfigurer(String string, String string2) {
        super(string, string2);
    }

    public NamedKeyStrokeArrayConfigurer(String string, String string2, NamedKeyStroke[] namedKeyStrokeArray) {
        super(string, string2, namedKeyStrokeArray);
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.controls = Box.createVerticalBox();
            JScrollPane jScrollPane = new JScrollPane(this.controls);
            Box box = Box.createHorizontalBox();
            this.controls.add(box);
            JLabel jLabel = new JLabel(this.getName());
            box.add(jLabel);
            JButton jButton = new JButton("Add");
            box.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NamedKeyStrokeArrayConfigurer.this.addKey(null);
                }
            });
            this.panel.add((Component)jScrollPane, "Center");
            NamedKeyStroke[] namedKeyStrokeArray = (NamedKeyStroke[])this.value;
            if (namedKeyStrokeArray != null) {
                for (int i = 0; i < namedKeyStrokeArray.length; ++i) {
                    this.addKey(namedKeyStrokeArray[i]);
                }
            }
            this.addKey(null);
        }
        return this.panel;
    }

    private void addKey(NamedKeyStroke namedKeyStroke) {
        NamedHotKeyConfigurer namedHotKeyConfigurer = new NamedHotKeyConfigurer(null, null, namedKeyStroke);
        this.configs.add(namedHotKeyConfigurer);
        this.controls.add(namedHotKeyConfigurer.getControls());
        if (this.configs.size() > 5) {
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 150));
        } else {
            this.panel.setPreferredSize(null);
        }
        Window window = SwingUtilities.getWindowAncestor(this.controls);
        if (window != null) {
            window.pack();
        }
    }

    public String getValueString() {
        return NamedKeyStrokeArrayConfigurer.encode(this.getKeyStrokes());
    }

    public void setValue(String string) {
        this.setValue(NamedKeyStrokeArrayConfigurer.decode(string));
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.controls != null) {
            int n;
            NamedKeyStroke[] namedKeyStrokeArray = (NamedKeyStroke[])object;
            if (namedKeyStrokeArray == null) {
                namedKeyStrokeArray = new NamedKeyStroke[]{};
            }
            for (n = 0; n < namedKeyStrokeArray.length; ++n) {
                if (n > this.configs.size()) {
                    this.addKey(namedKeyStrokeArray[n]);
                    continue;
                }
                this.configs.get(n).setValue(namedKeyStrokeArray[n]);
            }
            for (n = namedKeyStrokeArray.length; n < this.configs.size(); ++n) {
                this.configs.get(n).setValue(null);
            }
        }
    }

    public NamedKeyStroke[] getKeyStrokes() {
        ArrayList<NamedKeyStroke> arrayList = new ArrayList<NamedKeyStroke>();
        for (NamedHotKeyConfigurer namedHotKeyConfigurer : this.configs) {
            NamedKeyStroke namedKeyStroke = namedHotKeyConfigurer.getValueNamedKeyStroke();
            if (namedKeyStroke == null) continue;
            arrayList.add(namedKeyStroke);
        }
        return arrayList.toArray(new NamedKeyStroke[arrayList.size()]);
    }

    public static NamedKeyStroke[] decode(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<NamedKeyStroke> arrayList = new ArrayList<NamedKeyStroke>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        while (decoder.hasMoreTokens()) {
            String string2 = decoder.nextToken();
            if (string2 == "") continue;
            arrayList.add(NamedHotKeyConfigurer.decode(string2));
        }
        return arrayList.toArray(new NamedKeyStroke[arrayList.size()]);
    }

    public static String encode(NamedKeyStroke[] namedKeyStrokeArray) {
        if (namedKeyStrokeArray == null) {
            return null;
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < namedKeyStrokeArray.length; ++i) {
            NamedKeyStroke namedKeyStroke = namedKeyStrokeArray[i];
            if (namedKeyStroke.isNull()) continue;
            sequenceEncoder.append(NamedHotKeyConfigurer.encode(namedKeyStroke));
        }
        return sequenceEncoder.getValue() != null ? sequenceEncoder.getValue() : "";
    }
}

