/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ReadOnlyPrefs {
    protected Properties storedValues = new Properties();

    public ReadOnlyPrefs(String string) {
        this(new File(Info.getPrefsDir(), Prefs.sanitize(string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReadOnlyPrefs(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.storedValues.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtils.closeQuietly(bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                ReadErrorDialog.error(iOException, file);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
    }

    public String getStoredValue(String string) {
        return this.storedValues.getProperty(string);
    }

    public static ReadOnlyPrefs getGlobalPrefs() {
        return new ReadOnlyPrefs(new File(Info.getPrefsDir(), "V_Global"));
    }
}

