/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.lang.SystemUtils;

public class ApplicationIcons {
    public static final String VASSAL_ICON_LARGE = "VASSAL-256x256.png";
    private static final Method setIconImages;
    private static final List<BufferedImage> icons;

    private ApplicationIcons() {
    }

    public static void setFor(JFrame jFrame) {
        if (icons == null) {
            return;
        }
        if (setIconImages != null) {
            ApplicationIcons.setIconImages(jFrame);
        } else {
            jFrame.setIconImage(icons.get(0));
        }
    }

    public static void setFor(JDialog jDialog) {
        if (icons == null) {
            return;
        }
        if (setIconImages != null) {
            ApplicationIcons.setIconImages(jDialog);
        }
    }

    private static void setIconImages(Window window) {
        try {
            setIconImages.invoke((Object)window, icons);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorDialog.bug(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorDialog.bug(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorDialog.bug(invocationTargetException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ErrorDialog.bug(exceptionInInitializerError);
        }
    }

    static {
        if (SystemUtils.IS_OS_MAC_OSX) {
            setIconImages = null;
            icons = null;
        } else {
            Method method = null;
            try {
                method = Window.class.getMethod("setIconImages", List.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            setIconImages = method;
            List<BufferedImage> list = null;
            try {
                if (setIconImages != null) {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        BufferedImage bufferedImage = ImageUtils.getImageResource("/icons/22x22/VASSAL.png");
                        BufferedImage bufferedImage2 = ImageUtils.createCompatibleTranslucentImage(24, 24);
                        Graphics2D graphics2D = bufferedImage2.createGraphics();
                        graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
                        graphics2D.dispose();
                        list = Arrays.asList(ImageUtils.getImageResource("/icons/16x16/VASSAL.png"), bufferedImage2, ImageUtils.getImageResource("/icons/32x32/VASSAL.png"), ImageUtils.getImageResource("/icons/48x48/VASSAL.png"), ImageUtils.getImageResource("/images/VASSAL-256x256.png"));
                    } else {
                        list = Arrays.asList(ImageUtils.getImageResource("/icons/16x16/VASSAL.png"), ImageUtils.getImageResource("/icons/22x22/VASSAL.png"), ImageUtils.getImageResource("/icons/32x32/VASSAL.png"), ImageUtils.getImageResource("/icons/48x48/VASSAL.png"));
                    }
                } else {
                    list = Collections.singletonList(ImageUtils.getImageResource("/icons/16x16/VASSAL.png"));
                }
            }
            catch (ImageIOException imageIOException) {
                ReadErrorDialog.error((IOException)imageIOException, imageIOException.getFile());
            }
            icons = list;
        }
    }
}

