/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.launch.Launcher;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipFile;

public class ArchiveWriter
extends DataArchive {
    private String archiveName;
    private boolean isTempArchive = false;

    public ArchiveWriter(String string) {
        this.archiveName = string;
        if (this.archiveName == null) {
            this.isTempArchive = true;
            try {
                this.archiveName = File.createTempFile("tmp", ".zip").getPath();
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, this.archiveName);
            }
        }
        File file = new File(this.archiveName);
        try {
            if (file.exists()) {
                try {
                    this.archive = new ZipArchive(this.archiveName);
                }
                catch (IOException iOException) {
                    this.archive = new ZipArchive(this.archiveName, true);
                }
            } else {
                this.archive = new ZipArchive(this.archiveName);
            }
        }
        catch (IOException iOException) {
            this.archive = null;
            WriteErrorDialog.error(iOException, this.archiveName);
        }
    }

    public ArchiveWriter(FileArchive fileArchive) {
        this.archiveName = fileArchive.getName();
        this.archive = fileArchive;
    }

    @Deprecated
    public ArchiveWriter(ZipFile zipFile) {
        this.archiveName = zipFile.getName();
        try {
            this.archive = new ZipArchive(this.archiveName);
        }
        catch (IOException iOException) {
            zipFile = null;
            WriteErrorDialog.error(iOException, this.archiveName);
        }
    }

    public void addImage(String string, String string2) {
        if (string2.toLowerCase().endsWith(".svg")) {
            List<String> list = null;
            try {
                list = SVGImageUtils.getExternalReferences(string);
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, string2);
                return;
            }
            for (String string3 : list) {
                File file = new File(string3);
                byte[] byArray = null;
                try {
                    byArray = SVGImageUtils.relativizeExternalReferences(string3);
                }
                catch (IOException iOException) {
                    ReadErrorDialog.error(iOException, file);
                    continue;
                }
                this.addFile(this.imageDir + file.getName(), byArray);
            }
        } else {
            this.addFile(string, this.imageDir + string2);
        }
        Op.load(string2).update();
        this.localImages = null;
    }

    public void addImage(String string, byte[] byArray) {
        this.addFile(this.imageDir + string, byArray);
        this.localImages = null;
    }

    public void addSound(String string, String string2) {
        this.addFile(string, this.soundDir + string2);
    }

    @Deprecated
    public boolean isImageAdded(String string) {
        try {
            return this.archive.contains(this.imageDir + string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void removeImage(String string) {
        try {
            this.archive.remove(this.imageDir + string);
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, this.archive.getName());
        }
        this.localImages = null;
    }

    public void addFile(String string, String string2) {
        try {
            this.archive.add(string2, string);
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, this.archive.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String string, InputStream inputStream) {
        OutputStream outputStream = null;
        try {
            outputStream = this.archive.getOutputStream(string);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                WriteErrorDialog.error(iOException, this.archive.getName());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void addFile(String string, byte[] byArray) {
        try {
            this.archive.add(string, byArray);
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, this.archive.getName());
        }
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean bl) throws IOException {
        if (this.isTempArchive) {
            this.saveAs(bl);
        } else {
            this.write(this.archive, bl);
        }
    }

    public void saveAs() throws IOException {
        this.saveAs(false);
    }

    protected void write(FileArchive fileArchive, boolean bl) throws IOException {
        fileArchive.flush();
        if (bl) {
            Launcher.getInstance().sendSaveCmd(fileArchive.getFile());
        }
    }

    public void saveAs(boolean bl) throws IOException {
        FileChooser fileChooser = FileChooser.createFileChooser(GameModule.getGameModule().getFrame(), (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        if (fileChooser.showSaveDialog() != 0) {
            return;
        }
        String string = fileChooser.getSelectedFile().getPath();
        if (string != this.archive.getName()) {
            FileArchive fileArchive = this.archive;
            this.archive = new ZipArchive(fileArchive, string);
            this.archiveName = string;
            this.archive.flush();
            fileArchive.revert();
            fileArchive.close();
            this.write(this.archive, bl);
            if (this.isTempArchive) {
                fileArchive.getFile().delete();
                this.isTempArchive = false;
            }
        } else {
            this.write(this.archive, bl);
        }
    }

    @Deprecated
    public void write() throws IOException {
        this.write(false);
    }

    @Deprecated
    public void write(boolean bl) throws IOException {
        this.save(bl);
    }
}

